/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ColorQuantizerType;
import javax.media.jai.operator.JaiI18N;
import javax.media.jai.util.Range;

public class ColorQuantizerDescriptor
extends OperationDescriptorImpl {
    public static final ColorQuantizerType MEDIANCUT = new ColorQuantizerType("MEDIANCUT", 1);
    public static final ColorQuantizerType NEUQUANT = new ColorQuantizerType("NEUQUANT", 2);
    public static final ColorQuantizerType OCTTREE = new ColorQuantizerType("OCTTREE", 3);
    private static final String[][] resources = new String[][]{{"GlobalName", "ColorQuantizer"}, {"LocalName", "ColorQuantizer"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("ColorQuantizerDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ColorQuantizerDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion2")}, {"arg0Desc", JaiI18N.getString("ColorQuantizerDescriptor1")}, {"arg1Desc", JaiI18N.getString("ColorQuantizerDescriptor2")}, {"arg2Desc", JaiI18N.getString("ColorQuantizerDescriptor3")}, {"arg3Desc", JaiI18N.getString("ColorQuantizerDescriptor4")}, {"arg4Desc", JaiI18N.getString("ColorQuantizerDescriptor5")}, {"arg5Desc", JaiI18N.getString("ColorQuantizerDescriptor6")}};
    private static final String[] paramNames = new String[]{"quantizationAlgorithm", "maxColorNum", "upperBound", "roi", "xPeriod", "yPeriod"};
    private static final Class[] paramClasses = new Class[]{ColorQuantizerType.class, Integer.class, Integer.class, ROI.class, Integer.class, Integer.class};
    private static final Object[] paramDefaults;
    private static final String[] supportedModes;

    static {
        Object[] objectArray = new Object[6];
        objectArray[0] = MEDIANCUT;
        objectArray[1] = new Integer(256);
        objectArray[4] = new Integer(1);
        objectArray[5] = new Integer(1);
        paramDefaults = objectArray;
        supportedModes = new String[]{"rendered"};
    }

    public ColorQuantizerDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public Range getParamValueRange(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return new Range(Integer.class, new Integer(1), null);
            }
        }
        return null;
    }

    @Override
    protected boolean validateParameters(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (parameterBlock == null || stringBuffer == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!super.validateParameters(string, parameterBlock, stringBuffer)) {
            return false;
        }
        ColorQuantizerType colorQuantizerType = (ColorQuantizerType)parameterBlock.getObjectParameter(0);
        if (colorQuantizerType != MEDIANCUT && colorQuantizerType != NEUQUANT && colorQuantizerType != OCTTREE) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("ColorQuantizerDescriptor7"));
            return false;
        }
        Integer n = (Integer)parameterBlock.getObjectParameter(2);
        if (n == null) {
            int n2 = 0;
            if (colorQuantizerType.equals(MEDIANCUT)) {
                n2 = 32768;
            } else if (colorQuantizerType.equals(NEUQUANT)) {
                n2 = 100;
            } else if (colorQuantizerType.equals(OCTTREE)) {
                n2 = 65536;
            }
            parameterBlock.set(n2, 2);
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, ColorQuantizerType colorQuantizerType, Integer n, Integer n2, ROI rOI, Integer n3, Integer n4, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("ColorQuantizer", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("quantizationAlgorithm", colorQuantizerType);
        parameterBlockJAI.setParameter("maxColorNum", n);
        parameterBlockJAI.setParameter("upperBound", n2);
        parameterBlockJAI.setParameter("roi", rOI);
        parameterBlockJAI.setParameter("xPeriod", n3);
        parameterBlockJAI.setParameter("yPeriod", n4);
        return JAI.create("ColorQuantizer", parameterBlockJAI, renderingHints);
    }
}

