/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class AndDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "And"}, {"LocalName", "And"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("AndDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AndDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public AndDescriptor() {
        super(resources, supportedModes, 2, null, null, null, null);
    }

    @Override
    protected boolean validateSources(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateSources(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        int n = 0;
        while (n < 2) {
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            int n2 = renderedImage.getSampleModel().getDataType();
            if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
                stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("AndDescriptor1"));
                return false;
            }
            ++n;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, RenderedImage renderedImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("And", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setSource("source1", renderedImage2);
        return JAI.create("And", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, RenderableImage renderableImage2, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("And", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setSource("source1", renderableImage2);
        return JAI.createRenderable("And", parameterBlockJAI, renderingHints);
    }
}

