/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;

public class AndConstDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "AndConst"}, {"LocalName", "AndConst"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("AndConstDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AndConstDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("AndConstDescriptor1")}};
    private static final Class[] paramClasses = new Class[]{int[].class};
    private static final String[] paramNames = new String[]{"constants"};
    private static final Object[] paramDefaults = new Object[]{new int[]{-1}};
    private static final String[] supportedModes = new String[]{"rendered", "renderable"};

    public AndConstDescriptor() {
        super(resources, supportedModes, 1, paramNames, paramClasses, paramDefaults, null);
    }

    @Override
    public boolean validateArguments(String string, ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(string, parameterBlock, stringBuffer)) {
            return false;
        }
        if (!string.equalsIgnoreCase("rendered")) {
            return true;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        int n = renderedImage.getSampleModel().getDataType();
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("AndConstDescriptor1"));
            return false;
        }
        int n2 = ((int[])parameterBlock.getObjectParameter(0)).length;
        if (n2 < 1) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("AndConstDescriptor2"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage renderedImage, int[] nArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("AndConst", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("constants", nArray);
        return JAI.create("AndConst", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, int[] nArray, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("AndConst", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("constants", nArray);
        return JAI.createRenderable("AndConst", parameterBlockJAI, renderingHints);
    }
}

