/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PolyWarpSolver;
import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpCubic;
import javax.media.jai.WarpGeneralPolynomial;
import javax.media.jai.WarpQuadratic;

public abstract class WarpPolynomial
extends Warp {
    protected float[] xCoeffs;
    protected float[] yCoeffs;
    protected float preScaleX;
    protected float preScaleY;
    protected float postScaleX;
    protected float postScaleY;
    protected int degree;

    public WarpPolynomial(float[] fArray, float[] fArray2, float f, float f2, float f3, float f4) {
        if (fArray == null || fArray2 == null || fArray.length < 1 || fArray2.length < 1 || fArray.length != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        int n = fArray.length;
        this.degree = -1;
        while (n > 0) {
            ++this.degree;
            n -= this.degree + 1;
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial0"));
        }
        this.xCoeffs = (float[])fArray.clone();
        this.yCoeffs = (float[])fArray2.clone();
        this.preScaleX = f;
        this.preScaleY = f2;
        this.postScaleX = f3;
        this.postScaleY = f4;
    }

    public WarpPolynomial(float[] fArray, float[] fArray2) {
        this(fArray, fArray2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public float[] getXCoeffs() {
        return (float[])this.xCoeffs.clone();
    }

    public float[] getYCoeffs() {
        return (float[])this.yCoeffs.clone();
    }

    public float[][] getCoeffs() {
        float[][] fArrayArray = new float[][]{(float[])this.xCoeffs.clone(), (float[])this.yCoeffs.clone()};
        return fArrayArray;
    }

    public float getPreScaleX() {
        return this.preScaleX;
    }

    public float getPreScaleY() {
        return this.preScaleY;
    }

    public float getPostScaleX() {
        return this.postScaleX;
    }

    public float getPostScaleY() {
        return this.postScaleY;
    }

    public int getDegree() {
        return this.degree;
    }

    public static WarpPolynomial createWarp(float[] fArray, int n, float[] fArray2, int n2, int n3, float f, float f2, float f3, float f4, int n4) {
        int n5 = (n4 + 1) * (n4 + 2);
        if (n + n5 > fArray.length || n2 + n5 > fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPolynomial1"));
        }
        float[] fArray3 = PolyWarpSolver.getCoeffs(fArray, n, fArray2, n2, n3, f, f2, f3, f4, n4);
        int n6 = fArray3.length / 2;
        float[] fArray4 = new float[n6];
        float[] fArray5 = new float[n6];
        int n7 = 0;
        while (n7 < n6) {
            fArray4[n7] = fArray3[n7];
            fArray5[n7] = fArray3[n7 + n6];
            ++n7;
        }
        if (n4 == 1) {
            return new WarpAffine(fArray4, fArray5, f, f2, f3, f4);
        }
        if (n4 == 2) {
            return new WarpQuadratic(fArray4, fArray5, f, f2, f3, f4);
        }
        if (n4 == 3) {
            return new WarpCubic(fArray4, fArray5, f, f2, f3, f4);
        }
        return new WarpGeneralPolynomial(fArray4, fArray5, f, f2, f3, f4);
    }

    @Override
    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = (point2D.getX() + 0.5) * (double)this.preScaleX;
        double d2 = (point2D.getY() + 0.5) * (double)this.preScaleY;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 <= this.degree) {
            int n3 = 0;
            while (n3 <= n2) {
                double d5 = Math.pow(d, n2 - n3) * Math.pow(d2, n3);
                d3 += (double)this.xCoeffs[n] * d5;
                d4 += (double)this.yCoeffs[n] * d5;
                ++n;
                ++n3;
            }
            ++n2;
        }
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(d3 * (double)this.postScaleX - 0.5, d4 * (double)this.postScaleY - 0.5);
        return point2D2;
    }
}

