/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpPolynomial;

public abstract class WarpOpImage
extends GeometricOpImage {
    protected Warp warp;

    private static ImageLayout getLayout(ImageLayout imageLayout, RenderedImage renderedImage, Warp warp) {
        Point[] pointArray;
        if (imageLayout != null && imageLayout.isValid(15)) {
            return imageLayout;
        }
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = warp.mapSourceRect(rectangle);
        if (rectangle2 == null) {
            pointArray = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x, rectangle.y + rectangle.height), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height)};
            boolean bl = true;
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            double d4 = -1.7976931348623157E308;
            int n = 0;
            while (n < 4) {
                Point2D point2D = warp.mapSourcePoint(pointArray[n]);
                if (point2D == null) {
                    bl = false;
                    break;
                }
                double d5 = point2D.getX();
                double d6 = point2D.getY();
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d2) {
                    d2 = d5;
                }
                if (d6 < d3) {
                    d3 = d6;
                }
                if (d6 > d4) {
                    d4 = d6;
                }
                ++n;
            }
            if (bl) {
                rectangle2 = new Rectangle();
                rectangle2.x = (int)Math.floor(d);
                rectangle2.y = (int)Math.floor(d3);
                rectangle2.width = (int)Math.ceil(d2 - (double)rectangle2.x);
                rectangle2.height = (int)Math.ceil(d4 - (double)rectangle2.y);
            }
        }
        if (rectangle2 == null && !(warp instanceof WarpAffine)) {
            pointArray = new Point[]{new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y), new Point(rectangle.x, rectangle.y + rectangle.height), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height)};
            float[] fArray = new float[8];
            float[] fArray2 = new float[8];
            int n = 0;
            int n2 = 0;
            while (n2 < 4) {
                Point point = pointArray[n2];
                Point2D point2D = warp.mapDestPoint(pointArray[n2]);
                fArray2[n] = (float)((Point2D)point).getX();
                fArray2[n + 1] = (float)((Point2D)point).getY();
                fArray[n] = (float)point2D.getX();
                fArray[n + 1] = (float)point2D.getY();
                n += 2;
                ++n2;
            }
            WarpAffine warpAffine = (WarpAffine)WarpPolynomial.createWarp(fArray, 0, fArray2, 0, 8, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            rectangle2 = warpAffine.mapSourceRect(rectangle);
        }
        if (rectangle2 != null) {
            if (imageLayout == null) {
                imageLayout = new ImageLayout(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                imageLayout = (ImageLayout)imageLayout.clone();
                imageLayout.setMinX(rectangle2.x);
                imageLayout.setMinY(rectangle2.y);
                imageLayout.setWidth(rectangle2.width);
                imageLayout.setHeight(rectangle2.height);
            }
        }
        return imageLayout;
    }

    public WarpOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, Warp warp) {
        this(renderedImage, imageLayout, map, bl, borderExtender, interpolation, warp, null);
    }

    public WarpOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, boolean bl, BorderExtender borderExtender, Interpolation interpolation, Warp warp, double[] dArray) {
        super(WarpOpImage.vectorize(renderedImage), WarpOpImage.getLayout(imageLayout, renderedImage, warp), map, bl, borderExtender, interpolation, dArray);
        if (warp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.warp = warp;
        if (bl && borderExtender == null) {
            int n = interpolation == null ? 0 : interpolation.getLeftPadding();
            int n2 = interpolation == null ? 0 : interpolation.getRightPadding();
            int n3 = interpolation == null ? 0 : interpolation.getTopPadding();
            int n4 = interpolation == null ? 0 : interpolation.getBottomPadding();
            int n5 = this.getMinX() + n;
            int n6 = this.getMinY() + n3;
            int n7 = Math.max(this.getWidth() - n - n2, 0);
            int n8 = Math.max(this.getHeight() - n3 - n4, 0);
            this.computableBounds = new Rectangle(n5, n6, n7, n8);
        } else {
            this.computableBounds = this.getBounds();
        }
    }

    public int getLeftPadding() {
        return this.interp == null ? 0 : this.interp.getLeftPadding();
    }

    public int getRightPadding() {
        return this.interp == null ? 0 : this.interp.getRightPadding();
    }

    public int getTopPadding() {
        return this.interp == null ? 0 : this.interp.getTopPadding();
    }

    public int getBottomPadding() {
        return this.interp == null ? 0 : this.interp.getBottomPadding();
    }

    @Override
    public Point2D mapDestPoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapDestPoint(point2D);
    }

    @Override
    public Point2D mapSourcePoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapSourcePoint(point2D);
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return this.warp.mapSourceRect(rectangle);
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        Rectangle rectangle2 = this.warp.mapDestRect(rectangle);
        return rectangle2 == null ? this.getSource(0).getBounds() : rectangle2;
    }

    @Override
    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = new Rectangle(point.x, point.y, this.tileWidth, this.tileHeight).intersection(this.computableBounds);
        if (rectangle.isEmpty()) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        PlanarImage planarImage = this.getSource(0);
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        if (!rectangle2.intersects(planarImage.getBounds())) {
            if (this.setBackground) {
                ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            }
            return writableRaster;
        }
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[]{this.extender != null ? planarImage.getExtendedData(rectangle2, this.extender) : planarImage.getData(rectangle2)};
            this.computeRect(rasterArray, writableRaster, rectangle);
            if (planarImage.overlapsMultipleTiles(rectangle2)) {
                this.recycleTile(rasterArray[0]);
            }
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[]{planarImage};
            this.computeRect(planarImageArray, writableRaster, rectangle);
        }
        return writableRaster;
    }
}

