/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;

public abstract class UntiledOpImage
extends OpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector) {
        if (vector.size() < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic5"));
        }
        RenderedImage renderedImage = (RenderedImage)vector.get(0);
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setTileGridXOffset(imageLayout2.getMinX(renderedImage));
        imageLayout2.setTileGridYOffset(imageLayout2.getMinY(renderedImage));
        imageLayout2.setTileWidth(imageLayout2.getWidth(renderedImage));
        imageLayout2.setTileHeight(imageLayout2.getHeight(renderedImage));
        return imageLayout2;
    }

    public UntiledOpImage(Vector vector, Map map, ImageLayout imageLayout) {
        super(UntiledOpImage.checkSourceVector(vector, true), UntiledOpImage.layoutHelper(imageLayout, vector), map, true);
    }

    public UntiledOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(UntiledOpImage.vectorize(renderedImage), UntiledOpImage.layoutHelper(imageLayout, UntiledOpImage.vectorize(renderedImage)), map, true);
    }

    @Override
    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        return this.getBounds();
    }

    @Override
    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return this.getSource(n).getBounds();
    }

    @Override
    public Raster computeTile(int n, int n2) {
        Object object;
        Object object2;
        Point point = new Point(this.getMinX(), this.getMinY());
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getBounds();
        int n3 = this.getNumSources();
        Raster[] rasterArray = new Raster[n3];
        int n4 = 0;
        while (n4 < n3) {
            object2 = this.getSource(n4);
            object = this.mapDestRect(rectangle, n4);
            rasterArray[n4] = ((PlanarImage)object2).getData((Rectangle)object);
            ++n4;
        }
        this.computeImage(rasterArray, writableRaster, rectangle);
        n4 = 0;
        while (n4 < n3) {
            object2 = rasterArray[n4];
            if (object2 != null && ((PlanarImage)(object = this.getSourceImage(n4))).overlapsMultipleTiles(((Raster)object2).getBounds())) {
                this.recycleTile((Raster)object2);
            }
            ++n4;
        }
        return writableRaster;
    }

    protected abstract void computeImage(Raster[] var1, WritableRaster var2, Rectangle var3);

    @Override
    public Point[] getTileDependencies(int n, int n2, int n3) {
        PlanarImage planarImage = this.getSource(n3);
        int n4 = planarImage.getMinTileX();
        int n5 = planarImage.getMinTileY();
        int n6 = n4 + planarImage.getNumXTiles() - 1;
        int n7 = n5 + planarImage.getNumYTiles() - 1;
        Point[] pointArray = new Point[(n6 - n4 + 1) * (n7 - n5 + 1)];
        int n8 = 0;
        int n9 = n5;
        while (n9 <= n7) {
            int n10 = n4;
            while (n10 <= n6) {
                pointArray[n8++] = new Point(n10, n9);
                ++n10;
            }
            ++n9;
        }
        return pointArray;
    }
}

