/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.RWLock;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryElementDescriptor;

final class ThreadSafeOperationRegistry
extends OperationRegistry {
    private RWLock lock = new RWLock(true);

    @Override
    public String toString() {
        try {
            this.lock.forReading();
            String string = super.toString();
            this.lock.release();
            return string;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws IOException {
        try {
            this.lock.forReading();
            super.writeToStream(outputStream);
            this.lock.release();
        }
        catch (IOException iOException) {
            this.lock.release();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void initializeFromStream(InputStream inputStream) throws IOException {
        try {
            this.lock.forWriting();
            super.initializeFromStream(inputStream);
            this.lock.release();
        }
        catch (IOException iOException) {
            this.lock.release();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void updateFromStream(InputStream inputStream) throws IOException {
        try {
            this.lock.forWriting();
            super.updateFromStream(inputStream);
            this.lock.release();
        }
        catch (IOException iOException) {
            this.lock.release();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            this.lock.forWriting();
            super.readExternal(objectInput);
            this.lock.release();
        }
        catch (IOException iOException) {
            this.lock.release();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        try {
            this.lock.forReading();
            super.writeExternal(objectOutput);
            this.lock.release();
        }
        catch (IOException iOException) {
            this.lock.release();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void removeRegistryMode(String string) {
        try {
            this.lock.forWriting();
            super.removeRegistryMode(string);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public String[] getRegistryModes() {
        try {
            this.lock.forReading();
            String[] stringArray = super.getRegistryModes();
            this.lock.release();
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void registerDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        try {
            this.lock.forWriting();
            super.registerDescriptor(registryElementDescriptor);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void unregisterDescriptor(RegistryElementDescriptor registryElementDescriptor) {
        try {
            this.lock.forWriting();
            super.unregisterDescriptor(registryElementDescriptor);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public RegistryElementDescriptor getDescriptor(Class clazz, String string) {
        try {
            this.lock.forReading();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(clazz, string);
            this.lock.release();
            return registryElementDescriptor;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public List getDescriptors(Class clazz) {
        try {
            this.lock.forReading();
            List list = super.getDescriptors(clazz);
            this.lock.release();
            return list;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public String[] getDescriptorNames(Class clazz) {
        try {
            this.lock.forReading();
            String[] stringArray = super.getDescriptorNames(clazz);
            this.lock.release();
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public RegistryElementDescriptor getDescriptor(String string, String string2) {
        try {
            this.lock.forReading();
            RegistryElementDescriptor registryElementDescriptor = super.getDescriptor(string, string2);
            this.lock.release();
            return registryElementDescriptor;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public List getDescriptors(String string) {
        try {
            this.lock.forReading();
            List list = super.getDescriptors(string);
            this.lock.release();
            return list;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public String[] getDescriptorNames(String string) {
        try {
            this.lock.forReading();
            String[] stringArray = super.getDescriptorNames(string);
            this.lock.release();
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void setProductPreference(String string, String string2, String string3, String string4) {
        try {
            this.lock.forWriting();
            super.setProductPreference(string, string2, string3, string4);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void unsetProductPreference(String string, String string2, String string3, String string4) {
        try {
            this.lock.forWriting();
            super.unsetProductPreference(string, string2, string3, string4);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void clearProductPreferences(String string, String string2) {
        try {
            this.lock.forWriting();
            super.clearProductPreferences(string, string2);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public String[][] getProductPreferences(String string, String string2) {
        try {
            this.lock.forReading();
            String[][] stringArray = super.getProductPreferences(string, string2);
            this.lock.release();
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public Vector getOrderedProductList(String string, String string2) {
        try {
            this.lock.forReading();
            Vector vector = super.getOrderedProductList(string, string2);
            this.lock.release();
            return vector;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void registerFactory(String string, String string2, String string3, Object object) {
        try {
            this.lock.forWriting();
            super.registerFactory(string, string2, string3, object);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void unregisterFactory(String string, String string2, String string3, Object object) {
        try {
            this.lock.forWriting();
            super.unregisterFactory(string, string2, string3, object);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void setFactoryPreference(String string, String string2, String string3, Object object, Object object2) {
        try {
            this.lock.forWriting();
            super.setFactoryPreference(string, string2, string3, object, object2);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void unsetFactoryPreference(String string, String string2, String string3, Object object, Object object2) {
        try {
            this.lock.forWriting();
            super.unsetFactoryPreference(string, string2, string3, object, object2);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void clearFactoryPreferences(String string, String string2, String string3) {
        try {
            this.lock.forWriting();
            super.clearFactoryPreferences(string, string2, string3);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public Object[][] getFactoryPreferences(String string, String string2, String string3) {
        try {
            this.lock.forReading();
            Object[][] objectArray = super.getFactoryPreferences(string, string2, string3);
            this.lock.release();
            return objectArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public List getOrderedFactoryList(String string, String string2, String string3) {
        try {
            this.lock.forReading();
            List list = super.getOrderedFactoryList(string, string2, string3);
            this.lock.release();
            return list;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public Iterator getFactoryIterator(String string, String string2) {
        try {
            this.lock.forReading();
            Iterator iterator = super.getFactoryIterator(string, string2);
            this.lock.release();
            return iterator;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public Object getFactory(String string, String string2) {
        try {
            this.lock.forReading();
            Object object = super.getFactory(string, string2);
            this.lock.release();
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public Object invokeFactory(String string, String string2, Object[] objectArray) {
        try {
            this.lock.forReading();
            Object object = super.invokeFactory(string, string2, objectArray);
            this.lock.release();
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void addPropertyGenerator(String string, String string2, PropertyGenerator propertyGenerator) {
        try {
            this.lock.forWriting();
            super.addPropertyGenerator(string, string2, propertyGenerator);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void removePropertyGenerator(String string, String string2, PropertyGenerator propertyGenerator) {
        try {
            this.lock.forWriting();
            super.removePropertyGenerator(string, string2, propertyGenerator);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void copyPropertyFromSource(String string, String string2, String string3, int n) {
        try {
            this.lock.forWriting();
            super.copyPropertyFromSource(string, string2, string3, n);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void suppressProperty(String string, String string2, String string3) {
        try {
            this.lock.forWriting();
            super.suppressProperty(string, string2, string3);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void suppressAllProperties(String string, String string2) {
        try {
            this.lock.forWriting();
            super.suppressAllProperties(string, string2);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void clearPropertyState(String string) {
        try {
            this.lock.forWriting();
            super.clearPropertyState(string);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public String[] getGeneratedPropertyNames(String string, String string2) {
        try {
            this.lock.forReading();
            String[] stringArray = super.getGeneratedPropertyNames(string, string2);
            this.lock.release();
            return stringArray;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public PropertySource getPropertySource(String string, String string2, Object object, Vector vector) {
        try {
            this.lock.forReading();
            PropertySource propertySource = super.getPropertySource(string, string2, object, vector);
            this.lock.release();
            return propertySource;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public PropertySource getPropertySource(OperationNode operationNode) {
        try {
            this.lock.forReading();
            PropertySource propertySource = super.getPropertySource(operationNode);
            this.lock.release();
            return propertySource;
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void registerServices(ClassLoader classLoader) throws IOException {
        try {
            this.lock.forWriting();
            super.registerServices(classLoader);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void unregisterOperationDescriptor(String string) {
        try {
            this.lock.forWriting();
            super.unregisterOperationDescriptor(string);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }

    @Override
    public void clearOperationPreferences(String string, String string2) {
        try {
            this.lock.forWriting();
            super.clearOperationPreferences(string, string2);
            this.lock.release();
        }
        catch (RuntimeException runtimeException) {
            this.lock.release();
            throw runtimeException;
        }
    }
}

