/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;

public abstract class StatisticsOpImage
extends OpImage {
    protected ROI roi;
    protected int xStart;
    protected int yStart;
    protected int xPeriod;
    protected int yPeriod;
    private boolean checkForSkippedTiles;

    public StatisticsOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4) {
        super(StatisticsOpImage.vectorize(renderedImage), new ImageLayout(renderedImage), null, false);
        this.roi = rOI == null ? new ROIShape(this.getSource(0).getBounds()) : rOI;
        this.xStart = n;
        this.yStart = n2;
        this.xPeriod = n3;
        this.yPeriod = n4;
        this.checkForSkippedTiles = n3 > this.tileWidth || n4 > this.tileHeight;
    }

    @Override
    public boolean computesUniqueTiles() {
        return false;
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.getSource(0).getTile(n, n2);
    }

    @Override
    public Raster computeTile(int n, int n2) {
        return this.getSource(0).getTile(n, n2);
    }

    @Override
    public Raster[] getTiles(Point[] pointArray) {
        if (pointArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getSource(0).getTiles(pointArray);
    }

    @Override
    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    @Override
    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return new Rectangle(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        Object object;
        block9: {
            if (string == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            object = super.getProperty(string);
            if (!object.equals(Image.UndefinedProperty)) break block9;
            StatisticsOpImage statisticsOpImage = this;
            synchronized (statisticsOpImage) {
                object = this.createStatistics(string);
                if (object.equals(Image.UndefinedProperty)) break block9;
                PlanarImage planarImage = this.getSource(0);
                int n = planarImage.getMinTileX();
                int n2 = planarImage.getMaxTileX();
                int n3 = planarImage.getMinTileY();
                int n4 = planarImage.getMaxTileY();
                int n5 = n3;
                while (n5 <= n4) {
                    int n6 = n;
                    while (n6 <= n2) {
                        block10: {
                            Rectangle rectangle;
                            block11: {
                                rectangle = this.getTileRect(n6, n5);
                                if (!this.roi.intersects(rectangle)) break block10;
                                if (!this.checkForSkippedTiles || rectangle.x < this.xStart || rectangle.y < this.yStart) break block11;
                                int n7 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
                                int n8 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
                                if (n7 >= rectangle.width || n8 >= rectangle.height) break block10;
                            }
                            this.accumulateStatistics(string, planarImage.getData(rectangle), object);
                        }
                        ++n6;
                    }
                    ++n5;
                }
                this.setProperty(string, object);
            }
        }
        return object;
    }

    @Override
    public String[] getPropertyNames() {
        String[] stringArray = this.getStatisticsNames();
        String[] stringArray2 = super.getPropertyNames();
        if (stringArray2 == null) {
            return stringArray;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray3 = PropertyUtil.getPropertyNames(stringArray2, string);
            if (stringArray3 != null) {
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    if (stringArray3[n2].equalsIgnoreCase(string)) {
                        vector.add(string);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (vector.size() == 0) {
            return stringArray2;
        }
        String[] stringArray4 = new String[stringArray2.length + vector.size()];
        System.arraycopy(stringArray2, 0, stringArray4, 0, stringArray2.length);
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < vector.size()) {
            stringArray4[n3++] = (String)vector.get(n4);
            ++n4;
        }
        return stringArray4;
    }

    protected abstract String[] getStatisticsNames();

    protected abstract Object createStatistics(String var1);

    protected abstract void accumulateStatistics(String var1, Raster var2, Object var3);
}

