/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.HashSet;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.Snapshot;
import javax.media.jai.SnapshotProxy;

public class SnapshotImage
extends PlanarImage
implements TileObserver {
    private PlanarImage source;
    private Snapshot tail = null;
    private HashSet activeTiles = new HashSet();

    public SnapshotImage(PlanarImage planarImage) {
        super(new ImageLayout(planarImage), null, null);
        this.source = planarImage;
        if (planarImage instanceof WritableRenderedImage) {
            WritableRenderedImage writableRenderedImage = (WritableRenderedImage)((Object)planarImage);
            writableRenderedImage.addTileObserver(this);
            Point[] pointArray = writableRenderedImage.getWritableTileIndices();
            if (pointArray != null) {
                int n = pointArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Point point = pointArray[n2];
                    this.activeTiles.add(new Point(point.x, point.y));
                    ++n2;
                }
            }
        }
    }

    protected PlanarImage getTrueSource() {
        return this.source;
    }

    void setTail(Snapshot snapshot) {
        this.tail = snapshot;
    }

    Snapshot getTail() {
        return this.tail;
    }

    private Raster createTileCopy(int n, int n2) {
        int n3 = this.tileXToX(n);
        int n4 = this.tileYToY(n2);
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        this.source.copyData(writableRaster);
        return writableRaster;
    }

    @Override
    public PlanarImage createSnapshot() {
        if (this.source instanceof WritableRenderedImage) {
            Snapshot snapshot = new Snapshot(this);
            for (Point point : this.activeTiles) {
                Raster raster = this.createTileCopy(point.x, point.y);
                snapshot.addTile(raster, point.x, point.y);
            }
            if (this.tail == null) {
                this.tail = snapshot;
            } else {
                this.tail.setNext(snapshot);
                snapshot.setPrev(this.tail);
                this.tail = snapshot;
            }
            return new SnapshotProxy(snapshot);
        }
        return this.source;
    }

    @Override
    public void tileUpdate(WritableRenderedImage writableRenderedImage, int n, int n2, boolean bl) {
        if (bl) {
            if (this.tail != null && !this.tail.hasTile(n, n2)) {
                this.tail.addTile(this.createTileCopy(n, n2), n, n2);
            }
            this.activeTiles.add(new Point(n, n2));
        } else {
            this.activeTiles.remove(new Point(n, n2));
        }
    }

    @Override
    public Raster getTile(int n, int n2) {
        return this.source.getTile(n, n2);
    }
}

