/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.image.Raster;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.SnapshotImage;
import javax.media.jai.TileCopy;

final class Snapshot
extends PlanarImage {
    SnapshotImage parent;
    Snapshot next;
    Snapshot prev;
    Hashtable tiles = new Hashtable();
    boolean disposed = false;

    Snapshot(SnapshotImage snapshotImage) {
        super(new ImageLayout(snapshotImage), null, null);
        this.parent = snapshotImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Raster getTile(int n, int n2) {
        SnapshotImage snapshotImage = this.parent;
        synchronized (snapshotImage) {
            TileCopy tileCopy = (TileCopy)this.tiles.get(new Point(n, n2));
            if (tileCopy != null) {
                return tileCopy.tile;
            }
            if (this.next != null) {
                return this.next.getTile(n, n2);
            }
            return this.parent.getTrueSource().getTile(n, n2);
        }
    }

    void setNext(Snapshot snapshot) {
        this.next = snapshot;
    }

    void setPrev(Snapshot snapshot) {
        this.prev = snapshot;
    }

    boolean hasTile(int n, int n2) {
        TileCopy tileCopy = (TileCopy)this.tiles.get(new Point(n, n2));
        return tileCopy != null;
    }

    void addTile(Raster raster, int n, int n2) {
        TileCopy tileCopy = new TileCopy(raster, n, n2);
        this.tiles.put(new Point(n, n2), tileCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SnapshotImage snapshotImage = this.parent;
        synchronized (snapshotImage) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (this.parent.getTail() == this) {
                this.parent.setTail(this.prev);
            }
            if (this.prev != null) {
                this.prev.setNext(this.next);
            }
            if (this.next != null) {
                this.next.setPrev(this.prev);
            }
            if (this.prev != null) {
                Enumeration enumeration = this.tiles.elements();
                while (enumeration.hasMoreElements()) {
                    TileCopy tileCopy = (TileCopy)enumeration.nextElement();
                    if (this.prev.hasTile(tileCopy.tileX, tileCopy.tileY)) continue;
                    this.prev.addTile(tileCopy.tile, tileCopy.tileX, tileCopy.tileY);
                }
            }
            this.parent = null;
            this.prev = null;
            this.next = null;
            this.tiles = null;
        }
    }
}

