/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashSet;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.util.CaselessStringKey;

public class RenderedImageAdapter
extends PlanarImage {
    protected RenderedImage theImage;
    private Rectangle tileIndexBounds;

    static String[] mergePropertyNames(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = null;
        if (stringArray == null || stringArray.length == 0) {
            stringArray3 = stringArray2;
        } else if (stringArray2 == null || stringArray2.length == 0) {
            stringArray3 = stringArray;
        } else {
            HashSet<CaselessStringKey> hashSet = new HashSet<CaselessStringKey>((stringArray.length + stringArray2.length) / 2);
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                hashSet.add(new CaselessStringKey(stringArray2[n2]));
                ++n2;
            }
            n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                hashSet.add(new CaselessStringKey(stringArray[n3]));
                ++n3;
            }
            n3 = hashSet.size();
            CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[n3];
            hashSet.toArray(caselessStringKeyArray);
            stringArray3 = new String[n3];
            int n4 = 0;
            while (n4 < n3) {
                stringArray3[n4] = caselessStringKeyArray[n4].getName();
                ++n4;
            }
        }
        if (stringArray3 != null && stringArray3.length == 0) {
            stringArray3 = null;
        }
        return stringArray3;
    }

    public RenderedImageAdapter(RenderedImage renderedImage) {
        super(renderedImage != null ? new ImageLayout(renderedImage) : null, null, null);
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.theImage = renderedImage;
        this.tileIndexBounds = new Rectangle(this.theImage.getMinTileX(), this.theImage.getMinTileY(), this.theImage.getNumXTiles(), this.theImage.getNumYTiles());
    }

    public final RenderedImage getWrappedImage() {
        return this.theImage;
    }

    @Override
    public final Raster getTile(int n, int n2) {
        return this.tileIndexBounds.contains(n, n2) ? this.theImage.getTile(n, n2) : null;
    }

    @Override
    public final Raster getData() {
        return this.theImage.getData();
    }

    @Override
    public final Raster getData(Rectangle rectangle) {
        return this.theImage.getData(rectangle);
    }

    @Override
    public final WritableRaster copyData(WritableRaster writableRaster) {
        return this.theImage.copyData(writableRaster);
    }

    @Override
    public final String[] getPropertyNames() {
        return RenderedImageAdapter.mergePropertyNames(super.getPropertyNames(), this.theImage.getPropertyNames());
    }

    @Override
    public final Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == Image.UndefinedProperty) {
            object = this.theImage.getProperty(string);
        }
        return object;
    }

    @Override
    public final Class getPropertyClass(String string) {
        Object object;
        Class<?> clazz = super.getPropertyClass(string);
        if (clazz == null && (object = this.getProperty(string)) != Image.UndefinedProperty) {
            clazz = object.getClass();
        }
        return clazz;
    }
}

