/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;

public final class RenderableImageAdapter
implements RenderableImage,
WritablePropertySource {
    private RenderableImage im;
    private PropertyChangeSupportJAI eventManager = null;
    private WritablePropertySourceImpl properties = null;

    public static RenderableImageAdapter wrapRenderableImage(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (renderableImage instanceof RenderableImageAdapter) {
            return (RenderableImageAdapter)renderableImage;
        }
        return new RenderableImageAdapter(renderableImage);
    }

    public RenderableImageAdapter(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.im = renderableImage;
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    }

    public final RenderableImage getWrappedImage() {
        return this.im;
    }

    public final Vector getSources() {
        return this.im.getSources();
    }

    @Override
    public final Object getProperty(String string) {
        Object object = this.properties.getProperty(string);
        if (object == Image.UndefinedProperty) {
            object = this.im.getProperty(string);
        }
        return object;
    }

    @Override
    public Class getPropertyClass(String string) {
        Object object;
        Class<?> clazz = this.properties.getPropertyClass(string);
        if (clazz == null && (object = this.getProperty(string)) != Image.UndefinedProperty) {
            clazz = object.getClass();
        }
        return clazz;
    }

    @Override
    public final String[] getPropertyNames() {
        return RenderedImageAdapter.mergePropertyNames(this.properties.getPropertyNames(), this.im.getPropertyNames());
    }

    @Override
    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    @Override
    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public final float getWidth() {
        return this.im.getWidth();
    }

    @Override
    public final float getHeight() {
        return this.im.getHeight();
    }

    @Override
    public final float getMinX() {
        return this.im.getMinX();
    }

    @Override
    public final float getMinY() {
        return this.im.getMinY();
    }

    @Override
    public final boolean isDynamic() {
        return this.im.isDynamic();
    }

    @Override
    public final RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        return this.im.createScaledRendering(n, n2, renderingHints);
    }

    @Override
    public final RenderedImage createDefaultRendering() {
        return this.im.createDefaultRendering();
    }

    @Override
    public final RenderedImage createRendering(RenderContext renderContext) {
        return this.im.createRendering(renderContext);
    }
}

