/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class ROI
implements Serializable {
    private transient RandomIter iter = null;
    transient PlanarImage theImage = null;
    int threshold = 127;

    protected static LinkedList mergeRunLengthList(LinkedList linkedList) {
        if (linkedList == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (linkedList.size() > 1) {
            int n = 0;
            while (n < linkedList.size() - 1) {
                ListIterator listIterator = linkedList.listIterator(n);
                Rectangle rectangle = (Rectangle)listIterator.next();
                while (listIterator.hasNext()) {
                    Rectangle rectangle2 = (Rectangle)listIterator.next();
                    int n2 = rectangle.y + rectangle.height;
                    if (rectangle2.y == n2 && rectangle2.x == rectangle.x && rectangle2.width == rectangle.width) {
                        rectangle = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height + rectangle2.height);
                        listIterator.remove();
                        linkedList.set(n, rectangle);
                        continue;
                    }
                    if (rectangle2.y > n2) break;
                }
                ++n;
            }
        }
        return linkedList;
    }

    protected ROI() {
    }

    public ROI(RenderedImage renderedImage) {
        this(renderedImage, 127);
    }

    public ROI(RenderedImage renderedImage, int n) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel.getNumBands() != 1) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI0"));
        }
        this.threshold = n;
        if (n >= 1 && ImageUtil.isBinary(sampleModel)) {
            this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        } else {
            ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("binarize");
            parameterBlockJAI.setSource("source0", renderedImage);
            parameterBlockJAI.setParameter("threshold", (double)n);
            this.theImage = JAI.create("binarize", parameterBlockJAI, null);
        }
    }

    private RandomIter getIter() {
        if (this.iter == null) {
            this.iter = RandomIterFactory.create(this.theImage, null);
        }
        return this.iter;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
        ((RenderedOp)this.theImage).setParameter((double)n, 0);
        this.iter = null;
        this.getIter();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.theImage.getMinX(), this.theImage.getMinY(), this.theImage.getWidth(), this.theImage.getHeight());
    }

    public boolean contains(Point point) {
        if (point == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains(point.x, point.y);
    }

    public boolean contains(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.contains((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean contains(int n, int n2) {
        int n3 = this.theImage.getMinX();
        int n4 = this.theImage.getMinY();
        return n >= n3 && n < n3 + this.theImage.getWidth() && n2 >= n4 && n2 < n4 + this.theImage.getHeight() && this.getIter().getSample(n, n2, 0) >= 1;
    }

    public boolean contains(double d, double d2) {
        return this.contains((int)d, (int)d2);
    }

    public boolean contains(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!rectangle.equals(rectangle.intersection(this.getBounds()))) {
            return false;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n = rectangle.width % 8;
        if (n == 0) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if ((byArray[n2] & 0xFF) != 255) {
                    return false;
                }
                ++n2;
            }
        } else {
            int n3 = (1 << n) - 1 << 8 - n;
            int n4 = 0;
            int n5 = 0;
            while (n4 < rectangle.height) {
                int n6 = 0;
                while (n6 < rectangle.width - n) {
                    if ((byArray[n5] & 0xFF) != 255) {
                        return false;
                    }
                    n6 += 8;
                    ++n5;
                }
                if ((byArray[n5] & n3) != n3) {
                    return false;
                }
                ++n5;
                ++n4;
            }
        }
        return true;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.contains(rectangle);
    }

    public boolean contains(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return this.contains(rectangle);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
        return this.contains(rectangle);
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            return false;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle2);
        int n = rectangle2.width % 8;
        if (n == 0) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if ((byArray[n2] & 0xFF) != 0) {
                    return true;
                }
                ++n2;
            }
        } else {
            int n3 = (1 << n) - 1 << 8 - n;
            int n4 = 0;
            int n5 = 0;
            while (n4 < rectangle2.height) {
                int n6 = 0;
                while (n6 < rectangle2.width - n) {
                    if ((byArray[n5] & 0xFF) != 0) {
                        return true;
                    }
                    n6 += 8;
                    ++n5;
                }
                if ((byArray[n5] & n3) != 0) {
                    return true;
                }
                ++n5;
                ++n4;
            }
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.intersects(rectangle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        return this.intersects(rectangle);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
        return this.intersects(rectangle);
    }

    private static PlanarImage createBinaryImage(Rectangle rectangle) {
        if (rectangle.x == 0 && rectangle.y == 0) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 12);
            return PlanarImage.wrapRenderedImage(bufferedImage);
        }
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, rectangle.width, rectangle.height, 1);
        return new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, multiPixelPackedSampleModel, PlanarImage.createColorModel(multiPixelPackedSampleModel));
    }

    private ROI createOpROI(ROI rOI, String string) {
        RenderedOp renderedOp;
        if (rOI == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        PlanarImage planarImage = this.getAsImage();
        PlanarImage planarImage2 = rOI.getAsImage();
        Rectangle rectangle = planarImage.getBounds();
        Rectangle rectangle2 = planarImage2.getBounds();
        if (string.equals("and") || rectangle.equals(rectangle2)) {
            renderedOp = JAI.create(string, (RenderedImage)planarImage, planarImage2);
        } else if (string.equals("subtract") || rectangle.contains(rectangle2)) {
            PlanarImage planarImage3 = ROI.createBinaryImage(rectangle);
            planarImage3 = JAI.create("overlay", (RenderedImage)planarImage3, planarImage2);
            renderedOp = JAI.create(string, (RenderedImage)planarImage, planarImage3);
        } else if (rectangle2.contains(rectangle)) {
            PlanarImage planarImage4 = ROI.createBinaryImage(rectangle2);
            planarImage4 = JAI.create("overlay", (RenderedImage)planarImage4, planarImage);
            renderedOp = JAI.create(string, (RenderedImage)planarImage4, planarImage2);
        } else {
            Rectangle rectangle3 = rectangle.union(rectangle2);
            PlanarImage planarImage5 = ROI.createBinaryImage(rectangle3);
            PlanarImage planarImage6 = ROI.createBinaryImage(rectangle3);
            planarImage5 = JAI.create("overlay", (RenderedImage)planarImage5, planarImage);
            planarImage6 = JAI.create("overlay", (RenderedImage)planarImage6, planarImage2);
            renderedOp = JAI.create(string, (RenderedImage)planarImage5, planarImage6);
        }
        return new ROI(renderedOp, this.threshold);
    }

    public ROI add(ROI rOI) {
        return this.createOpROI(rOI, "add");
    }

    public ROI subtract(ROI rOI) {
        return this.createOpROI(rOI, "subtract");
    }

    public ROI intersect(ROI rOI) {
        return this.createOpROI(rOI, "and");
    }

    public ROI exclusiveOr(ROI rOI) {
        return this.createOpROI(rOI, "xor");
    }

    public ROI transform(AffineTransform affineTransform, Interpolation interpolation) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI5"));
        }
        if (interpolation == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ROI6"));
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.add(affineTransform);
        parameterBlock.add(interpolation);
        return this.performImageOp("Affine", parameterBlock, 0, null);
    }

    public ROI transform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.transform(affineTransform, Interpolation.getInstance(0));
    }

    public ROI performImageOp(RenderedImageFactory renderedImageFactory, ParameterBlock parameterBlock, int n, RenderingHints renderingHints) {
        if (renderedImageFactory == null || parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n);
        RenderedImage renderedImage = renderedImageFactory.create(parameterBlock2, renderingHints);
        return new ROI(renderedImage, this.threshold);
    }

    public ROI performImageOp(String string, ParameterBlock parameterBlock, int n, RenderingHints renderingHints) {
        if (string == null || parameterBlock == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock2.getSources();
        vector.insertElementAt(this.getAsImage(), n);
        RenderedOp renderedOp = JAI.create(string, parameterBlock2, renderingHints);
        return new ROI(renderedOp, this.threshold);
    }

    public Shape getAsShape() {
        return null;
    }

    public PlanarImage getAsImage() {
        return this.theImage;
    }

    public int[][] getAsBitmask(int n, int n2, int n3, int n4, int[][] nArray) {
        int n5;
        int n6;
        int n7;
        Rectangle rectangle = this.getBounds().intersection(new Rectangle(n, n2, n3, n4));
        if (rectangle.isEmpty()) {
            return null;
        }
        int n8 = (n3 + 31) / 32;
        if (nArray == null) {
            nArray = new int[n4][n8];
        } else if (nArray.length < n4 || nArray[0].length < n8) {
            throw new RuntimeException(JaiI18N.getString("ROI3"));
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n9 = rectangle.width % 8;
        if (n9 != 0) {
            n7 = (1 << n9) - 1 << 8 - n9;
            n6 = (n3 + 7) / 8;
            n5 = n6 - 1;
            while (n5 < byArray.length) {
                byArray[n5] = (byte)(byArray[n5] & n7);
                n5 += n6;
            }
        }
        n7 = (rectangle.width + 7) / 8;
        n6 = n7 % 4;
        int n10 = (n7 - n6) / 4;
        n5 = 0;
        int n11 = 0;
        while (n5 < rectangle.height) {
            int[] nArray2 = nArray[n5];
            int n12 = 0;
            while (n12 < n10) {
                nArray2[n12] = (byArray[n11] & 0xFF) << 24 | (byArray[n11 + 1] & 0xFF) << 16 | (byArray[n11 + 2] & 0xFF) << 8 | (byArray[n11 + 3] & 0xFF) << 0;
                n11 += 4;
                ++n12;
            }
            switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    nArray2[n12++] = (byArray[n11] & 0xFF) << 24;
                    break;
                }
                case 2: {
                    nArray2[n12++] = (byArray[n11] & 0xFF) << 24 | (byArray[n11 + 1] & 0xFF) << 16;
                    break;
                }
                case 3: {
                    nArray2[n12++] = (byArray[n11] & 0xFF) << 24 | (byArray[n11 + 1] & 0xFF) << 16 | (byArray[n11 + 2] & 0xFF) << 8;
                }
            }
            n11 += n6;
            Arrays.fill(nArray2, n12, n8, 0);
            ++n5;
        }
        n5 = rectangle.height;
        while (n5 < n4) {
            Arrays.fill(nArray[n5], 0);
            ++n5;
        }
        return nArray;
    }

    public LinkedList getAsRectangleList(int n, int n2, int n3, int n4) {
        return this.getAsRectangleList(n, n2, n3, n4, true);
    }

    protected LinkedList getAsRectangleList(int n, int n2, int n3, int n4, boolean bl) {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.intersects(rectangle = new Rectangle(n, n2, n3, n4))) {
            return null;
        }
        if (!rectangle2.contains(rectangle)) {
            rectangle = rectangle2.intersection(rectangle);
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        byte[] byArray = ImageUtil.getPackedBinaryData(this.theImage.getData(), rectangle);
        int n5 = (n3 + 7) / 8;
        int n6 = n3 % 8;
        int n7 = n6 == 0 ? 255 : (1 << n6) - 1 << 8 - n6;
        LinkedList linkedList = new LinkedList();
        int n8 = 0;
        int n9 = 0;
        while (n8 < n4) {
            int n10 = -1;
            int n11 = 0;
            while (n11 < n5) {
                int n12 = byArray[n9] & (n11 == n5 - 1 ? n7 : 255);
                if (n12 == 0) {
                    if (n10 >= 0) {
                        linkedList.addLast(new Rectangle(n + n10, n2 + n8, n11 * 8 - n10, 1));
                        n10 = -1;
                    }
                } else if (n12 == 255) {
                    if (n10 < 0) {
                        n10 = n11 * 8;
                    }
                } else {
                    int n13 = 7;
                    while (n13 >= 0) {
                        if ((n12 & 1 << n13) == 0) {
                            if (n10 >= 0) {
                                linkedList.addLast(new Rectangle(n + n10, n2 + n8, n11 * 8 + (7 - n13) - n10, 1));
                                n10 = -1;
                            }
                        } else if (n10 < 0) {
                            n10 = n11 * 8 + (7 - n13);
                        }
                        --n13;
                    }
                }
                ++n11;
                ++n9;
            }
            if (n10 >= 0) {
                linkedList.addLast(new Rectangle(n + n10, n2 + n8, n11 * 8 - n10, 1));
            }
            ++n8;
        }
        return bl ? ROI.mergeRunLengthList(linkedList) : linkedList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.theImage != null) {
            objectOutputStream.writeBoolean(true);
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.put(JAI.KEY_SERIALIZE_DEEP_COPY, new Boolean(true));
            objectOutputStream.writeObject(SerializerFactory.getState(this.theImage, renderingHints));
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream.readBoolean()) {
            SerializableState serializableState = (SerializableState)objectInputStream.readObject();
            RenderedImage renderedImage = (RenderedImage)serializableState.getObject();
            this.theImage = PlanarImage.wrapRenderedImage(renderedImage);
        } else {
            this.theImage = null;
        }
        this.iter = null;
    }
}

