/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertySource;
import javax.media.jai.util.CaselessStringKey;

public class PropertySourceImpl
implements PropertySource,
Serializable {
    protected transient Map properties = new Hashtable();
    protected transient Map propertySources = new Hashtable();
    protected Set cachedPropertyNames = Collections.synchronizedSet(new HashSet());

    protected PropertySourceImpl() {
    }

    public PropertySourceImpl(Map map, PropertySource propertySource) {
        this();
        String[] stringArray;
        if (map == null && propertySource == null) {
            boolean bl = false;
            try {
                Class<Object> clazz = Class.forName("javax.media.jai.PropertySourceImpl");
                bl = this.getClass().equals(clazz);
            }
            catch (Exception exception) {}
            if (bl) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
        }
        if (map != null) {
            for (Class<Object> clazz : map.keySet()) {
                if (clazz instanceof String) {
                    this.properties.put(new CaselessStringKey((String)((Object)clazz)), map.get(clazz));
                    continue;
                }
                if (!(clazz instanceof CaselessStringKey)) continue;
                this.properties.put((CaselessStringKey)((Object)clazz), map.get(clazz));
            }
        }
        if (propertySource != null && (stringArray = propertySource.getPropertyNames()) != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.propertySources.put(new CaselessStringKey(stringArray[n2]), propertySource);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() {
        Map map = this.properties;
        synchronized (map) {
            block5: {
                if (this.properties.size() + this.propertySources.size() != 0) break block5;
                return null;
            }
            Set set = Collections.synchronizedSet(new HashSet(this.properties.keySet()));
            set.addAll(this.propertySources.keySet());
            int n = set.size();
            String[] stringArray = new String[n];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext() && n2 < n) {
                stringArray[n2++] = ((CaselessStringKey)iterator.next()).getName();
            }
            return stringArray;
        }
    }

    @Override
    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class getPropertyClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            Class<?> clazz = null;
            Object v = this.properties.get(new CaselessStringKey(string));
            if (v != null) {
                clazz = v.getClass();
            }
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            Object object = this.properties.get(caselessStringKey);
            if (object == null) {
                PropertySource propertySource = (PropertySource)this.propertySources.get(caselessStringKey);
                if (propertySource != null) {
                    object = propertySource.getProperty(string);
                    if (object != Image.UndefinedProperty) {
                        this.properties.put(caselessStringKey, object);
                        this.cachedPropertyNames.add(caselessStringKey);
                    }
                } else {
                    object = Image.UndefinedProperty;
                }
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProperties() {
        if (this.properties.size() + this.propertySources.size() == 0) {
            return null;
        }
        Map map = this.properties;
        synchronized (map) {
            Hashtable<String, Object> hashtable = null;
            String[] stringArray = this.getPropertyNames();
            if (stringArray != null) {
                int n = stringArray.length;
                hashtable = new Hashtable<String, Object>(this.properties.size());
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Object object = this.getProperty(string);
                    hashtable.put(string, object);
                    ++n2;
                }
            }
            return hashtable;
        }
    }

    private static void writeMap(ObjectOutputStream objectOutputStream, Map map) throws IOException {
        Hashtable hashtable = new Hashtable();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (!(v instanceof Serializable)) continue;
            hashtable.put(k, v);
        }
        objectOutputStream.writeObject(hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Map map = this.properties;
        synchronized (map) {
            PropertySourceImpl.writeMap(objectOutputStream, this.properties);
            PropertySourceImpl.writeMap(objectOutputStream, this.propertySources);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.properties = (Map)objectInputStream.readObject();
        this.propertySources = (Map)objectInputStream.readObject();
        Iterator iterator = this.cachedPropertyNames.iterator();
        Set set = this.properties.keySet();
        while (iterator.hasNext()) {
            if (set.contains(iterator.next())) continue;
            iterator.remove();
        }
    }
}

