/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringArrayTable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.media.jai.JaiI18N;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;

public class ParameterListImpl
implements ParameterList,
Serializable {
    private ParameterListDescriptor pld;
    private CaselessStringArrayTable paramIndices;
    private Object[] paramValues;
    private Class[] paramClasses;

    public ParameterListImpl(ParameterListDescriptor parameterListDescriptor) {
        if (parameterListDescriptor == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.pld = parameterListDescriptor;
        int n = this.pld.getNumParameters();
        if (n > 0) {
            Object[] objectArray = this.pld.getParamDefaults();
            this.paramClasses = this.pld.getParamClasses();
            this.paramIndices = new CaselessStringArrayTable(this.pld.getParamNames());
            this.paramValues = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this.paramValues[n2] = objectArray[n2];
                ++n2;
            }
        } else {
            this.paramClasses = null;
            this.paramIndices = null;
            this.paramValues = null;
        }
    }

    @Override
    public ParameterListDescriptor getParameterListDescriptor() {
        return this.pld;
    }

    private ParameterList setParameter0(String string, Object object) {
        int n = this.paramIndices.indexOf(string);
        if (object != null && !this.paramClasses[n].isInstance(object)) {
            throw new IllegalArgumentException(this.formatMsg(JaiI18N.getString("ParameterListImpl0"), new Object[]{object.getClass().getName(), this.paramClasses[n].getName(), string}));
        }
        if (!this.pld.isParameterValueValid(string, object)) {
            throw new IllegalArgumentException(String.valueOf(string) + ":" + JaiI18N.getString("ParameterListImpl1"));
        }
        this.paramValues[n] = object;
        return this;
    }

    @Override
    public ParameterList setParameter(String string, byte by) {
        return this.setParameter0(string, new Byte(by));
    }

    @Override
    public ParameterList setParameter(String string, boolean bl) {
        return this.setParameter0(string, new Boolean(bl));
    }

    @Override
    public ParameterList setParameter(String string, char c) {
        return this.setParameter0(string, new Character(c));
    }

    @Override
    public ParameterList setParameter(String string, short s) {
        return this.setParameter0(string, new Short(s));
    }

    @Override
    public ParameterList setParameter(String string, int n) {
        return this.setParameter0(string, new Integer(n));
    }

    @Override
    public ParameterList setParameter(String string, long l) {
        return this.setParameter0(string, new Long(l));
    }

    @Override
    public ParameterList setParameter(String string, float f) {
        return this.setParameter0(string, new Float(f));
    }

    @Override
    public ParameterList setParameter(String string, double d) {
        return this.setParameter0(string, new Double(d));
    }

    @Override
    public ParameterList setParameter(String string, Object object) {
        return this.setParameter0(string, object);
    }

    private Object getObjectParameter0(String string) {
        Object object = this.paramValues[this.paramIndices.indexOf(string)];
        if (object == ParameterListDescriptor.NO_PARAMETER_DEFAULT) {
            throw new IllegalStateException(String.valueOf(string) + ":" + JaiI18N.getString("ParameterListImpl2"));
        }
        return object;
    }

    @Override
    public Object getObjectParameter(String string) {
        return this.getObjectParameter0(string);
    }

    @Override
    public byte getByteParameter(String string) {
        return (Byte)this.getObjectParameter0(string);
    }

    @Override
    public boolean getBooleanParameter(String string) {
        return (Boolean)this.getObjectParameter0(string);
    }

    @Override
    public char getCharParameter(String string) {
        return ((Character)this.getObjectParameter0(string)).charValue();
    }

    @Override
    public short getShortParameter(String string) {
        return (Short)this.getObjectParameter0(string);
    }

    @Override
    public int getIntParameter(String string) {
        return (Integer)this.getObjectParameter0(string);
    }

    @Override
    public long getLongParameter(String string) {
        return (Long)this.getObjectParameter0(string);
    }

    @Override
    public float getFloatParameter(String string) {
        return ((Float)this.getObjectParameter0(string)).floatValue();
    }

    @Override
    public double getDoubleParameter(String string) {
        return (Double)this.getObjectParameter0(string);
    }

    private String formatMsg(String string, Object[] objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        messageFormat.setLocale(Locale.getDefault());
        return messageFormat.format(objectArray);
    }
}

