/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;

public class NullOpImage
extends PointOpImage {
    protected int computeType;

    private static ImageLayout layoutHelper(RenderedImage renderedImage, ImageLayout imageLayout) {
        ImageLayout imageLayout2 = new ImageLayout(renderedImage);
        if (imageLayout != null && imageLayout.isValid(512)) {
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (JDKWorkarounds.areCompatibleDataModels(renderedImage.getSampleModel(), colorModel)) {
                imageLayout2.setColorModel(colorModel);
            }
        }
        return imageLayout2;
    }

    public NullOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, int n) {
        super(PlanarImage.wrapRenderedImage(renderedImage).createSnapshot(), NullOpImage.layoutHelper(renderedImage, imageLayout), map, false);
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("NullOpImage0"));
        }
        this.computeType = n;
    }

    public NullOpImage(RenderedImage renderedImage, TileCache tileCache, int n, ImageLayout imageLayout) {
        this(renderedImage, imageLayout, (Map)(tileCache != null ? new RenderingHints(JAI.KEY_TILE_CACHE, tileCache) : null), n);
    }

    @Override
    public Raster computeTile(int n, int n2) {
        return this.getSource(0).getTile(n, n2);
    }

    @Override
    public boolean computesUniqueTiles() {
        return false;
    }

    @Override
    protected synchronized Hashtable getProperties() {
        return this.getSource(0).getProperties();
    }

    @Override
    protected synchronized void setProperties(Hashtable hashtable) {
        this.getSource(0).setProperties(hashtable);
    }

    @Override
    public String[] getPropertyNames() {
        return this.getSource(0).getPropertyNames();
    }

    @Override
    public String[] getPropertyNames(String string) {
        return this.getSource(0).getPropertyNames(string);
    }

    @Override
    public Class getPropertyClass(String string) {
        return this.getSource(0).getPropertyClass(string);
    }

    @Override
    public Object getProperty(String string) {
        return this.getSource(0).getProperty(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.getSource(0).setProperty(string, object);
    }

    @Override
    public void removeProperty(String string) {
        this.getSource(0).removeProperty(string);
    }

    @Override
    public int getOperationComputeType() {
        return this.computeType;
    }
}

