/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class LookupTableJAI
implements Serializable {
    transient DataBuffer data;
    private int[] tableOffsets;

    public LookupTableJAI(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.data = new DataBufferByte(byArray, byArray.length);
        this.initOffsets(1, 0);
    }

    public LookupTableJAI(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferByte(byArray, byArray.length);
    }

    public LookupTableJAI(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, 0);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, n);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(byte[][] byArray, int[] nArray) {
        if (byArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(byArray.length, nArray);
        this.data = new DataBufferByte(byArray, byArray[0].length);
    }

    public LookupTableJAI(short[] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray.length) : new DataBufferShort(sArray, sArray.length);
    }

    public LookupTableJAI(short[][] sArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, 0);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int n, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, n);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(short[][] sArray, int[] nArray, boolean bl) {
        if (sArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(sArray.length, nArray);
        this.data = bl ? new DataBufferUShort(sArray, sArray[0].length) : new DataBufferShort(sArray, sArray[0].length);
    }

    public LookupTableJAI(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = new DataBufferInt(nArray, nArray.length);
    }

    public LookupTableJAI(int[][] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, 0);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, n);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(int[][] nArray, int[] nArray2) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(nArray.length, nArray2);
        this.data = new DataBufferInt(nArray, nArray[0].length);
    }

    public LookupTableJAI(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray.length);
    }

    public LookupTableJAI(float[][] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, 0);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int n) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, n);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(float[][] fArray, int[] nArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(fArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferFloat(fArray, fArray[0].length);
    }

    public LookupTableJAI(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(1, n);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray.length);
    }

    public LookupTableJAI(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, 0);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, n);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public LookupTableJAI(double[][] dArray, int[] nArray) {
        if (dArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.initOffsets(dArray.length, nArray);
        this.data = DataBufferUtils.createDataBufferDouble(dArray, dArray[0].length);
    }

    public DataBuffer getData() {
        return this.data;
    }

    public byte[][] getByteData() {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getBankData() : null;
    }

    public byte[] getByteData(int n) {
        return this.data instanceof DataBufferByte ? ((DataBufferByte)this.data).getData(n) : null;
    }

    public short[][] getShortData() {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getBankData();
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getBankData();
        }
        return null;
    }

    public short[] getShortData(int n) {
        if (this.data instanceof DataBufferUShort) {
            return ((DataBufferUShort)this.data).getData(n);
        }
        if (this.data instanceof DataBufferShort) {
            return ((DataBufferShort)this.data).getData(n);
        }
        return null;
    }

    public int[][] getIntData() {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getBankData() : null;
    }

    public int[] getIntData(int n) {
        return this.data instanceof DataBufferInt ? ((DataBufferInt)this.data).getData(n) : null;
    }

    public float[][] getFloatData() {
        return this.data.getDataType() == 4 ? DataBufferUtils.getBankDataFloat(this.data) : null;
    }

    public float[] getFloatData(int n) {
        return this.data.getDataType() == 4 ? DataBufferUtils.getDataFloat(this.data, n) : null;
    }

    public double[][] getDoubleData() {
        return this.data.getDataType() == 5 ? DataBufferUtils.getBankDataDouble(this.data) : null;
    }

    public double[] getDoubleData(int n) {
        return this.data.getDataType() == 5 ? DataBufferUtils.getDataDouble(this.data, n) : null;
    }

    public int[] getOffsets() {
        return this.tableOffsets;
    }

    public int getOffset() {
        return this.tableOffsets[0];
    }

    public int getOffset(int n) {
        return this.tableOffsets[n];
    }

    public int getNumBands() {
        return this.data.getNumBanks();
    }

    public int getNumEntries() {
        return this.data.getSize();
    }

    public int getDataType() {
        return this.data.getDataType();
    }

    public int getDestNumBands(int n) {
        int n2 = this.getNumBands();
        return n == 1 ? n2 : n;
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getDestSampleModel(sampleModel, sampleModel.getWidth(), sampleModel.getHeight());
    }

    public SampleModel getDestSampleModel(SampleModel sampleModel, int n, int n2) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.isIntegralDataType(sampleModel)) {
            return null;
        }
        return RasterFactory.createComponentSampleModel(sampleModel, this.getDataType(), n, n2, this.getDestNumBands(sampleModel.getNumBands()));
    }

    public boolean isIntegralDataType(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.isIntegralDataType(sampleModel.getTransferType());
    }

    public boolean isIntegralDataType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3;
    }

    public int lookup(int n, int n2) {
        return this.data.getElem(n, n2 - this.tableOffsets[n]);
    }

    public float lookupFloat(int n, int n2) {
        return this.data.getElemFloat(n, n2 - this.tableOffsets[n]);
    }

    public double lookupDouble(int n, int n2) {
        return this.data.getElemDouble(n, n2 - this.tableOffsets[n]);
    }

    public WritableRaster lookup(WritableRaster writableRaster) {
        if (writableRaster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.lookup(writableRaster, writableRaster, writableRaster.getBounds());
    }

    public WritableRaster lookup(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        int n;
        SampleModel sampleModel;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI1"));
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        if (!this.isIntegralDataType(sampleModel2)) {
            throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI2"));
        }
        rectangle = rectangle == null ? raster.getBounds() : rectangle.intersection(raster.getBounds());
        if (writableRaster != null) {
            rectangle = rectangle.intersection(writableRaster.getBounds());
        }
        if (writableRaster == null) {
            sampleModel = this.getDestSampleModel(sampleModel2, rectangle.width, rectangle.height);
            writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(rectangle.x, rectangle.y));
        } else {
            sampleModel = writableRaster.getSampleModel();
            if (sampleModel.getTransferType() != this.getDataType() || sampleModel.getNumBands() != this.getDestNumBands(sampleModel2.getNumBands())) {
                throw new IllegalArgumentException(JaiI18N.getString("LookupTableJAI3"));
            }
        }
        int n2 = RasterAccessor.findCompatibleTag(null, sampleModel2);
        int n3 = RasterAccessor.findCompatibleTag(null, sampleModel);
        RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel2, n2);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(sampleModel, n3);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle, rasterFormatTag, null);
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTag2, null);
        int n4 = rasterAccessor.getNumBands();
        int n5 = rasterAccessor.getDataType();
        int n6 = this.getNumBands();
        int n7 = this.getDataType();
        int n8 = rasterAccessor2.getWidth();
        int n9 = rasterAccessor2.getHeight();
        int n10 = rasterAccessor2.getNumBands();
        int n11 = rasterAccessor2.getDataType();
        int n12 = rasterAccessor.getScanlineStride();
        int n13 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        Object object = rasterAccessor.getByteDataArrays();
        Object object2 = rasterAccessor.getShortDataArrays();
        Object object3 = rasterAccessor.getIntDataArrays();
        if (n4 < n10) {
            int n14 = nArray[0];
            nArray = new int[n10];
            int n15 = 0;
            while (n15 < n10) {
                nArray[n15] = n14;
                ++n15;
            }
            switch (n5) {
                case 0: {
                    byte[] byArray = object[0];
                    object = new byte[n10][];
                    int n16 = 0;
                    while (n16 < n10) {
                        object[n16] = byArray;
                        ++n16;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sArray = object2[0];
                    object2 = new short[n10][];
                    int n17 = 0;
                    while (n17 < n10) {
                        object2[n17] = sArray;
                        ++n17;
                    }
                    break;
                }
                case 3: {
                    int[] nArray2 = object3[0];
                    object3 = new int[n10][];
                    int n18 = 0;
                    while (n18 < n10) {
                        object3[n18] = nArray2;
                        ++n18;
                    }
                    break;
                }
            }
        }
        int[] nArray3 = this.getOffsets();
        Object object4 = this.getByteData();
        Object object5 = this.getShortData();
        Object object6 = this.getIntData();
        Object object7 = this.getFloatData();
        Object object8 = this.getDoubleData();
        if (n6 < n10) {
            n = nArray3[0];
            nArray3 = new int[n10];
            int n19 = 0;
            while (n19 < n10) {
                nArray3[n19] = n;
                ++n19;
            }
            switch (n7) {
                case 0: {
                    byte[] byArray = object4[0];
                    object4 = new byte[n10][];
                    int n20 = 0;
                    while (n20 < n10) {
                        object4[n20] = byArray;
                        ++n20;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[] sArray = object5[0];
                    object5 = new short[n10][];
                    int n21 = 0;
                    while (n21 < n10) {
                        object5[n21] = sArray;
                        ++n21;
                    }
                    break;
                }
                case 3: {
                    int[] nArray4 = object6[0];
                    object6 = new int[n10][];
                    int n22 = 0;
                    while (n22 < n10) {
                        object6[n22] = nArray4;
                        ++n22;
                    }
                    break;
                }
                case 4: {
                    float[] fArray = object7[0];
                    object7 = new float[n10][];
                    int n23 = 0;
                    while (n23 < n10) {
                        object7[n23] = fArray;
                        ++n23;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = object8[0];
                    object8 = new double[n10][];
                    int n24 = 0;
                    while (n24 < n10) {
                        object8[n24] = dArray;
                        ++n24;
                    }
                    break;
                }
            }
        }
        n = rasterAccessor2.getScanlineStride();
        int n25 = rasterAccessor2.getPixelStride();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[][] nArray6 = rasterAccessor2.getIntDataArrays();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        block12 : switch (n11) {
            case 0: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object, n8, n9, n10, n, n25, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, byArray, nArray3, (byte[][])object4);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object3, n8, n9, n10, n, n25, nArray5, byArray, nArray3, (byte[][])object4);
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object, n8, n9, n10, n, n25, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, sArray, nArray3, (short[][])object5);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object3, n8, n9, n10, n, n25, nArray5, sArray, nArray3, (short[][])object5);
                    }
                }
                break;
            }
            case 3: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object, n8, n9, n10, n, n25, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, nArray6, nArray3, (int[][])object6);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object3, n8, n9, n10, n, n25, nArray5, nArray6, nArray3, (int[][])object6);
                    }
                }
                break;
            }
            case 4: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object, n8, n9, n10, n, n25, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, fArray, nArray3, (float[][])object7);
                        break;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object3, n8, n9, n10, n, n25, nArray5, fArray, nArray3, (float[][])object7);
                    }
                }
                break;
            }
            case 5: {
                switch (n5) {
                    case 0: {
                        this.lookup(n12, n13, nArray, (byte[][])object, n8, n9, n10, n, n25, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 1: {
                        this.lookupU(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 2: {
                        this.lookup(n12, n13, nArray, (short[][])object2, n8, n9, n10, n, n25, nArray5, dArray, nArray3, (double[][])object8);
                        break block12;
                    }
                    case 3: {
                        this.lookup(n12, n13, nArray, (int[][])object3, n8, n9, n10, n, n25, nArray5, dArray, nArray3, (double[][])object8);
                    }
                }
            }
        }
        rasterAccessor2.copyDataToRaster();
        return writableRaster;
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray2, int[] nArray3, byte[][] byArray3) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray4 = byArray[n8];
            byte[] byArray5 = byArray2[n8];
            byte[] byArray6 = byArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray5[n14] = byArray6[(byArray4[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, byte[][] byArray, int[] nArray3, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, byte[][] byArray, int[] nArray4, byte[][] byArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    byArray3[n14] = byArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray, int[] nArray3, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[(sArray4[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, short[][] sArray2, int[] nArray3, short[][] sArray3) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray4 = sArray[n8];
            short[] sArray5 = sArray2[n8];
            short[] sArray6 = sArray3[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray5[n14] = sArray6[sArray4[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, short[][] sArray, int[] nArray4, short[][] sArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    sArray3[n14] = sArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                byte[] byArray2 = byArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, byArray2[n12] & 0xFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                byte[] byArray3 = byArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(byArray3[n20] & 0xFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12] & 0xFFFF);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[(sArray3[n20] & 0xFFFF) - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, int[][] nArray3, int[] nArray4, int[][] nArray5) {
        if (nArray5 == null) {
            int n8 = 0;
            while (n8 < n5) {
                short[] sArray2 = sArray[n8];
                int[] nArray6 = nArray3[n8];
                int n9 = nArray[n8];
                int n10 = nArray2[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray6[n13] = this.data.getElem(n8, sArray2[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                short[] sArray3 = sArray[n15];
                int[] nArray7 = nArray3[n15];
                int[] nArray8 = nArray5[n15];
                int n16 = nArray[n15];
                int n17 = nArray2[n15];
                int n18 = nArray4[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray7[n21] = nArray8[sArray3[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, int[][] nArray4, int[] nArray5, int[][] nArray6) {
        if (nArray6 == null) {
            int n8 = 0;
            while (n8 < n5) {
                int[] nArray7 = nArray2[n8];
                int[] nArray8 = nArray4[n8];
                int n9 = nArray[n8];
                int n10 = nArray3[n8];
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = n9;
                    int n13 = n10;
                    n9 += n;
                    n10 += n6;
                    int n14 = 0;
                    while (n14 < n3) {
                        nArray8[n13] = this.data.getElem(n8, nArray7[n12]);
                        n12 += n2;
                        n13 += n7;
                        ++n14;
                    }
                    ++n11;
                }
                ++n8;
            }
        } else {
            int n15 = 0;
            while (n15 < n5) {
                int[] nArray9 = nArray2[n15];
                int[] nArray10 = nArray4[n15];
                int[] nArray11 = nArray6[n15];
                int n16 = nArray[n15];
                int n17 = nArray3[n15];
                int n18 = nArray5[n15];
                int n19 = 0;
                while (n19 < n4) {
                    int n20 = n16;
                    int n21 = n17;
                    n16 += n;
                    n17 += n6;
                    int n22 = 0;
                    while (n22 < n3) {
                        nArray10[n21] = nArray11[nArray9[n20] - n18];
                        n20 += n2;
                        n21 += n7;
                        ++n22;
                    }
                    ++n19;
                }
                ++n15;
            }
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, float[][] fArray, int[] nArray3, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, float[][] fArray, int[] nArray4, float[][] fArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    fArray3[n14] = fArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, byte[][] byArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray2 = byArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(byArray2[n13] & 0xFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookupU(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[(sArray2[n13] & 0xFFFF) - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, short[][] sArray, int n3, int n4, int n5, int n6, int n7, int[] nArray2, double[][] dArray, int[] nArray3, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray2 = sArray[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = nArray3[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[sArray2[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    private void lookup(int n, int n2, int[] nArray, int[][] nArray2, int n3, int n4, int n5, int n6, int n7, int[] nArray3, double[][] dArray, int[] nArray4, double[][] dArray2) {
        int n8 = 0;
        while (n8 < n5) {
            int[] nArray5 = nArray2[n8];
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = nArray4[n8];
            int n12 = 0;
            while (n12 < n4) {
                int n13 = n9;
                int n14 = n10;
                n9 += n;
                n10 += n6;
                int n15 = 0;
                while (n15 < n3) {
                    dArray3[n14] = dArray4[nArray5[n13] - n11];
                    n13 += n2;
                    n14 += n7;
                    ++n15;
                }
                ++n12;
            }
            ++n8;
        }
    }

    public int findNearestEntry(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = this.data.getDataType();
        int n2 = this.getNumBands();
        int n3 = this.getNumEntries();
        int n4 = -1;
        if (n == 0) {
            float f;
            byte[][] byArray = this.getByteData();
            float f2 = 0.0f;
            n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                f = fArray[n5] - (float)(byArray[n5][0] & 0xFF);
                f2 += f * f;
                ++n5;
            }
            n5 = 1;
            while (n5 < n3) {
                f = 0.0f;
                int n6 = 0;
                while (n6 < n2) {
                    float f3 = fArray[n6] - (float)(byArray[n6][n5] & 0xFF);
                    f += f3 * f3;
                    ++n6;
                }
                if (f < f2) {
                    f2 = f;
                    n4 = n5;
                }
                ++n5;
            }
        } else if (n == 2) {
            float f;
            short[][] sArray = this.getShortData();
            float f4 = 0.0f;
            n4 = 0;
            int n7 = 0;
            while (n7 < n2) {
                f = fArray[n7] - (float)sArray[n7][0];
                f4 += f * f;
                ++n7;
            }
            n7 = 1;
            while (n7 < n3) {
                f = 0.0f;
                int n8 = 0;
                while (n8 < n2) {
                    float f5 = fArray[n8] - (float)sArray[n8][n7];
                    f += f5 * f5;
                    ++n8;
                }
                if (f < f4) {
                    f4 = f;
                    n4 = n7;
                }
                ++n7;
            }
        } else if (n == 1) {
            float f;
            short[][] sArray = this.getShortData();
            float f6 = 0.0f;
            n4 = 0;
            int n9 = 0;
            while (n9 < n2) {
                f = fArray[n9] - (float)(sArray[n9][0] & 0xFFFF);
                f6 += f * f;
                ++n9;
            }
            n9 = 1;
            while (n9 < n3) {
                f = 0.0f;
                int n10 = 0;
                while (n10 < n2) {
                    float f7 = fArray[n10] - (float)(sArray[n10][n9] & 0xFFFF);
                    f += f7 * f7;
                    ++n10;
                }
                if (f < f6) {
                    f6 = f;
                    n4 = n9;
                }
                ++n9;
            }
        } else if (n == 3) {
            float f;
            int[][] nArray = this.getIntData();
            float f8 = 0.0f;
            n4 = 0;
            int n11 = 0;
            while (n11 < n2) {
                f = fArray[n11] - (float)nArray[n11][0];
                f8 += f * f;
                ++n11;
            }
            n11 = 1;
            while (n11 < n3) {
                f = 0.0f;
                int n12 = 0;
                while (n12 < n2) {
                    float f9 = fArray[n12] - (float)nArray[n12][n11];
                    f += f9 * f9;
                    ++n12;
                }
                if (f < f8) {
                    f8 = f;
                    n4 = n11;
                }
                ++n11;
            }
        } else if (n == 4) {
            float f;
            float[][] fArray2 = this.getFloatData();
            float f10 = 0.0f;
            n4 = 0;
            int n13 = 0;
            while (n13 < n2) {
                f = fArray[n13] - fArray2[n13][0];
                f10 += f * f;
                ++n13;
            }
            n13 = 1;
            while (n13 < n3) {
                f = 0.0f;
                int n14 = 0;
                while (n14 < n2) {
                    float f11 = fArray[n14] - fArray2[n14][n13];
                    f += f11 * f11;
                    ++n14;
                }
                if (f < f10) {
                    f10 = f;
                    n4 = n13;
                }
                ++n13;
            }
        } else if (n == 5) {
            double d;
            double[][] dArray = this.getDoubleData();
            double d2 = 0.0;
            n4 = 0;
            int n15 = 0;
            while (n15 < n2) {
                d = (double)fArray[n15] - dArray[n15][0];
                d2 += d * d;
                ++n15;
            }
            n15 = 1;
            while (n15 < n3) {
                d = 0.0;
                int n16 = 0;
                while (n16 < n2) {
                    double d3 = (double)fArray[n16] - dArray[n16][n15];
                    d += d3 * d3;
                    ++n16;
                }
                if (d < d2) {
                    d2 = d;
                    n4 = n15;
                }
                ++n15;
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("LookupTableJAI0"));
        }
        return n4 == -1 ? n4 : n4 + this.getOffset();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(SerializerFactory.getState(this.data));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)object;
        this.data = (DataBuffer)serializableState.getObject();
    }

    private void initOffsets(int n, int n2) {
        this.tableOffsets = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.tableOffsets[n3] = n2;
            ++n3;
        }
    }

    private void initOffsets(int n, int[] nArray) {
        this.tableOffsets = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.tableOffsets[n2] = nArray[n2];
            ++n2;
        }
    }
}

