/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.Kernel;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public class KernelJAI
implements Serializable {
    public static final KernelJAI ERROR_FILTER_FLOYD_STEINBERG = new KernelJAI(3, 2, 1, 0, new float[]{0.0f, 0.0f, 0.4375f, 0.1875f, 0.3125f, 0.0625f});
    public static final KernelJAI ERROR_FILTER_JARVIS = new KernelJAI(5, 3, 2, 0, new float[]{0.0f, 0.0f, 0.0f, 0.14583333f, 0.104166664f, 0.0625f, 0.104166664f, 0.14583333f, 0.104166664f, 0.0625f, 0.020833334f, 0.0625f, 0.104166664f, 0.0625f, 0.020833334f});
    public static final KernelJAI ERROR_FILTER_STUCKI = new KernelJAI(5, 3, 2, 0, new float[]{0.0f, 0.0f, 0.0f, 0.16666667f, 0.11904762f, 0.04761905f, 0.0952381f, 0.1904762f, 0.0952381f, 0.04761905f, 0.023809524f, 0.04761905f, 0.0952381f, 0.04761905f, 0.023809524f});
    public static final KernelJAI[] DITHER_MASK_441 = new KernelJAI[]{new KernelJAI(4, 4, 1, 1, new float[]{0.9375f, 0.4375f, 0.8125f, 0.3125f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.0f, 0.5f, 0.125f, 0.625f})};
    public static final KernelJAI[] DITHER_MASK_443 = new KernelJAI[]{new KernelJAI(4, 4, 1, 1, new float[]{0.0f, 0.5f, 0.125f, 0.625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.9375f, 0.4375f, 0.8125f, 0.3125f}), new KernelJAI(4, 4, 1, 1, new float[]{0.625f, 0.125f, 0.5f, 0.0f, 0.375f, 0.875f, 0.25f, 0.75f, 0.5625f, 0.0625f, 0.6875f, 0.1875f, 0.3125f, 0.8125f, 0.4375f, 0.9375f}), new KernelJAI(4, 4, 1, 1, new float[]{0.9375f, 0.4375f, 0.8125f, 0.3125f, 0.1875f, 0.6875f, 0.0625f, 0.5625f, 0.75f, 0.25f, 0.875f, 0.375f, 0.0f, 0.5f, 0.125f, 0.625f})};
    public static final KernelJAI GRADIENT_MASK_SOBEL_VERTICAL = new KernelJAI(3, 3, 1, 1, new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f});
    public static final KernelJAI GRADIENT_MASK_SOBEL_HORIZONTAL = new KernelJAI(3, 3, 1, 1, new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f});
    protected int width;
    protected int height;
    protected int xOrigin;
    protected int yOrigin;
    protected float[] data = null;
    protected float[] dataH = null;
    protected float[] dataV = null;
    protected boolean isSeparable = false;
    protected boolean isHorizontallySymmetric = false;
    protected boolean isVerticallySymmetric = false;
    protected KernelJAI rotatedKernel = null;

    private synchronized void checkSeparable() {
        block17: {
            float f;
            float f2;
            int n;
            float f3;
            float f4;
            block16: {
                f4 = 1.0E-5f;
                if (this.isSeparable) {
                    return;
                }
                if (this.width <= 1 || this.height <= 1) {
                    return;
                }
                float f5 = 0.0f;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.data.length) {
                    f3 = Math.abs(this.data[n4]);
                    if (f3 > f5) {
                        n2 = n4;
                        f5 = f3;
                    }
                    ++n4;
                }
                if (f5 < f4 / (float)this.data.length) {
                    this.isSeparable = false;
                    return;
                }
                float[] fArray = new float[this.width];
                f3 = 1.0f / this.data[n2];
                n3 = n2 % this.width;
                n2 /= this.width;
                int n5 = 0;
                while (n5 < this.width) {
                    fArray[n5] = this.data[n2 * this.width + n5] * f3;
                    ++n5;
                }
                n5 = 0;
                int n6 = 0;
                while (n5 < this.height) {
                    n = 0;
                    while (n < this.width) {
                        float f6 = Math.abs(this.data[n6 + n3] * fArray[n] - this.data[n6 + n]);
                        if (f6 > f4) {
                            this.isSeparable = false;
                            return;
                        }
                        ++n;
                    }
                    ++n5;
                    n6 += this.width;
                }
                this.dataH = fArray;
                this.dataV = new float[this.height];
                n5 = 0;
                while (n5 < this.height) {
                    this.dataV[n5] = this.data[n3 + n5 * this.width];
                    ++n5;
                }
                this.isSeparable = true;
                f2 = 0.0f;
                f = 0.0f;
                n = 0;
                while (n < this.width) {
                    f2 += this.dataH[n];
                    ++n;
                }
                n = 0;
                while (n < this.height) {
                    f += this.dataV[n];
                    ++n;
                }
                if (!(Math.abs(f2) >= Math.abs(f)) || !(Math.abs(f2) > f4)) break block16;
                f3 = 1.0f / f2;
                n = 0;
                while (n < this.width) {
                    int n7 = n++;
                    this.dataH[n7] = this.dataH[n7] * f3;
                }
                n = 0;
                while (n < this.height) {
                    int n8 = n++;
                    this.dataV[n8] = this.dataV[n8] * f2;
                }
                break block17;
            }
            if (!(Math.abs(f2) < Math.abs(f)) || !(Math.abs(f) > f4)) break block17;
            f3 = 1.0f / f;
            n = 0;
            while (n < this.width) {
                int n9 = n++;
                this.dataH[n9] = this.dataH[n9] * f;
            }
            n = 0;
            while (n < this.height) {
                int n10 = n++;
                this.dataV[n10] = this.dataV[n10] * f3;
            }
        }
    }

    private void classifyKernel() {
        if (!this.isSeparable) {
            this.checkSeparable();
        }
        this.isHorizontallySymmetric = false;
        this.isVerticallySymmetric = false;
    }

    public KernelJAI(int n, int n2, int n3, int n4, float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.width = n;
        this.height = n2;
        this.xOrigin = n3;
        this.yOrigin = n4;
        this.data = (float[])fArray.clone();
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n * n2 != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI2"));
        }
        this.classifyKernel();
    }

    public KernelJAI(int n, int n2, int n3, int n4, float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
        }
        if (n != fArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI3"));
        }
        if (n2 != fArray2.length) {
            throw new IllegalArgumentException(JaiI18N.getString("KernelJAI4"));
        }
        this.width = n;
        this.height = n2;
        this.xOrigin = n3;
        this.yOrigin = n4;
        this.dataH = (float[])fArray.clone();
        this.dataV = (float[])fArray2.clone();
        this.data = new float[fArray.length * fArray2.length];
        int n5 = 0;
        int n6 = 0;
        while (n6 < fArray2.length) {
            float f = fArray2[n6];
            int n7 = 0;
            while (n7 < fArray.length) {
                this.data[n5 + n7] = f * fArray[n7];
                ++n7;
            }
            n5 += fArray.length;
            ++n6;
        }
        this.isSeparable = true;
        this.classifyKernel();
    }

    public KernelJAI(int n, int n2, float[] fArray) {
        this(n, n2, n / 2, n2 / 2, fArray);
    }

    public KernelJAI(Kernel kernel) {
        this(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), kernel.getKernelData(null));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXOrigin() {
        return this.xOrigin;
    }

    public int getYOrigin() {
        return this.yOrigin;
    }

    public float[] getKernelData() {
        return (float[])this.data.clone();
    }

    public float[] getHorizontalKernelData() {
        if (this.dataH == null) {
            return null;
        }
        return (float[])this.dataH.clone();
    }

    public float[] getVerticalKernelData() {
        if (this.dataV == null) {
            return null;
        }
        return (float[])this.dataV.clone();
    }

    public float getElement(int n, int n2) {
        if (!this.isSeparable) {
            return this.data[n2 * this.width + n];
        }
        return this.dataH[n] * this.dataV[n2];
    }

    public boolean isSeparable() {
        return this.isSeparable;
    }

    public boolean isHorizontallySymmetric() {
        return this.isHorizontallySymmetric;
    }

    public boolean isVerticallySymmetric() {
        return this.isVerticallySymmetric;
    }

    public int getLeftPadding() {
        return this.xOrigin;
    }

    public int getRightPadding() {
        return this.width - this.xOrigin - 1;
    }

    public int getTopPadding() {
        return this.yOrigin;
    }

    public int getBottomPadding() {
        return this.height - this.yOrigin - 1;
    }

    public KernelJAI getRotatedKernel() {
        if (this.rotatedKernel == null) {
            if (this.isSeparable) {
                float[] fArray = new float[this.width];
                float[] fArray2 = new float[this.height];
                int n = 0;
                while (n < this.width) {
                    fArray[n] = this.dataH[this.width - 1 - n];
                    ++n;
                }
                n = 0;
                while (n < this.height) {
                    fArray2[n] = this.dataV[this.height - 1 - n];
                    ++n;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray, fArray2);
            } else {
                int n = this.data.length;
                float[] fArray = new float[this.data.length];
                int n2 = 0;
                while (n2 < n) {
                    fArray[n2] = this.data[n - 1 - n2];
                    ++n2;
                }
                this.rotatedKernel = new KernelJAI(this.width, this.height, this.width - 1 - this.xOrigin, this.height - 1 - this.yOrigin, fArray);
            }
        }
        return this.rotatedKernel;
    }
}

