/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.InterpolationTable;

public final class InterpolationBicubic2
extends InterpolationTable {
    private static final int PRECISION_BITS = 8;
    private static final float A = -1.0f;
    private static final float A3 = 1.0f;
    private static final float A2 = -2.0f;
    private static final float A0 = 1.0f;
    private static final float B3 = -1.0f;
    private static final float B2 = 5.0f;
    private static final float B1 = -8.0f;
    private static final float B0 = 4.0f;

    private static float[] dataHelper(int n) {
        int n2 = 1 << n;
        int n3 = n2 * 4;
        float[] fArray = new float[n3];
        float f = n2;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            float f2 = (float)n5 / f;
            fArray[n4++] = InterpolationBicubic2.bicubic(f2 + 1.0f);
            fArray[n4++] = InterpolationBicubic2.bicubic(f2);
            fArray[n4++] = InterpolationBicubic2.bicubic(f2 - 1.0f);
            fArray[n4++] = InterpolationBicubic2.bicubic(f2 - 2.0f);
            ++n5;
        }
        return fArray;
    }

    private static float bicubic(float f) {
        if (f < 0.0f) {
            f = -f;
        }
        if (f >= 1.0f) {
            return ((-1.0f * f + 5.0f) * f + -8.0f) * f + 4.0f;
        }
        return (1.0f * f + -2.0f) * f * f + 1.0f;
    }

    public InterpolationBicubic2(int n) {
        super(1, 1, 4, 4, n, n, 8, InterpolationBicubic2.dataHelper(n), (float[])null);
    }
}

