/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.UnpackedImageData;

public class Histogram
implements Serializable {
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private int numBands;
    private double[] binWidth;
    private int[][] bins = null;
    private int[] totals = null;
    private double[] mean = null;

    private static final int[] fill(int[] nArray, int n) {
        int[] nArray2 = null;
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n > 0) {
            nArray2 = new int[n];
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                nArray2[n3] = n3 < n2 ? nArray[n3] : nArray[0];
                ++n3;
            }
        }
        return nArray2;
    }

    private static final double[] fill(double[] dArray, int n) {
        double[] dArray2 = null;
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n > 0) {
            dArray2 = new double[n];
            int n2 = dArray.length;
            int n3 = 0;
            while (n3 < n) {
                dArray2[n3] = n3 < n2 ? dArray[n3] : dArray[0];
                ++n3;
            }
        }
        return dArray2;
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2) {
        if (nArray == null || dArray == null || dArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.numBands = nArray.length;
        if (dArray.length != this.numBands || dArray2.length != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram0"));
        }
        if (this.numBands == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        int n = 0;
        while (n < this.numBands) {
            if (nArray[n] <= 0) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
            }
            if (dArray[n] >= dArray2[n]) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
            }
            ++n;
        }
        this.numBins = (int[])nArray.clone();
        this.lowValue = (double[])dArray.clone();
        this.highValue = (double[])dArray2.clone();
        this.binWidth = new double[this.numBands];
        n = 0;
        while (n < this.numBands) {
            this.binWidth[n] = (dArray2[n] - dArray[n]) / (double)nArray[n];
            ++n;
        }
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2, int n) {
        this(Histogram.fill(nArray, n), Histogram.fill(dArray, n), Histogram.fill(dArray2, n));
    }

    public Histogram(int n, double d, double d2, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
        }
        if (d >= d2) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
        }
        this.numBands = n2;
        this.numBins = new int[n2];
        this.lowValue = new double[n2];
        this.highValue = new double[n2];
        this.binWidth = new double[n2];
        double d3 = (d2 - d) / (double)n;
        int n3 = 0;
        while (n3 < n2) {
            this.numBins[n3] = n;
            this.lowValue[n3] = d;
            this.highValue[n3] = d2;
            this.binWidth[n3] = d3;
            ++n3;
        }
    }

    public int[] getNumBins() {
        return (int[])this.numBins.clone();
    }

    public int getNumBins(int n) {
        return this.numBins[n];
    }

    public double[] getLowValue() {
        return (double[])this.lowValue.clone();
    }

    public double getLowValue(int n) {
        return this.lowValue[n];
    }

    public double[] getHighValue() {
        return (double[])this.highValue.clone();
    }

    public double getHighValue(int n) {
        return this.highValue[n];
    }

    public int getNumBands() {
        return this.numBands;
    }

    public synchronized int[][] getBins() {
        if (this.bins == null) {
            this.bins = new int[this.numBands][];
            int n = 0;
            while (n < this.numBands) {
                this.bins[n] = new int[this.numBins[n]];
                ++n;
            }
        }
        return this.bins;
    }

    public int[] getBins(int n) {
        this.getBins();
        return this.bins[n];
    }

    public int getBinSize(int n, int n2) {
        this.getBins();
        return this.bins[n][n2];
    }

    public double getBinLowValue(int n, int n2) {
        return this.lowValue[n] + (double)n2 * this.binWidth[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearHistogram() {
        if (this.bins == null) return;
        int[][] nArray = this.bins;
        synchronized (this.bins) {
            int n = 0;
            while (n < this.numBands) {
                int[] nArray2 = this.bins[n];
                int n2 = nArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    nArray2[n3] = 0;
                    ++n3;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getTotals() {
        if (this.totals == null) {
            this.getBins();
            Histogram histogram = this;
            synchronized (histogram) {
                this.totals = new int[this.numBands];
                int n = 0;
                while (n < this.numBands) {
                    int[] nArray = this.bins[n];
                    int n2 = nArray.length;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < n2) {
                        n3 += nArray[n4];
                        ++n4;
                    }
                    this.totals[n] = n3;
                    ++n;
                }
            }
        }
        return this.totals;
    }

    public int getSubTotal(int n, int n2, int n3) {
        if (n2 < 0 || n3 >= this.numBins[n]) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("Histogram5"));
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram10"));
        }
        int[] nArray = this.getBins(n);
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            n4 += nArray[n5];
            ++n5;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getMean() {
        if (this.mean == null) {
            this.getTotals();
            Histogram histogram = this;
            synchronized (histogram) {
                this.mean = new double[this.numBands];
                int n = 0;
                while (n < this.numBands) {
                    int[] nArray = this.getBins(n);
                    int n2 = this.numBins[n];
                    double d = this.getLowValue(n);
                    double d2 = this.binWidth[n];
                    double d3 = 0.0;
                    double d4 = this.totals[n];
                    int n3 = 0;
                    while (n3 < n2) {
                        d3 += (double)nArray[n3] / d4 * d;
                        d += d2;
                        ++n3;
                    }
                    this.mean[n] = d3;
                    ++n;
                }
            }
        }
        return this.mean;
    }

    public void countPixels(Raster raster, ROI rOI, int n, int n2, int n3, int n4) {
        LinkedList linkedList;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram4"));
        }
        Rectangle rectangle = raster.getBounds();
        if (rOI == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = rOI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            int n5 = rectangle2.x;
            int n6 = rectangle2.y;
            rectangle2.x = this.startPosition(n5, n, n3);
            rectangle2.y = this.startPosition(n6, n2, n4);
            rectangle2.width = n5 + rectangle2.width - rectangle2.x;
            rectangle2.height = n6 + rectangle2.height - rectangle2.y;
            if (rectangle2.width <= 0 || rectangle2.height <= 0) continue;
            switch (pixelAccessor.sampleType) {
                case -1: 
                case 0: {
                    this.countPixelsByte(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 1: {
                    this.countPixelsUShort(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 2: {
                    this.countPixelsShort(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 3: {
                    this.countPixelsInt(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 4: {
                    this.countPixelsFloat(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 5: {
                    this.countPixelsDouble(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("Histogram11"));
                }
            }
        }
    }

    private void countPixelsByte(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 0, false);
        byte[][] byArray = unpackedImageData.getByteData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            byte[] byArray2 = byArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = byArray2[n8] & 0xFF;
                    n8 += n3;
                    if ((double)n10 >= d && (double)n10 < d2) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d) / d3);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsUShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 1, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = sArray2[n8] & 0xFFFF;
                    n8 += n3;
                    if ((double)n10 >= d && (double)n10 < d2) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d) / d3);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 2, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    short s = sArray2[n8];
                    n8 += n3;
                    if ((double)s >= d && (double)s < d2) {
                        int n10;
                        int n11 = n10 = (int)(((double)s - d) / d3);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsInt(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 3, false);
        int[][] nArray = unpackedImageData.getIntData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray2 = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            int[] nArray3 = nArray[n5];
            int n6 = nArray2[n5];
            int[] nArray4 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = nArray3[n8];
                    n8 += n3;
                    if ((double)n10 >= d && (double)n10 < d2) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d) / d3);
                        nArray4[n12] = nArray4[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray4);
            ++n5;
        }
    }

    private void countPixelsFloat(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 4, false);
        float[][] fArray = unpackedImageData.getFloatData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            float[] fArray2 = fArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    float f = fArray2[n8];
                    n8 += n3;
                    if ((double)f >= d && (double)f < d2) {
                        int n10;
                        int n11 = n10 = (int)(((double)f - d) / d3);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsDouble(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 5, false);
        double[][] dArray = unpackedImageData.getDoubleData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            double[] dArray2 = dArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d = this.lowValue[n5];
            double d2 = this.highValue[n5];
            double d3 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    double d4 = dArray2[n8];
                    n8 += n3;
                    if (d4 >= d && d4 < d2) {
                        int n10;
                        int n11 = n10 = (int)((d4 - d) / d3);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeBins(int n, int[] nArray) {
        this.getBins();
        int[][] nArray2 = this.bins;
        synchronized (this.bins) {
            int[] nArray3 = this.bins[n];
            int n2 = nArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                nArray3[n4] = nArray3[n4] + nArray[n3];
                ++n3;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public double[] getMoment(int n, boolean bl, boolean bl2) {
        if (n < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram6"));
        }
        if ((n == 1 || bl2) && this.mean == null) {
            this.getMean();
        }
        if (n == 1 && !bl && !bl2) {
            return this.mean;
        }
        double[] dArray = new double[this.numBands];
        if (n == 1 && bl2) {
            int n2 = 0;
            while (n2 < this.numBands) {
                dArray[n2] = 0.0;
                ++n2;
            }
        } else {
            this.getTotals();
            int n3 = 0;
            while (n3 < this.numBands) {
                int[] nArray = this.getBins(n3);
                int n4 = this.numBins[n3];
                double d = this.getLowValue(n3);
                double d2 = this.binWidth[n3];
                double d3 = this.totals[n3];
                double d4 = 0.0;
                if (bl2) {
                    int n5;
                    double d5 = this.mean[n3];
                    if (bl && n % 2 == 0) {
                        n5 = 0;
                        while (n5 < n4) {
                            d4 += Math.pow(d - d5, n) * (double)nArray[n5] / d3;
                            d += d2;
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < n4) {
                            d4 += Math.abs(Math.pow(d - d5, n)) * (double)nArray[n5] / d3;
                            d += d2;
                            ++n5;
                        }
                    }
                } else if (bl && n % 2 != 0) {
                    int n6 = 0;
                    while (n6 < n4) {
                        d4 += Math.abs(Math.pow(d, n)) * (double)nArray[n6] / d3;
                        d += d2;
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n4) {
                        d4 += Math.pow(d, n) * (double)nArray[n7] / d3;
                        d += d2;
                        ++n7;
                    }
                }
                dArray[n3] = d4;
                ++n3;
            }
        }
        return dArray;
    }

    public double[] getStandardDeviation() {
        this.getMean();
        double[] dArray = this.getMoment(2, false, false);
        double[] dArray2 = new double[this.numBands];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = Math.sqrt(dArray[n] - this.mean[n] * this.mean[n]);
            ++n;
        }
        return dArray2;
    }

    public double[] getEntropy() {
        this.getTotals();
        double d = Math.log(2.0);
        double[] dArray = new double[this.numBands];
        int n = 0;
        while (n < this.numBands) {
            int[] nArray = this.getBins(n);
            int n2 = this.numBins[n];
            double d2 = this.totals[n];
            double d3 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                double d4 = (double)nArray[n3] / d2;
                if (d4 != 0.0) {
                    d3 -= d4 * (Math.log(d4) / d);
                }
                ++n3;
            }
            dArray[n] = d3;
            ++n;
        }
        return dArray;
    }

    public Histogram getSmoothed(boolean bl, int n) {
        int n2;
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram7"));
        }
        if (n == 0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        double[] dArray = null;
        if (bl) {
            n3 = 2 * n + 1;
            double d = n3 * n3;
            dArray = new double[n3];
            n2 = 0;
            while (n2 <= n) {
                dArray[n2] = (double)(n2 + 1) / d;
                ++n2;
            }
            n2 = n + 1;
            while (n2 < n3) {
                dArray[n2] = dArray[n3 - 1 - n2];
                ++n2;
            }
        }
        n3 = 0;
        while (n3 < this.numBands) {
            int n4;
            int n5;
            int n6;
            int n7;
            int[] nArray2 = this.getBins(n3);
            int[] nArray3 = nArray[n3];
            n2 = histogram.getNumBins(n3);
            int n8 = 0;
            if (bl) {
                n7 = 0;
                while (n7 < n2) {
                    n6 = Math.max(n7 - n, 0);
                    n5 = Math.min(n7 + n, n2);
                    n4 = n > n7 ? n - n7 : 0;
                    double d = 0.0;
                    double d2 = 0.0;
                    int n9 = n6;
                    while (n9 < n5) {
                        double d3 = dArray[n4++];
                        d += (double)nArray2[n9] * d3;
                        d2 += d3;
                        ++n9;
                    }
                    nArray3[n7] = (int)(d / d2 + 0.5);
                    n8 += nArray3[n7];
                    ++n7;
                }
            } else {
                n7 = 0;
                while (n7 < n2) {
                    n6 = Math.max(n7 - n, 0);
                    n5 = Math.min(n7 + n, n2);
                    n4 = 0;
                    int n10 = n6;
                    while (n10 < n5) {
                        n4 += nArray2[n10];
                        ++n10;
                    }
                    nArray3[n7] = (int)((double)n4 / (double)(n5 - n6 + 1) + 0.5);
                    n8 += nArray3[n7];
                    ++n7;
                }
            }
            double d = (double)this.totals[n3] / (double)n8;
            n5 = 0;
            while (n5 < n2) {
                nArray3[n5] = (int)((double)nArray3[n5] * d + 0.5);
                ++n5;
            }
            ++n3;
        }
        return histogram;
    }

    public Histogram getGaussianSmoothed(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram8"));
        }
        if (d == 0.0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        int n = (int)(5.16 * d + 0.5);
        if (n % 2 == 0) {
            ++n;
        }
        double[] dArray = new double[n];
        int n2 = n / 2;
        double d2 = d * d;
        double d3 = 1.0 / Math.sqrt(Math.PI * 2 * d2);
        double d4 = -1.0 / (2.0 * d2);
        int n3 = n2;
        while (n3 < n) {
            double d5 = n3 - n2;
            double d6 = d3 * Math.exp(d4 * d5 * d5);
            dArray[n - 1 - n3] = d6;
            dArray[n3] = d6;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.numBands) {
            int n4;
            int[] nArray2 = this.getBins(n3);
            int[] nArray3 = nArray[n3];
            int n5 = histogram.getNumBins(n3);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                int n8 = Math.max(n7 - n2, 0);
                n4 = Math.min(n7 + n2, n5);
                int n9 = n2 > n7 ? n2 - n7 : 0;
                double d7 = 0.0;
                double d8 = 0.0;
                int n10 = n8;
                while (n10 < n4) {
                    double d9 = dArray[n9++];
                    d7 += (double)nArray2[n10] * d9;
                    d8 += d9;
                    ++n10;
                }
                nArray3[n7] = (int)(d7 / d8 + 0.5);
                n6 += nArray3[n7];
                ++n7;
            }
            double d10 = (double)this.totals[n3] / (double)n6;
            n4 = 0;
            while (n4 < n5) {
                nArray3[n4] = (int)((double)nArray3[n4] * d10 + 0.5);
                ++n4;
            }
            ++n3;
        }
        return histogram;
    }

    public double[] getPTileThreshold(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram9"));
        }
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int cfr_ignored_0 = this.numBins[n];
            int[] nArray = this.getBins(n);
            int n2 = this.totals[n];
            int n3 = 0;
            int n4 = nArray[0];
            int n5 = 0;
            while ((double)n4 / (double)n2 < d) {
                ++n3;
                n4 += nArray[++n5];
            }
            dArray[n] = this.getLowValue(n) + (double)n3 * this.binWidth[n];
            ++n;
        }
        return dArray;
    }

    public double[] getModeThreshold(double d) {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            int n3 = 0;
            int n4 = nArray[0];
            int n5 = 1;
            while (n5 < n2) {
                if (nArray[n5] > n4) {
                    n3 = n5;
                    n4 = nArray[n5];
                }
                ++n5;
            }
            n5 = -1;
            double d2 = 0.0;
            int n6 = 0;
            while (n6 < n2) {
                double d3 = (double)nArray[n6] * Math.pow(Math.abs(n6 - n3), d);
                if (d3 > d2) {
                    n5 = n6;
                    d2 = d3;
                }
                ++n6;
            }
            n6 = nArray[n3];
            int n7 = n3 + 1;
            while (n7 <= n5) {
                if (nArray[n7] < n6) {
                    n6 = nArray[n7];
                }
                ++n7;
            }
            dArray[n] = (int)((double)(n3 + n5) / 2.0 + 0.5);
            ++n;
        }
        return dArray;
    }

    public double[] getIterativeThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d = this.binWidth[n];
            double d2 = 0.5 * (this.getLowValue(n) + this.getHighValue(n));
            double d3 = 0.5 * (this.getLowValue(n) + d2);
            double d4 = 0.5 * (d2 + this.getHighValue(n));
            if (this.totals[n] != 0) {
                double d5;
                double d6;
                int n3 = 1000;
                do {
                    dArray[n] = d2;
                    double d7 = this.totals[n];
                    double d8 = this.getLowValue(n);
                    d6 = 0.0;
                    d5 = 0.0;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n2) {
                        if (d8 <= d2) {
                            int n6 = nArray[n5];
                            d6 += (double)n6 * d8;
                            n4 += n6;
                        } else {
                            d5 += (double)nArray[n5] * d8;
                        }
                        d8 += d;
                        ++n5;
                    }
                    d6 = n4 != 0 ? (d6 /= (double)n4) : d3;
                    if (d7 != (double)n4) {
                        d5 /= d7 - (double)n4;
                        continue;
                    }
                    d5 = d4;
                } while (Math.abs((d2 = 0.5 * (d6 + d5)) - dArray[n]) > 1.0E-6 && --n3 > 0);
            } else {
                dArray[n] = d2;
            }
            ++n;
        }
        return dArray;
    }

    public double[] getMaxVarianceThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        this.getMoment(2, false, false);
        int n = 0;
        while (n < this.numBands) {
            double d;
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d2 = this.totals[n];
            double d3 = this.mean[n];
            double d4 = this.binWidth[n];
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = d = this.getLowValue(n);
            double d8 = -1.7976931348623157E308;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                double d9 = (double)nArray[n5] / d2;
                if ((d5 += d9) != 0.0) {
                    double d10 = (d6 += d9 * d7) / d5;
                    double d11 = 1.0 - d5;
                    if (d11 != 0.0) {
                        double d12 = (d3 - d6) / d11;
                        double d13 = 0.0;
                        double d14 = d;
                        int n6 = 0;
                        while (n6 <= n5) {
                            double d15 = d14 - d10;
                            d13 += d15 * d15 * (double)nArray[n6];
                            ++n6;
                            d14 += d4;
                        }
                        d13 /= d2;
                        double d16 = 0.0;
                        int n7 = n5 + 1;
                        while (n7 < n2) {
                            double d17 = d14 - d12;
                            d16 += d17 * d17 * (double)nArray[n7];
                            ++n7;
                            d14 += d4;
                        }
                        if (d13 == 0.0 && (d16 /= d2) == 0.0 && d12 != 0.0) {
                            n3 = (int)(((d10 + d12) / 2.0 - this.getLowValue(n)) / d4 + 0.5);
                            n4 = 0;
                            break;
                        }
                        if (!(d13 / d5 < 0.5) && !(d16 / d11 < 0.5)) {
                            double d18 = d10 - d12;
                            double d19 = d5 * d11 * d18 * d18 / (d13 + d16);
                            if (d19 > d8) {
                                d8 = d19;
                                n3 = n5;
                                n4 = 0;
                            } else if (d19 == d8) {
                                ++n4;
                            }
                        }
                    }
                }
                ++n5;
                d7 += d4;
            }
            dArray[n] = this.getLowValue(n) + ((double)n3 + (double)n4 / 2.0 + 0.5) * d4;
            ++n;
        }
        return dArray;
    }

    public double[] getMaxEntropyThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        double[] dArray2 = this.getEntropy();
        double d = Math.log(2.0);
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d2 = this.totals[n];
            double d3 = dArray2[n];
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = -1.7976931348623157E308;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                double d7 = (double)nArray[n5] / d2;
                if (d7 != 0.0) {
                    d4 += d7;
                    d5 -= d7 * Math.log(d7) / d;
                    double d8 = 0.0;
                    int n6 = 0;
                    while (n6 <= n5) {
                        if ((double)nArray[n6] > d8) {
                            d8 = nArray[n6];
                        }
                        ++n6;
                    }
                    if (d8 != 0.0) {
                        double d9 = 0.0;
                        int n7 = n5 + 1;
                        while (n7 < n2) {
                            if ((double)nArray[n7] > d9) {
                                d9 = nArray[n7];
                            }
                            ++n7;
                        }
                        if (d9 != 0.0) {
                            double d10 = d5 / d3;
                            double d11 = d10 * Math.log(d4) / Math.log(d8 / d2) + (1.0 - d10) * Math.log(1.0 - d4) / Math.log(d9 / d2);
                            if (d11 > d6) {
                                d6 = d11;
                                n3 = n5;
                                n4 = 0;
                            } else if (d11 == d6) {
                                ++n4;
                            }
                        }
                    }
                }
                ++n5;
            }
            dArray[n] = this.getLowValue(n) + ((double)n3 + (double)n4 / 2.0 + 0.5) * this.binWidth[n];
            ++n;
        }
        return dArray;
    }

    public double[] getMinErrorThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d = this.totals[n];
            double d2 = this.getLowValue(n);
            double d3 = this.binWidth[n];
            int n3 = 0;
            int n4 = this.totals[n];
            double d4 = 0.0;
            double d5 = this.mean[n] * d;
            double d6 = d2;
            double d7 = Double.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            double d8 = Double.MAX_VALUE;
            double d9 = Double.MAX_VALUE;
            double d10 = Double.MAX_VALUE;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n2) {
                int n9 = nArray[n8];
                n4 -= n9;
                double d11 = d6 * (double)n9;
                d5 -= d11;
                if ((n3 += n9) != 0 && (d4 += d11) != 0.0) {
                    if (n4 == 0 || d5 == 0.0) break;
                    double d12 = d4 / (double)n3;
                    double d13 = d5 / (double)n4;
                    double d14 = 0.0;
                    double d15 = d2;
                    int n10 = 0;
                    while (n10 <= n8) {
                        double d16 = d15 - d12;
                        d14 += (double)nArray[n10] * d16 * d16;
                        ++n10;
                        d15 += d3;
                    }
                    if (!((d14 /= (double)n3) < 0.5)) {
                        double d17 = 0.0;
                        int n11 = n8 + 1;
                        while (n11 < n2) {
                            double d18 = d15 - d13;
                            d17 += (double)nArray[n11] * d18 * d18;
                            ++n11;
                            d15 += d3;
                        }
                        if (!((d17 /= (double)n4) < 0.5)) {
                            double d19 = (double)n3 / d;
                            double d20 = (double)n4 / d;
                            double d21 = 1.0 + d19 * Math.log(d14) + d20 * Math.log(d17) - 2.0 * (d19 * Math.log(d19) + d20 * Math.log(d20));
                            d8 = d9;
                            d9 = d10;
                            d10 = d21;
                            if (++n7 >= 3 && d9 <= d8 && d9 <= d10) {
                                if (d9 < d7) {
                                    d7 = d9;
                                    n5 = n8 - 1;
                                    n6 = 0;
                                } else if (d9 == d7) {
                                    ++n6;
                                }
                            }
                        }
                    }
                }
                ++n8;
                d6 += d3;
            }
            dArray[n] = n5 == 0 ? this.mean[n] : this.getLowValue(n) + ((double)n5 + (double)n6 / 2.0 + 0.5) * d3;
            ++n;
        }
        return dArray;
    }

    public double[] getMinFuzzinessThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n = 0;
        while (n < this.numBands) {
            double d;
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d2 = this.totals[n];
            double d3 = this.binWidth[n];
            int n3 = 0;
            int n4 = this.totals[n];
            double d4 = 0.0;
            double d5 = this.mean[n] * d2;
            double d6 = d = this.getLowValue(n);
            double d7 = this.getHighValue(n) - d;
            double d8 = Double.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = nArray[n7];
                double d9 = d6 * (double)n8;
                d4 += d9;
                d5 -= d9;
                if ((n3 += n8) != 0 && (n4 -= n8) != 0) {
                    double d10 = d4 / (double)n3;
                    double d11 = d5 / (double)n4;
                    double d12 = d;
                    double d13 = 0.0;
                    int n9 = 0;
                    while (n9 < n2) {
                        double d14 = n9 <= n7 ? 1.0 / (1.0 + Math.abs(d12 - d10) / d7) : 1.0 / (1.0 + Math.abs(d12 - d11) / d7);
                        double d15 = 1.0 - d14;
                        d13 += (-d14 * Math.log(d14) - d15 * Math.log(d15)) * ((double)nArray[n9] / d2);
                        ++n9;
                        d12 += d3;
                    }
                    if (d13 < d8) {
                        d8 = d13;
                        n5 = n7;
                        n6 = 0;
                    } else if (d13 == d8) {
                        ++n6;
                    }
                }
                ++n7;
                d6 += d3;
            }
            dArray[n] = d + ((double)n5 + (double)n6 / 2.0 + 0.5) * d3;
            ++n;
        }
        return dArray;
    }
}

