/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

public abstract class ColorSpaceJAI
extends ColorSpace {
    private static final double maxXYZ = 1.999969482421875;
    private static final double power1 = 0.4166666666666667;
    private static double[] LUT = new double[256];
    private boolean isRGBPreferredIntermediary;

    static {
        int n = 0;
        while (n < 256) {
            double d = (double)n / 255.0;
            ColorSpaceJAI.LUT[n] = d < 0.040449936 ? d / 12.92 : Math.pow((d + 0.055) / 1.055, 2.4);
            ++n;
        }
    }

    public static WritableRaster CIEXYZToRGB(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.CIEXYZToRGBByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.CIEXYZToRGBShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.CIEXYZToRGBInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.CIEXYZToRGBFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.CIEXYZToRGBDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    protected static void checkParameters(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI0"));
        }
        if (raster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI1"));
        }
        if (writableRaster != null && writableRaster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI2"));
        }
        if (nArray != null && nArray.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI3"));
        }
        if (nArray2 != null && nArray2.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI4"));
        }
    }

    static void convertToSigned(double[] dArray, int n) {
        block3: {
            block2: {
                if (n != 2) break block2;
                int n2 = 0;
                while (n2 < dArray.length) {
                    short s = (short)((int)dArray[n2] & 0xFFFF);
                    dArray[n2] = s;
                    ++n2;
                }
                break block3;
            }
            if (n != 3) break block3;
            int n3 = 0;
            while (n3 < dArray.length) {
                int n4 = (int)((long)dArray[n3] & 0xFFFFFFFFL);
                dArray[n3] = n4;
                ++n3;
            }
        }
    }

    static void XYZ2RGB(float[] fArray, float[] fArray2) {
        fArray2[0] = 2.9311228f * fArray[0] - 1.4111496f * fArray[1] - 0.6038046f * fArray[2];
        fArray2[1] = -0.8763701f * fArray[0] + 1.7219844f * fArray[1] + 0.0502565f * fArray[2];
        fArray2[2] = 0.05038065f * fArray[0] - 0.187272f * fArray[1] + 1.280027f * fArray[2];
        int n = 0;
        while (n < 3) {
            float f = fArray2[n];
            if (f < 0.0f) {
                f = 0.0f;
            }
            if (f < 0.0031308f) {
                fArray2[n] = 12.92f * f;
            } else {
                if (f > 1.0f) {
                    f = 1.0f;
                }
                fArray2[n] = (float)(1.055 * Math.pow(f, 0.4166666666666667) - 0.055);
            }
            ++n;
        }
    }

    private static void roundValues(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = (long)(dArray[n] + 0.5);
            ++n;
        }
    }

    static void CIEXYZToRGBByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        float f = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = (1L << nArray2[0]) - 1L;
            d2 = (1L << nArray2[1]) - 1L;
            d3 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray[0] = (float)(byArray[n12] & 0xFF) * f;
                fArray[1] = (float)(byArray2[n13] & 0xFF) * f2;
                fArray[2] = (float)(byArray3[n14] & 0xFF) * f3;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n9++] = d * (double)fArray2[0];
                dArray[n9++] = d2 * (double)fArray2[1];
                dArray[n9++] = d3 * (double)fArray2[2];
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void CIEXYZToRGBShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        float f = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = (1L << nArray2[0]) - 1L;
            d2 = (1L << nArray2[1]) - 1L;
            d3 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray[0] = (float)(sArray[n12] & 0xFFFF) * f;
                fArray[1] = (float)(sArray2[n13] & 0xFFFF) * f2;
                fArray[2] = (float)(sArray3[n14] & 0xFFFF) * f3;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n9++] = d * (double)fArray2[0];
                dArray[n9++] = d2 * (double)fArray2[1];
                dArray[n9++] = d3 * (double)fArray2[2];
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void CIEXYZToRGBInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        float f = (float)(1.999969482421875 / (double)((1L << nArray[0]) - 1L));
        float f2 = (float)(1.999969482421875 / (double)((1L << nArray[1]) - 1L));
        float f3 = (float)(1.999969482421875 / (double)((1L << nArray[2]) - 1L));
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = (1L << nArray2[0]) - 1L;
            d2 = (1L << nArray2[1]) - 1L;
            d3 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray[0] = (float)((long)nArray3[n12] & 0xFFFFFFFFL) * f;
                fArray[1] = (float)((long)nArray4[n13] & 0xFFFFFFFFL) * f2;
                fArray[2] = (float)((long)nArray5[n14] & 0xFFFFFFFFL) * f3;
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray[n9++] = d * (double)fArray2[0];
                dArray[n9++] = d2 * (double)fArray2[1];
                dArray[n9++] = d3 * (double)fArray2[2];
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void CIEXYZToRGBFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = (1L << nArray2[0]) - 1L;
            d2 = (1L << nArray2[1]) - 1L;
            d3 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray4[0] = fArray[n12];
                fArray4[1] = fArray2[n13];
                fArray4[2] = fArray3[n14];
                ColorSpaceJAI.XYZ2RGB(fArray4, fArray5);
                dArray[n9++] = d * (double)fArray5[0];
                dArray[n9++] = d2 * (double)fArray5[1];
                dArray[n9++] = d3 * (double)fArray5[2];
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void CIEXYZToRGBDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = (1L << nArray2[0]) - 1L;
            d2 = (1L << nArray2[1]) - 1L;
            d3 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray[0] = (float)dArray[n12];
                fArray[1] = (float)dArray2[n13];
                fArray[2] = (float)dArray3[n14];
                ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
                dArray4[n9++] = d * (double)fArray2[0];
                dArray4[n9++] = d2 * (double)fArray2[1];
                dArray4[n9++] = d3 * (double)fArray2[2];
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray4);
        }
        ColorSpaceJAI.convertToSigned(dArray4, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray4);
    }

    public static WritableRaster RGBToCIEXYZ(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.RGBToCIEXYZByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.RGBToCIEXYZShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.RGBToCIEXYZInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.RGBToCIEXYZFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.RGBToCIEXYZDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    static void RGB2XYZ(float[] fArray, float[] fArray2) {
        int n = 0;
        while (n < 3) {
            if (fArray[n] < 0.040449936f) {
                int n2 = n;
                fArray[n2] = fArray[n2] / 12.92f;
            } else {
                fArray[n] = (float)Math.pow(((double)fArray[n] + 0.055) / 1.055, 2.4);
            }
            ++n;
        }
        fArray2[0] = 0.45593762f * fArray[0] + 0.39533818f * fArray[1] + 0.19954965f * fArray[2];
        fArray2[1] = 0.23157515f * fArray[0] + 0.7790526f * fArray[1] + 0.07864978f * fArray[2];
        fArray2[2] = 0.01593493f * fArray[0] + 0.09841772f * fArray[1] + 0.7848861f * fArray[2];
    }

    private static void RGBToCIEXYZByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double d;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        int n = 8 - nArray[0];
        int n2 = 8 - nArray[1];
        int n3 = 8 - nArray[2];
        double d2 = d = 1.0;
        double d3 = d;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 < 4;
        if (bl) {
            d = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d2 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                double d4 = LUT[(byArray[n15] & 0xFF) << n];
                double d5 = LUT[(byArray2[n16] & 0xFF) << n2];
                double d6 = LUT[(byArray3[n17] & 0xFF) << n3];
                if (bl) {
                    dArray[n12++] = (0.45593763 * d4 + 0.39533819 * d5 + 0.19954964 * d6) * d;
                    dArray[n12++] = (0.23157515 * d4 + 0.77905262 * d5 + 0.07864978 * d6) * d2;
                    dArray[n12++] = (0.01593493 * d4 + 0.09841772 * d5 + 0.78488615 * d6) * d3;
                } else {
                    dArray[n12++] = 0.45593763 * d4 + 0.39533819 * d5 + 0.19954964 * d6;
                    dArray[n12++] = 0.23157515 * d4 + 0.77905262 * d5 + 0.07864978 * d6;
                    dArray[n12++] = 0.01593493 * d4 + 0.09841772 * d5 + 0.78488615 * d6;
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        if (n4 < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void RGBToCIEXYZShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        float f = (1 << nArray[0]) - 1;
        float f2 = (1 << nArray[1]) - 1;
        float f3 = (1 << nArray[2]) - 1;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            d2 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            d3 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray2[0] = (float)(sArray[n12] & 0xFFFF) / f;
                fArray2[1] = (float)(sArray2[n13] & 0xFFFF) / f2;
                fArray2[2] = (float)(sArray3[n14] & 0xFFFF) / f3;
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl) {
                    dArray[n9++] = (double)fArray[0] * d;
                    dArray[n9++] = (double)fArray[1] * d2;
                    dArray[n9++] = (double)fArray[2] * d3;
                } else {
                    dArray[n9++] = fArray[0];
                    dArray[n9++] = fArray[1];
                    dArray[n9++] = fArray[2];
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void RGBToCIEXYZInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        float f = (1L << nArray[0]) - 1L;
        float f2 = (1L << nArray[1]) - 1L;
        float f3 = (1L << nArray[2]) - 1L;
        double d = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            double cfr_ignored_0 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            double cfr_ignored_1 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray2[0] = (float)((long)nArray3[n12] & 0xFFFFFFFFL) / f;
                fArray2[1] = (float)((long)nArray4[n13] & 0xFFFFFFFFL) / f2;
                fArray2[2] = (float)((long)nArray5[n14] & 0xFFFFFFFFL) / f3;
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl) {
                    dArray[n9++] = (double)fArray[0] * d;
                    dArray[n9++] = (double)fArray[1] * d;
                    dArray[n9++] = (double)fArray[2] * d;
                } else {
                    dArray[n9++] = fArray[0];
                    dArray[n9++] = fArray[1];
                    dArray[n9++] = fArray[2];
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void RGBToCIEXYZFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            double cfr_ignored_0 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            double cfr_ignored_1 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray5[0] = fArray[n12];
                fArray5[1] = fArray2[n13];
                fArray5[2] = fArray3[n14];
                ColorSpaceJAI.RGB2XYZ(fArray5, fArray4);
                if (bl) {
                    dArray[n9++] = (double)fArray4[0] * d;
                    dArray[n9++] = (double)fArray4[1] * d;
                    dArray[n9++] = (double)fArray4[2] * d;
                } else {
                    dArray[n9++] = fArray4[0];
                    dArray[n9++] = fArray4[1];
                    dArray[n9++] = fArray4[2];
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray);
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void RGBToCIEXYZDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d = (double)((1L << nArray2[0]) - 1L) / 1.999969482421875;
            double cfr_ignored_0 = (double)((1L << nArray2[1]) - 1L) / 1.999969482421875;
            double cfr_ignored_1 = (double)((1L << nArray2[2]) - 1L) / 1.999969482421875;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                fArray2[0] = (float)dArray[n12];
                fArray2[1] = (float)dArray2[n13];
                fArray2[2] = (float)dArray3[n14];
                ColorSpaceJAI.RGB2XYZ(fArray2, fArray);
                if (bl) {
                    dArray4[n9++] = (double)fArray[0] * d;
                    dArray4[n9++] = (double)fArray[1] * d;
                    dArray4[n9++] = (double)fArray[2] * d;
                } else {
                    dArray4[n9++] = fArray[0];
                    dArray4[n9++] = fArray[1];
                    dArray4[n9++] = fArray[2];
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (n < 4) {
            ColorSpaceJAI.roundValues(dArray4);
        }
        ColorSpaceJAI.convertToSigned(dArray4, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray4);
    }

    protected ColorSpaceJAI(int n, int n2, boolean bl) {
        super(n, n2);
        this.isRGBPreferredIntermediary = bl;
    }

    public boolean isRGBPreferredIntermediary() {
        return this.isRGBPreferredIntermediary;
    }

    public abstract WritableRaster fromCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster fromRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);
}

