/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.JaiI18N;
import javax.media.jai.LookupTableJAI;

public class ColorCube
extends LookupTableJAI {
    public static final ColorCube BYTE_496 = ColorCube.createColorCube(0, 38, new int[]{4, 9, 6});
    public static final ColorCube BYTE_855 = ColorCube.createColorCube(0, 54, new int[]{8, 5, 5});
    private int[] dimension;
    private int[] dimsLessOne;
    private int[] multipliers;
    private int adjustedOffset;
    private int dataType;
    private int numBands;

    public static ColorCube createColorCube(int n, int n2, int[] nArray) {
        ColorCube colorCube;
        switch (n) {
            case 0: {
                colorCube = ColorCube.createColorCubeByte(n2, nArray);
                break;
            }
            case 2: {
                colorCube = ColorCube.createColorCubeShort(n2, nArray);
                break;
            }
            case 1: {
                colorCube = ColorCube.createColorCubeUShort(n2, nArray);
                break;
            }
            case 3: {
                colorCube = ColorCube.createColorCubeInt(n2, nArray);
                break;
            }
            case 4: {
                colorCube = ColorCube.createColorCubeFloat(n2, nArray);
                break;
            }
            case 5: {
                colorCube = ColorCube.createColorCubeDouble(n2, nArray);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube0"));
            }
        }
        return colorCube;
    }

    public static ColorCube createColorCube(int n, int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return ColorCube.createColorCube(n, 0, nArray);
    }

    private static ColorCube createColorCubeByte(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayByte(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayShort(n, nArray), n, false);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeUShort(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayUShort(n, nArray), n, true);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeInt(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayInt(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeFloat(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayFloat(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static ColorCube createColorCubeDouble(int n, int[] nArray) {
        ColorCube colorCube = new ColorCube(ColorCube.createDataArrayDouble(n, nArray), n);
        colorCube.initFields(n, nArray);
        return colorCube;
    }

    private static Object createDataArray(int n, int n2, int[] nArray) {
        Object object;
        double d;
        double d2;
        int n3 = nArray.length;
        if (n3 == 0) {
            throw new RuntimeException(JaiI18N.getString("ColorCube1"));
        }
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4] == 0) {
                throw new RuntimeException(JaiI18N.getString("ColorCube2"));
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray2[n5] = Math.abs(nArray[n5]);
            ++n5;
        }
        double d3 = nArray2[0];
        int n6 = 1;
        while (n6 < n3) {
            d3 *= (double)nArray2[n6];
            ++n6;
        }
        if (d3 > 2.147483647E9) {
            throw new RuntimeException(JaiI18N.getString("ColorCube3"));
        }
        n6 = (int)d3;
        switch (n) {
            case 0: {
                d2 = 0.0;
                d = 255.0;
                object = new byte[n3][n6];
                break;
            }
            case 2: {
                d2 = -32768.0;
                d = 32767.0;
                object = new short[n3][n6];
                break;
            }
            case 1: {
                d2 = 0.0;
                d = 65535.0;
                object = new short[n3][n6];
                break;
            }
            case 3: {
                d2 = -2.147483648E9;
                d = 2.147483647E9;
                object = new int[n3][n6];
                break;
            }
            case 4: {
                d2 = -3.4028234663852886E38;
                d = 3.4028234663852886E38;
                object = new float[n3][n6];
                break;
            }
            case 5: {
                d2 = -1.7976931348623157E308;
                d = Double.MAX_VALUE;
                object = new double[n3][n6];
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube7"));
            }
        }
        if ((double)(n6 + n2) > d) {
            throw new RuntimeException(JaiI18N.getString("ColorCube4"));
        }
        int[] nArray3 = new int[n3];
        nArray3[0] = 1;
        int n7 = 1;
        while (n7 < n3) {
            nArray3[n7] = nArray3[n7 - 1] * nArray2[n7 - 1];
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            double d4;
            int n8 = nArray2[n7];
            double d5 = n8 == 1 ? 0.0 : (n == 4 || n == 5 ? 1.0 / (double)(n8 - 1) : (d - d2) / (double)(n8 - 1));
            if (nArray[n7] < 0) {
                d5 = -d5;
                d4 = d;
            } else {
                d4 = d2;
            }
            int n9 = nArray3[n7];
            switch (n) {
                case 0: {
                    Object object2 = object;
                    int n10 = 0;
                    while (n10 < n6) {
                        double d6 = d4;
                        int n11 = 0;
                        while (n11 < n8) {
                            int n12 = 0;
                            while (n12 < n9) {
                                object2[n7][n10] = (byte)((int)(d6 + 0.5) & 0xFF);
                                ++n10;
                                ++n12;
                            }
                            d6 += d5;
                            ++n11;
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sArray = object;
                    int n10 = 0;
                    while (n10 < n6) {
                        double d7 = d4;
                        int n13 = 0;
                        while (n13 < n8) {
                            int n14 = 0;
                            while (n14 < n9) {
                                sArray[n7][n10] = (short)(d7 + 0.5);
                                ++n10;
                                ++n14;
                            }
                            d7 += d5;
                            ++n13;
                        }
                    }
                    break;
                }
                case 3: {
                    int n15;
                    int[][] nArray4 = object;
                    int n10 = 0;
                    while (n10 < n6) {
                        double d8 = d4;
                        int n16 = 0;
                        while (n16 < n8) {
                            n15 = 0;
                            while (n15 < n9) {
                                nArray4[n7][n10] = (int)(d8 + 0.5);
                                ++n10;
                                ++n15;
                            }
                            d8 += d5;
                            ++n16;
                        }
                    }
                    break;
                }
                case 4: {
                    int n17;
                    int n15;
                    float[][] fArray = object;
                    int n10 = 0;
                    while (n10 < n6) {
                        double d9 = d4;
                        n15 = 0;
                        while (n15 < n8) {
                            n17 = 0;
                            while (n17 < n9) {
                                fArray[n7][n10] = (float)d9;
                                ++n10;
                                ++n17;
                            }
                            d9 += d5;
                            ++n15;
                        }
                    }
                    break;
                }
                case 5: {
                    int n17;
                    double[][] dArray = object;
                    int n10 = 0;
                    while (n10 < n6) {
                        double d10 = d4;
                        n17 = 0;
                        while (n17 < n8) {
                            int n18 = 0;
                            while (n18 < n9) {
                                dArray[n7][n10] = d10;
                                ++n10;
                                ++n18;
                            }
                            d10 += d5;
                            ++n17;
                        }
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("ColorCube5"));
                }
            }
            ++n7;
        }
        return object;
    }

    private static byte[][] createDataArrayByte(int n, int[] nArray) {
        return (byte[][])ColorCube.createDataArray(0, n, nArray);
    }

    private static short[][] createDataArrayShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(2, n, nArray);
    }

    private static short[][] createDataArrayUShort(int n, int[] nArray) {
        return (short[][])ColorCube.createDataArray(1, n, nArray);
    }

    private static int[][] createDataArrayInt(int n, int[] nArray) {
        return (int[][])ColorCube.createDataArray(3, n, nArray);
    }

    private static float[][] createDataArrayFloat(int n, int[] nArray) {
        return (float[][])ColorCube.createDataArray(4, n, nArray);
    }

    private static double[][] createDataArrayDouble(int n, int[] nArray) {
        return (double[][])ColorCube.createDataArray(5, n, nArray);
    }

    protected ColorCube(byte[][] byArray, int n) {
        super(byArray, n);
    }

    protected ColorCube(short[][] sArray, int n, boolean bl) {
        super(sArray, n, bl);
    }

    protected ColorCube(int[][] nArray, int n) {
        super(nArray, n);
    }

    protected ColorCube(float[][] fArray, int n) {
        super(fArray, n);
    }

    protected ColorCube(double[][] dArray, int n) {
        super(dArray, n);
    }

    private void initFields(int n, int[] nArray) {
        this.dimension = nArray;
        this.multipliers = new int[nArray.length];
        this.dimsLessOne = new int[nArray.length];
        this.multipliers[0] = 1;
        int n2 = 1;
        while (n2 < this.multipliers.length) {
            this.multipliers[n2] = this.multipliers[n2 - 1] * Math.abs(nArray[n2 - 1]);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.multipliers.length) {
            if (nArray[n2] < 0) {
                this.multipliers[n2] = -this.multipliers[n2];
            }
            this.dimsLessOne[n2] = Math.abs(nArray[n2]) - 1;
            ++n2;
        }
        this.adjustedOffset = n;
        n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > 1 && this.multipliers[n2] < 0) {
                this.adjustedOffset += Math.abs(this.multipliers[n2]) * this.dimsLessOne[n2];
            }
            ++n2;
        }
        this.dataType = this.getDataType();
        this.numBands = this.getNumBands();
    }

    public int[] getDimension() {
        return this.dimension;
    }

    public int[] getDimsLessOne() {
        return this.dimsLessOne;
    }

    public int[] getMultipliers() {
        return this.multipliers;
    }

    public int getAdjustedOffset() {
        return this.adjustedOffset;
    }

    @Override
    public int findNearestEntry(float[] fArray) {
        int n = -1;
        n = this.adjustedOffset;
        switch (this.dataType) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numBands) {
                    int n3 = (int)(fArray[n2] * (float)this.dimsLessOne[n2]);
                    if ((n3 & 0xFF) > 127) {
                        n3 += 256;
                    }
                    n += (n3 >> 8) * this.multipliers[n2];
                    ++n2;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numBands) {
                    int n5 = (int)(fArray[n4] - -32768.0f) * this.dimsLessOne[n4];
                    if ((n5 & 0xFFFF) > Short.MAX_VALUE) {
                        n5 += 65536;
                    }
                    n += (n5 >> 16) * this.multipliers[n4];
                    ++n4;
                }
                break;
            }
            case 1: {
                int n6 = 0;
                while (n6 < this.numBands) {
                    int n7 = (int)(fArray[n6] * (float)this.dimsLessOne[n6]);
                    if ((n7 & 0xFFFF) > Short.MAX_VALUE) {
                        n7 += 65536;
                    }
                    n += (n7 >> 16) * this.multipliers[n6];
                    ++n6;
                }
                break;
            }
            case 3: {
                int n8 = 0;
                while (n8 < this.numBands) {
                    long l = (long)((fArray[n8] - -2.1474836E9f) * (float)this.dimsLessOne[n8]);
                    if (l > Integer.MAX_VALUE) {
                        l += 0L;
                    }
                    n += (int)(l >> 32) * this.multipliers[n8];
                    ++n8;
                }
                break;
            }
            case 4: {
                int n9 = 0;
                while (n9 < this.numBands) {
                    float f = fArray[n9] * (float)this.dimsLessOne[n9];
                    int n10 = (int)f;
                    if (f - (float)n10 >= 0.5f) {
                        ++n10;
                    }
                    n += n10 * this.multipliers[n9];
                    ++n9;
                }
                break;
            }
            case 5: {
                int n11 = 0;
                while (n11 < this.numBands) {
                    double d = fArray[n11] * (float)this.dimsLessOne[n11];
                    int n12 = (int)d;
                    if (d - (double)n12 >= 0.5) {
                        ++n12;
                    }
                    n += n12 * this.multipliers[n11];
                    ++n11;
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorCube6"));
            }
        }
        return n;
    }
}

