/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.xml;

import com.twelvemonkeys.lang.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XMLSerializer {
    private final OutputStream mOutput;
    private final Charset mEncoding;
    private final SerializationContext mContext;

    public XMLSerializer(OutputStream outputStream, String string) {
        this.mOutput = outputStream;
        this.mEncoding = Charset.forName(string);
        this.mContext = new SerializationContext();
    }

    public final void setIndentation(String string) {
        this.mContext.indent = string != null ? string : "  ";
    }

    public final void setStripComments(boolean bl) {
        this.mContext.stripComments = bl;
    }

    public void serialize(Document document) {
        this.serialize(document, true);
    }

    public void serialize(Node node, boolean bl) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(this.mOutput, this.mEncoding));
        try {
            if (bl) {
                this.writeXMLDeclaration(printWriter);
            }
            this.writeXML(printWriter, node, this.mContext.copy());
        }
        finally {
            printWriter.flush();
        }
    }

    private void writeXMLDeclaration(PrintWriter printWriter) {
        printWriter.print("<?xml version=\"1.0\" encoding=\"");
        printWriter.print(this.mEncoding.name());
        printWriter.println("\"?>");
    }

    private void writeXML(PrintWriter printWriter, Node node, SerializationContext serializationContext) {
        this.writeNodeRecursive(printWriter, node, serializationContext);
    }

    private void writeNodeRecursive(PrintWriter printWriter, Node node, SerializationContext serializationContext) {
        if (node.getNodeType() != 3) {
            XMLSerializer.indentToLevel(printWriter, serializationContext);
        }
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                this.writeDocument(printWriter, node, serializationContext);
                break;
            }
            case 10: {
                this.writeDoctype(printWriter, (DocumentType)node);
                break;
            }
            case 1: {
                boolean bl = serializationContext.preserveSpace;
                XMLSerializer.updatePreserveSpace(node, serializationContext);
                this.writeElement(printWriter, (Element)node, serializationContext);
                serializationContext.preserveSpace = bl;
                break;
            }
            case 4: {
                this.writeCData(printWriter, node);
                break;
            }
            case 3: {
                this.writeText(printWriter, node, serializationContext);
                break;
            }
            case 8: {
                this.writeComment(printWriter, node, serializationContext);
                break;
            }
            case 7: {
                this.writeProcessingInstruction(printWriter, (ProcessingInstruction)node);
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Malformed input Document: Attribute nodes should only occur inside Element nodes");
            }
            default: {
                throw new InternalError("Lazy programmer never implemented serialization of " + node.getClass());
            }
        }
    }

    private void writeProcessingInstruction(PrintWriter printWriter, ProcessingInstruction processingInstruction) {
        printWriter.print("\n<?");
        printWriter.print(processingInstruction.getTarget());
        String string = processingInstruction.getData();
        if (string != null) {
            printWriter.print(" ");
            printWriter.print(string);
        }
        printWriter.println("?>");
    }

    private void writeText(PrintWriter printWriter, Node node, SerializationContext serializationContext) {
        String string = node.getNodeValue();
        if (serializationContext.preserveSpace) {
            printWriter.print(XMLSerializer.maybeEscapeElementValue(string));
        } else if (!StringUtil.isEmpty(string)) {
            String string2 = XMLSerializer.maybeEscapeElementValue(string.trim());
            XMLSerializer.indentToLevel(printWriter, serializationContext);
            printWriter.println(string2);
        }
    }

    private void writeCData(PrintWriter printWriter, Node node) {
        printWriter.print("<![CDATA[");
        printWriter.print(XMLSerializer.validateCDataValue(node.getNodeValue()));
        printWriter.println("]]>");
    }

    private static void updatePreserveSpace(Node node, SerializationContext serializationContext) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("xml:space")) != null) {
            if ("preserve".equals(node2.getNodeValue())) {
                serializationContext.preserveSpace = true;
            } else if ("default".equals(node2.getNodeValue())) {
                serializationContext.preserveSpace = false;
            }
        }
    }

    private static void indentToLevel(PrintWriter printWriter, SerializationContext serializationContext) {
        int n = 0;
        while (n < serializationContext.level) {
            printWriter.print(serializationContext.indent);
            ++n;
        }
    }

    private void writeComment(PrintWriter printWriter, Node node, SerializationContext serializationContext) {
        if (serializationContext.stripComments) {
            return;
        }
        String string = node.getNodeValue();
        XMLSerializer.validateCommentValue(string);
        if (string.startsWith(" ")) {
            printWriter.print("<!--");
        } else {
            printWriter.print("<!-- ");
        }
        printWriter.print(string);
        if (string.endsWith(" ")) {
            printWriter.println("-->");
        } else {
            printWriter.println(" -->");
        }
    }

    static String maybeEscapeElementValue(String string) {
        int n;
        int n2 = XMLSerializer.needsEscapeElement(string);
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n2));
        stringBuilder.ensureCapacity(string.length() + 30);
        int n3 = n = n2;
        while (n3 < string.length()) {
            switch (string.charAt(n3)) {
                case '&': {
                    n = XMLSerializer.appendAndEscape(string, n, n3, stringBuilder, "&amp;");
                    break;
                }
                case '<': {
                    n = XMLSerializer.appendAndEscape(string, n, n3, stringBuilder, "&lt;");
                    break;
                }
                case '>': {
                    n = XMLSerializer.appendAndEscape(string, n, n3, stringBuilder, "&gt;");
                    break;
                }
            }
            ++n3;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private static int appendAndEscape(String string, int n, int n2, StringBuilder stringBuilder, String string2) {
        stringBuilder.append(string.substring(n, n2));
        stringBuilder.append(string2);
        return n2 + 1;
    }

    private static int needsEscapeElement(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '&': 
                case '<': 
                case '>': {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private static String maybeEscapeAttributeValue(String string) {
        int n;
        int n2 = XMLSerializer.needsEscapeAttribute(string);
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n2));
        stringBuilder.ensureCapacity(string.length() + 16);
        int n3 = n = n2;
        while (n3 < string.length()) {
            switch (string.charAt(n3)) {
                case '&': {
                    n = XMLSerializer.appendAndEscape(string, n, n3, stringBuilder, "&amp;");
                    break;
                }
                case '\"': {
                    n = XMLSerializer.appendAndEscape(string, n, n3, stringBuilder, "&quot;");
                    break;
                }
            }
            ++n3;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private static int needsEscapeAttribute(String string) {
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\"': 
                case '&': {
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    private static String validateCDataValue(String string) {
        if (string.indexOf("]]>") >= 0) {
            throw new IllegalArgumentException("Malformed input document: CDATA block may not contain the string ']]>'");
        }
        return string;
    }

    private static String validateCommentValue(String string) {
        if (string.indexOf("--") >= 0) {
            throw new IllegalArgumentException("Malformed input document: Comment may not contain the string '--'");
        }
        return string;
    }

    private void writeDocument(PrintWriter printWriter, Node node, SerializationContext serializationContext) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                this.writeNodeRecursive(printWriter, nodeList.item(n), serializationContext);
                ++n;
            }
        }
    }

    private void writeElement(PrintWriter printWriter, Element element, SerializationContext serializationContext) {
        int n;
        Object object;
        printWriter.print("<");
        printWriter.print(element.getTagName());
        String string = element.getNamespaceURI();
        if (string != null && !string.equals(serializationContext.defaultNamespace)) {
            object = element.getPrefix();
            if (object == null) {
                serializationContext.defaultNamespace = string;
                printWriter.print(" xmlns");
            } else {
                printWriter.print(" xmlns:");
                printWriter.print((String)object);
            }
            printWriter.print("=\"");
            printWriter.print(string);
            printWriter.print("\"");
        }
        if (element.hasAttributes()) {
            object = element.getAttributes();
            n = 0;
            while (n < object.getLength()) {
                Attr attr = (Attr)object.item(n);
                String string2 = attr.getName();
                if (!string2.startsWith("xmlns") || string2.length() != 5 && string2.charAt(5) != ':') {
                    printWriter.print(" ");
                    printWriter.print(string2);
                    printWriter.print("=\"");
                    printWriter.print(XMLSerializer.maybeEscapeAttributeValue(attr.getValue()));
                    printWriter.print("\"");
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            printWriter.print(">");
            if (!serializationContext.preserveSpace) {
                printWriter.println();
            }
            object = element.getChildNodes();
            n = 0;
            while (n < object.getLength()) {
                this.writeNodeRecursive(printWriter, object.item(n), serializationContext.push());
                ++n;
            }
            if (!serializationContext.preserveSpace) {
                XMLSerializer.indentToLevel(printWriter, serializationContext);
            }
            printWriter.print("</");
            printWriter.print(element.getTagName());
            printWriter.println(">");
        } else {
            printWriter.println("/>");
        }
    }

    private void writeDoctype(PrintWriter printWriter, DocumentType documentType) {
        if (documentType != null) {
            String string;
            String string2;
            printWriter.print("<!DOCTYPE ");
            printWriter.print(documentType.getName());
            String string3 = documentType.getPublicId();
            if (!StringUtil.isEmpty(string3)) {
                printWriter.print(" PUBLIC ");
                printWriter.print(string3);
            }
            if (!StringUtil.isEmpty(string2 = documentType.getSystemId())) {
                if (StringUtil.isEmpty(string3)) {
                    printWriter.print(" SYSTEM \"");
                } else {
                    printWriter.print(" \"");
                }
                printWriter.print(string2);
                printWriter.print("\"");
            }
            if (!StringUtil.isEmpty(string = documentType.getInternalSubset())) {
                printWriter.print(" [ ");
                printWriter.print(string);
                printWriter.print(" ]");
            }
            printWriter.println(">");
        }
    }

    static class SerializationContext
    implements Cloneable {
        String indent = "  ";
        int level = 0;
        boolean preserveSpace = false;
        boolean stripComments = false;
        String defaultNamespace;

        SerializationContext() {
        }

        public SerializationContext copy() {
            try {
                return (SerializationContext)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error(cloneNotSupportedException);
            }
        }

        public SerializationContext push() {
            SerializationContext serializationContext = this.copy();
            ++serializationContext.level;
            return serializationContext;
        }
    }
}

