/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilterIterator<E>
implements Iterator<E> {
    protected final Filter<E> mFilter;
    protected final Iterator<E> mIterator;
    private E mNext = null;
    private E mCurrent = null;

    public FilterIterator(Iterator<E> iterator, Filter<E> filter) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.mIterator = iterator;
        this.mFilter = filter;
    }

    @Override
    public boolean hasNext() {
        while (this.mNext == null && this.mIterator.hasNext()) {
            E e = this.mIterator.next();
            if (!this.mFilter.accept(e)) continue;
            this.mNext = e;
            break;
        }
        return this.mNext != null;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            this.mCurrent = this.mNext;
            this.mNext = null;
            return this.mCurrent;
        }
        throw new NoSuchElementException("Iteration has no more elements.");
    }

    @Override
    public void remove() {
        if (this.mCurrent == null) {
            throw new IllegalStateException("Iteration has no current element.");
        }
        this.mIterator.remove();
    }

    public static interface Filter<E> {
        public boolean accept(E var1);
    }
}

