/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;

public final class StringUtil {
    private StringUtil() {
    }

    public static String decode(byte[] byArray, int n, int n2, String string) {
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharsetException(string);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        if (string2.length() == 0) {
            return string;
        }
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = string.indexOf(string2, n2)) != -1) {
            stringBuilder.append(string.substring(n2, n));
            stringBuilder.append(string3);
            n2 = n + string2.length();
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String capitalize(String string, int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index not allowed: " + n);
        }
        if (string == null || string.length() <= n) {
            return string;
        }
        if (Character.isUpperCase(string.charAt(n))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n] = Character.toUpperCase(cArray[n]);
        return new String(cArray);
    }

    public static String toCSVString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        if (string == null) {
            throw new IllegalArgumentException("delimiter == null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String lispToCamel(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '-') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.length() - 1);
                }
                if (n != 0 || bl) {
                    stringBuilder.append(Character.toUpperCase(string.charAt(n)));
                    ++n;
                }
                stringBuilder.append(string.substring(n, n2).toLowerCase());
                n = n2 + 1;
            }
            ++n2;
        }
        if (stringBuilder != null) {
            stringBuilder.append(Character.toUpperCase(string.charAt(n)));
            stringBuilder.append(string.substring(n + 1).toLowerCase());
            return stringBuilder.toString();
        }
        if (bl && !Character.isUpperCase(string.charAt(0))) {
            return StringUtil.capitalize(string, 0);
        }
        if (!bl && Character.isUpperCase(string.charAt(0))) {
            return String.valueOf(Character.toLowerCase(string.charAt(0))) + string.substring(1);
        }
        return string;
    }
}

