/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.DecodeException;
import com.twelvemonkeys.io.enc.Decoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class PackBitsDecoder
implements Decoder {
    private final boolean mDisableNoop;
    private int mLeftOfRun;
    private boolean mSplitRun;
    private boolean mEOF;

    public PackBitsDecoder() {
        this(false);
    }

    public PackBitsDecoder(boolean bl) {
        this.mDisableNoop = bl;
    }

    @Override
    public int decode(InputStream inputStream, byte[] byArray) throws IOException {
        if (this.mEOF) {
            return -1;
        }
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3;
            int n4;
            if (this.mSplitRun) {
                n4 = this.mLeftOfRun;
                this.mSplitRun = false;
            } else {
                n3 = inputStream.read();
                if (n3 < 0) {
                    this.mEOF = true;
                    break;
                }
                n4 = (byte)n3;
            }
            if (n4 >= 0 && n4 + 1 + n > n2) {
                this.mLeftOfRun = n4;
                this.mSplitRun = true;
                break;
            }
            if (n4 < 0 && -n4 + 1 + n > n2) {
                this.mLeftOfRun = n4;
                this.mSplitRun = true;
                break;
            }
            try {
                if (n4 >= 0) {
                    PackBitsDecoder.readFully(inputStream, byArray, n, n4 + 1);
                    n += n4 + 1;
                    continue;
                }
                if (!this.mDisableNoop && n4 == -128) continue;
                n3 = PackBitsDecoder.readByte(inputStream);
                int n5 = -n4 + 1;
                while (n5 > 0) {
                    byArray[n++] = n3;
                    --n5;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DecodeException("Error in PackBits decompression, data seems corrupt", indexOutOfBoundsException);
            }
        }
        return n;
    }

    private static byte readByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException("Unexpected end of PackBits stream");
        }
        return (byte)n;
    }

    private static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException("Unexpected end of PackBits stream");
            }
            n3 += n4;
        }
    }
}

