/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Encoder;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class EncoderStream
extends FilterOutputStream {
    protected final Encoder mEncoder;
    private final boolean mFlushOnWrite;
    protected int mBufferPos;
    protected final byte[] mBuffer;

    public EncoderStream(OutputStream outputStream, Encoder encoder) {
        this(outputStream, encoder, false);
    }

    public EncoderStream(OutputStream outputStream, Encoder encoder, boolean bl) {
        super(outputStream);
        this.mEncoder = encoder;
        this.mFlushOnWrite = bl;
        this.mBuffer = new byte[1024];
        this.mBufferPos = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.encodeBuffer();
        super.flush();
    }

    private void encodeBuffer() throws IOException {
        if (this.mBufferPos != 0) {
            this.mEncoder.encode(this.out, this.mBuffer, 0, this.mBufferPos);
            this.mBufferPos = 0;
        }
    }

    @Override
    public final void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.mFlushOnWrite && this.mBufferPos + n2 < this.mBuffer.length) {
            System.arraycopy(byArray, n, this.mBuffer, this.mBufferPos, n2);
            this.mBufferPos += n2;
        } else {
            if (this.mBufferPos != 0) {
                this.encodeBuffer();
            }
            this.mEncoder.encode(this.out, byArray, n, n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.mBufferPos >= this.mBuffer.length - 1) {
            this.encodeBuffer();
        }
        this.mBuffer[this.mBufferPos++] = (byte)n;
    }
}

