/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DecoderStream
extends FilterInputStream {
    protected int mBufferPos;
    protected int mBufferLimit;
    protected final byte[] mBuffer;
    protected final Decoder mDecoder;

    public DecoderStream(InputStream inputStream, Decoder decoder) {
        this(inputStream, decoder, 1024);
    }

    public DecoderStream(InputStream inputStream, Decoder decoder, int n) {
        super(inputStream);
        this.mDecoder = decoder;
        this.mBuffer = new byte[n];
        this.mBufferPos = 0;
        this.mBufferLimit = 0;
    }

    @Override
    public int available() throws IOException {
        return this.mBufferLimit - this.mBufferPos + super.available();
    }

    @Override
    public int read() throws IOException {
        if (this.mBufferPos == this.mBufferLimit) {
            this.mBufferLimit = this.fill();
        }
        if (this.mBufferLimit < 0) {
            return -1;
        }
        return this.mBuffer[this.mBufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("bytes.length=" + byArray.length + " offset=" + n + " length=" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.mBufferLimit - this.mBufferPos < 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = n;
        while (n2 > n3) {
            int n5 = this.mBufferLimit - this.mBufferPos;
            if (n5 <= 0) {
                this.mBufferLimit = this.fill();
                if (this.mBufferLimit < 0) break;
            }
            int n6 = Math.min(n2 - n3, n5);
            System.arraycopy(this.mBuffer, this.mBufferPos, byArray, n4, n6);
            this.mBufferPos += n6;
            n4 += n6;
            n3 += n6;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        if (this.mBufferLimit - this.mBufferPos < 0) {
            return 0L;
        }
        long l2 = 0L;
        while (l2 < l) {
            int n = this.mBufferLimit - this.mBufferPos;
            if (n == 0) {
                this.mBufferLimit = this.fill();
                if (this.mBufferLimit < 0) break;
            }
            int n2 = (int)Math.min(l - l2, (long)n);
            this.mBufferPos += n2;
            l2 += (long)n2;
        }
        return l2;
    }

    protected int fill() throws IOException {
        int n = this.mDecoder.decode(this.in, this.mBuffer);
        if (n > this.mBuffer.length) {
            throw new AssertionError((Object)String.format("Decode beyond buffer (%d): %d (using %s decoder)", this.mBuffer.length, n, this.mDecoder.getClass().getName()));
        }
        this.mBufferPos = 0;
        if (n == 0) {
            return -1;
        }
        return n;
    }
}

