/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int mWritten;

    public LittleEndianDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        if (outputStream == null) {
            throw new IllegalArgumentException("stream == null");
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.mWritten;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.mWritten += n2;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.out.write(n);
        ++this.mWritten;
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.mWritten += 2;
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 24 & 0xFF);
        this.mWritten += 4;
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.mWritten += 8;
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.out.write((byte)string.charAt(n2));
            ++n2;
        }
        this.mWritten += n;
    }

    @Override
    public void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
            ++n2;
        }
        this.mWritten += n * 2;
    }

    @Override
    public void writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.out.write(n2 >>> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
        n3 = 0;
        while (n3 < n) {
            c = string.charAt(n3);
            if (c >= '\u0001' && c <= '\u007f') {
                this.out.write(c);
            } else if (c > '\u07ff') {
                this.out.write(0xE0 | c >> 12 & 0xF);
                this.out.write(0x80 | c >> 6 & 0x3F);
                this.out.write(0x80 | c & 0x3F);
                this.mWritten += 2;
            } else {
                this.out.write(0xC0 | c >> 6 & 0x1F);
                this.out.write(0x80 | c & 0x3F);
                ++this.mWritten;
            }
            ++n3;
        }
        this.mWritten += n + 2;
    }

    public int size() {
        return this.mWritten;
    }
}

