/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;

public class IndexedImageTypeSpecifier
extends ImageTypeSpecifier {
    IndexedImageTypeSpecifier(IndexColorModel indexColorModel) {
        super(indexColorModel, indexColorModel.createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel indexColorModel) {
        return new IndexedImageTypeSpecifier(indexColorModel);
    }

    @Override
    public final BufferedImage createBufferedImage(int n, int n2) {
        try {
            WritableRaster writableRaster = this.colorModel.createCompatibleWritableRaster(n, n2);
            return new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException("Array size > Integer.MAX_VALUE!");
        }
    }
}

