/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

class IIOInputStreamAdapter
extends InputStream {
    private ImageInputStream mInput;
    private final boolean mHasLength;
    private long mLeft;
    private long mMarkPosition;

    public IIOInputStreamAdapter(ImageInputStream imageInputStream) {
        this(imageInputStream, -1L, false);
    }

    public IIOInputStreamAdapter(ImageInputStream imageInputStream, long l) {
        this(imageInputStream, l, true);
    }

    private IIOInputStreamAdapter(ImageInputStream imageInputStream, long l, boolean bl) {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("stream == null");
        }
        if (bl && l < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        this.mInput = imageInputStream;
        this.mHasLength = bl;
        this.mLeft = l;
    }

    @Override
    public void close() throws IOException {
        if (this.mHasLength) {
            this.mInput.seek(this.mInput.getStreamPosition() + this.mLeft);
        }
        this.mLeft = 0L;
        this.mInput = null;
    }

    @Override
    public int available() throws IOException {
        if (this.mHasLength) {
            return this.mLeft > 0L ? (int)Math.min(Integer.MAX_VALUE, this.mLeft) : 0;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        try {
            this.mMarkPosition = this.mInput.getStreamPosition();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not read stream position: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public void reset() throws IOException {
        long l = this.mInput.getStreamPosition() - this.mMarkPosition;
        this.mInput.seek(this.mMarkPosition);
        this.mLeft += l;
    }

    @Override
    public int read() throws IOException {
        if (this.mHasLength && this.mLeft-- <= 0L) {
            this.mLeft = 0L;
            return -1;
        }
        return this.mInput.read();
    }

    @Override
    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mHasLength && this.mLeft <= 0L) {
            return -1;
        }
        int n3 = this.mInput.read(byArray, n, (int)this.findMaxLen(n2));
        if (this.mHasLength) {
            this.mLeft = n3 < 0 ? 0L : this.mLeft - (long)n3;
        }
        return n3;
    }

    private long findMaxLen(long l) {
        if (this.mHasLength && this.mLeft < l) {
            return Math.max(this.mLeft, 0L);
        }
        return Math.max(l, 0L);
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.mInput.skipBytes(this.findMaxLen(l));
        this.mLeft -= l2;
        return l2;
    }
}

