/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream mStream;
    private final long mStartPos;
    private final long mLength;
    private final boolean patchLastByte;

    public SubImageInputStream(ImageInputStream imageInputStream, long l, boolean bl) throws IOException {
        Validate.notNull(imageInputStream, "stream");
        if (l < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        this.mStream = imageInputStream;
        this.mStartPos = imageInputStream.getStreamPosition();
        this.mLength = l;
        this.patchLastByte = bl;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.mLength) {
            return -1;
        }
        int n = this.mStream.read();
        if (n >= 0) {
            ++this.streamPos;
            if (this.patchLastByte && this.streamPos == this.mLength && n == 0) {
                return -1;
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.streamPos >= this.mLength) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.mLength - this.streamPos);
        int n4 = this.mStream.read(byArray, n, n3);
        if (n4 >= 0) {
            this.streamPos += (long)n4;
            if (this.patchLastByte && this.streamPos == this.mLength && byArray[n + n4 - 1] == 0) {
                return n4 - 1;
            }
        }
        return n4;
    }

    @Override
    public long length() {
        try {
            long l = this.mStream.length();
            return l < 0L ? -1L : Math.min(l - this.mStartPos, this.mLength);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void seek(long l) throws IOException {
        if (l < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("pos < flushedPosition");
        }
        this.mStream.seek(this.mStartPos + l);
        this.streamPos = l;
    }

    @Override
    protected void finalize() throws Throwable {
    }
}

