/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class BufferedImageInputStream
extends ImageInputStreamImpl
implements ImageInputStream {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private ImageInputStream mStream;
    private byte[] mBuffer;
    private long mBufferStart = 0L;
    private int mBufferPos = 0;
    private int mBufferLength = 0;

    public BufferedImageInputStream(ImageInputStream imageInputStream) throws IOException {
        this(imageInputStream, 8192);
    }

    private BufferedImageInputStream(ImageInputStream imageInputStream, int n) throws IOException {
        Validate.notNull(imageInputStream, "stream");
        this.mStream = imageInputStream;
        this.streamPos = imageInputStream.getStreamPosition();
        this.mBuffer = new byte[n];
    }

    private void fillBuffer() throws IOException {
        this.mBufferStart = this.streamPos;
        this.mBufferLength = this.mStream.read(this.mBuffer, 0, this.mBuffer.length);
        this.mBufferPos = 0;
    }

    private boolean isBufferValid() throws IOException {
        return this.mBufferPos < this.mBufferLength && this.mBufferStart == this.mStream.getStreamPosition() - (long)this.mBufferLength;
    }

    @Override
    public int read() throws IOException {
        if (!this.isBufferValid()) {
            this.fillBuffer();
        }
        if (this.mBufferLength <= 0) {
            return -1;
        }
        this.bitOffset = 0;
        ++this.streamPos;
        return this.mBuffer[this.mBufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.bitOffset = 0;
        if (!this.isBufferValid()) {
            if (n2 >= this.mBuffer.length) {
                return this.readDirect(byArray, n, n2);
            }
            this.fillBuffer();
        }
        return this.readBuffered(byArray, n, n2);
    }

    private int readDirect(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.mStream.read(byArray, n, Math.min(this.mBuffer.length, n2));
        if (n3 > 0) {
            this.streamPos += (long)n3;
        }
        this.mBufferStart = this.mStream.getStreamPosition();
        this.mBufferLength = 0;
        return n3;
    }

    private int readBuffered(byte[] byArray, int n, int n2) {
        if (this.mBufferLength <= 0) {
            return -1;
        }
        int n3 = Math.min(this.mBufferLength - this.mBufferPos, n2);
        if (n3 > 0) {
            System.arraycopy(this.mBuffer, this.mBufferPos, byArray, n, n3);
            this.mBufferPos += n3;
        }
        this.streamPos += (long)n3;
        return n3;
    }

    @Override
    public void seek(long l) throws IOException {
        this.mStream.seek(l);
        this.mBufferLength = 0;
        this.streamPos = this.mStream.getStreamPosition();
    }

    @Override
    public void flushBefore(long l) throws IOException {
        this.mStream.flushBefore(l);
    }

    @Override
    public long getFlushedPosition() {
        return this.mStream.getFlushedPosition();
    }

    @Override
    public boolean isCached() {
        return this.mStream.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.mStream.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.mStream.isCachedFile();
    }

    @Override
    public void close() throws IOException {
        if (this.mStream != null) {
            this.mStream = null;
            this.mBuffer = null;
        }
        super.close();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public long length() {
        try {
            return this.mStream.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

