/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.spi;

import com.twelvemonkeys.lang.Validate;

public class ProviderInfo {
    private final String mTitle;
    private final String mVendorName;
    private final String mVersion;

    public ProviderInfo(Package package_) {
        Validate.notNull(package_, "package");
        String string = package_.getImplementationTitle();
        this.mTitle = string != null ? string : package_.getName();
        String string2 = package_.getImplementationVendor();
        this.mVendorName = string2 != null ? string2 : ProviderInfo.fakeVendor(package_);
        String string3 = package_.getImplementationVersion();
        this.mVersion = string3 != null ? string3 : this.fakeVersion(package_);
    }

    private static String fakeVendor(Package package_) {
        String string = package_.getName();
        return string.startsWith("com.twelvemonkeys") ? "TwelveMonkeys" : string;
    }

    private String fakeVersion(Package package_) {
        String string = package_.getName();
        return string.startsWith("com.twelvemonkeys") ? "DEV" : "Unspecified";
    }

    final String getImplementationTitle() {
        return this.mTitle;
    }

    public final String getVendorName() {
        return this.mVendorName;
    }

    public final String getVersion() {
        return this.mVersion;
    }

    public String toString() {
        return String.valueOf(this.mTitle) + ", " + this.mVersion + " by " + this.mVendorName;
    }
}

