/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.xmp.XMPReader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.lang.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.imageio.stream.ImageInputStream;

final class PSDXMPData
extends PSDImageResource {
    protected byte[] mData;
    Directory mDirectory;

    PSDXMPData(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        this.mData = new byte[(int)this.mSize];
        this.mDirectory = new XMPReader().read(imageInputStream);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        int n = Math.min(256, this.mData.length);
        String string = StringUtil.decode(this.mData, 0, n, "UTF-8").replace('\n', ' ').replaceAll("\\s+", " ");
        stringBuilder.append(", data: \"").append(string);
        if (n < this.mData.length) {
            stringBuilder.append("...");
        }
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }

    public Reader getData() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.mData), Charset.forName("UTF-8"));
    }
}

