/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

final class PSDVersionInfo
extends PSDImageResource {
    int mVersion;
    boolean mHasRealMergedData;
    String mWriter;
    String mReader;
    int mFileVersion;

    PSDVersionInfo(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        this.mVersion = imageInputStream.readInt();
        this.mHasRealMergedData = imageInputStream.readBoolean();
        this.mWriter = PSDUtil.readUnicodeString(imageInputStream);
        this.mReader = PSDUtil.readUnicodeString(imageInputStream);
        this.mFileVersion = imageInputStream.readInt();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", version: ").append(this.mVersion);
        stringBuilder.append(", hasRealMergedData: ").append(this.mHasRealMergedData);
        stringBuilder.append(", writer: ").append(this.mWriter);
        stringBuilder.append(", reader: ").append(this.mReader);
        stringBuilder.append(", file version: ").append(this.mFileVersion);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

