/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.PackBitsDecoder;
import com.twelvemonkeys.lang.StringUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.ImageInputStream;

final class PSDUtil {
    PSDUtil() {
    }

    static String intToStr(int n) {
        return new String(new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)});
    }

    static String readPascalString(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return StringUtil.decode(byArray, 0, byArray.length, "ASCII");
    }

    static String readUnicodeString(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n * 2];
        dataInput.readFully(byArray);
        return StringUtil.decode(byArray, 0, byArray.length, "UTF-16");
    }

    static DataInputStream createPackBitsStream(ImageInputStream imageInputStream, long l) {
        return new DataInputStream(new DecoderStream(IIOUtil.createStreamAdapter(imageInputStream, l), new PackBitsDecoder()));
    }

    static DataInputStream createZipStream(ImageInputStream imageInputStream, long l) {
        return new DataInputStream(new ZipInputStream(IIOUtil.createStreamAdapter(imageInputStream, l)));
    }

    static DataInputStream createZipPredictorStream(ImageInputStream imageInputStream, long l) {
        throw new UnsupportedOperationException("Method createZipPredictonStream not implemented");
    }

    public static float fixedPointToFloat(int n) {
        return (float)((n & 0xFFFF0000) >> 16) + (float)(n & 0xFFFF) / 65535.0f;
    }
}

