/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

class PSDThumbnail
extends PSDImageResource {
    private BufferedImage mThumbnail;
    private int mWidth;
    private int mHeight;

    public PSDThumbnail(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        switch (n) {
            case 0: {
                throw new IIOException("RAW RGB format thumbnail not supported yet");
            }
            case 1: {
                break;
            }
            default: {
                throw new IIOException(String.format("Unsupported thumbnail format (%s) in PSD document", n));
            }
        }
        this.mWidth = imageInputStream.readInt();
        this.mHeight = imageInputStream.readInt();
        imageInputStream.readInt();
        imageInputStream.readInt();
        int n2 = imageInputStream.readInt();
        if ((long)n2 != this.mSize - 28L) {
            throw new IIOException("Corrupt thumbnail in PSD document");
        }
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        if (n3 != 24) {
            // empty if block
        }
        this.mThumbnail = ImageIO.read(IIOUtil.createStreamAdapter(imageInputStream, n2));
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public final BufferedImage getThumbnail() {
        return this.mThumbnail;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", ").append(this.mThumbnail);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

