/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDResolutionInfo
extends PSDImageResource {
    float mHRes;
    short mHResUnit;
    short mWidthUnit;
    float mVRes;
    short mVResUnit;
    short mHeightUnit;

    PSDResolutionInfo(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        if (this.mSize != 16L) {
            throw new IIOException("Resolution info length expected to be 16: " + this.mSize);
        }
        this.mHRes = PSDUtil.fixedPointToFloat(imageInputStream.readInt());
        this.mHResUnit = imageInputStream.readShort();
        this.mWidthUnit = imageInputStream.readShort();
        this.mVRes = PSDUtil.fixedPointToFloat(imageInputStream.readInt());
        this.mVResUnit = imageInputStream.readShort();
        this.mHeightUnit = imageInputStream.readShort();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", hRes: ").append(this.mHRes);
        stringBuilder.append(" ");
        stringBuilder.append(this.resUnit(this.mHResUnit));
        stringBuilder.append(", width unit: ");
        stringBuilder.append(this.dimUnit(this.mWidthUnit));
        stringBuilder.append(", vRes: ").append(this.mVRes);
        stringBuilder.append(" ");
        stringBuilder.append(this.resUnit(this.mVResUnit));
        stringBuilder.append(", height unit: ");
        stringBuilder.append(this.dimUnit(this.mHeightUnit));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String resUnit(short s) {
        switch (s) {
            case 1: {
                return "pixels/inch";
            }
            case 2: {
                return "pixels/cm";
            }
        }
        return "unknown unit " + s;
    }

    private String dimUnit(short s) {
        switch (s) {
            case 1: {
                return "in";
            }
            case 2: {
                return "cm";
            }
            case 3: {
                return "pt";
            }
            case 4: {
                return "pica";
            }
            case 5: {
                return "column";
            }
        }
        return "unknown unit " + s;
    }
}

