/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.plugins.psd.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDAlphaChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDDisplayInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDGridAndGuideInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDIPTCData;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDPixelAspectRatio;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlags;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlagsInformation;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintScale;
import com.twelvemonkeys.imageio.plugins.psd.PSDResolutionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUnicodeAlphaNames;
import com.twelvemonkeys.imageio.plugins.psd.PSDVersionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDXMPData;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.util.FilterIterator;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public final class PSDMetadata
extends AbstractMetadata {
    static final String NATIVE_METADATA_FORMAT_NAME = "com_twelvemonkeys_imageio_psd_image_1.0";
    static final String NATIVE_METADATA_FORMAT_CLASS_NAME = "com.twelvemonkeys.imageio.plugins.psd.PSDMetadataFormat";
    PSDHeader mHeader;
    PSDColorData mColorData;
    int mCompression = -1;
    List<PSDImageResource> mImageResources;
    PSDGlobalLayerMask mGlobalLayerMask;
    List<PSDLayerInfo> mLayerInfo;
    static final String[] COLOR_MODES;
    static final String[] DISPLAY_INFO_CS;
    static final String[] DISPLAY_INFO_KINDS;
    static final String[] RESOLUTION_UNITS;
    static final String[] DIMENSION_UNITS;
    static final String[] JAVA_CS;
    static final String[] GUIDE_ORIENTATIONS;
    static final String[] PRINT_SCALE_STYLES;

    static {
        String[] stringArray = new String[10];
        stringArray[0] = "MONOCHROME";
        stringArray[1] = "GRAYSCALE";
        stringArray[2] = "INDEXED";
        stringArray[3] = "RGB";
        stringArray[4] = "CMYK";
        stringArray[7] = "MULTICHANNEL";
        stringArray[8] = "DUOTONE";
        stringArray[9] = "LAB";
        COLOR_MODES = stringArray;
        String[] stringArray2 = new String[14];
        stringArray2[0] = "RGB";
        stringArray2[1] = "HSB";
        stringArray2[2] = "CMYK";
        stringArray2[3] = "PANTONE";
        stringArray2[4] = "FOCOLTONE";
        stringArray2[5] = "TRUMATCH";
        stringArray2[6] = "TOYO";
        stringArray2[7] = "LAB";
        stringArray2[8] = "GRAYSCALE";
        stringArray2[10] = "HKS";
        stringArray2[11] = "DIC";
        stringArray2[13] = "ANPA";
        DISPLAY_INFO_CS = stringArray2;
        DISPLAY_INFO_KINDS = new String[]{"selected", "protected"};
        String[] stringArray3 = new String[3];
        stringArray3[1] = "pixels/inch";
        stringArray3[2] = "pixels/cm";
        RESOLUTION_UNITS = stringArray3;
        String[] stringArray4 = new String[6];
        stringArray4[1] = "in";
        stringArray4[2] = "cm";
        stringArray4[3] = "pt";
        stringArray4[4] = "picas";
        stringArray4[5] = "columns";
        DIMENSION_UNITS = stringArray4;
        JAVA_CS = new String[]{"XYZ", "Lab", "Yuv", "YCbCr", "Yxy", "RGB", "GRAY", "HSV", "HLS", "CMYK", "CMY", "2CLR", "3CLR", "4CLR", "5CLR", "6CLR", "7CLR", "8CLR", "9CLR", "ACLR", "BCLR", "CCLR", "DCLR", "ECLR", "FCLR"};
        GUIDE_ORIENTATIONS = new String[]{"vertical", "horizontal"};
        PRINT_SCALE_STYLES = new String[]{"centered", "scaleToFit", "userDefined"};
    }

    protected PSDMetadata() {
        super(true, NATIVE_METADATA_FORMAT_NAME, NATIVE_METADATA_FORMAT_CLASS_NAME, null, null);
    }

    @Override
    protected Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(NATIVE_METADATA_FORMAT_NAME);
        iIOMetadataNode.appendChild(this.createHeaderNode());
        if (this.mHeader.mMode == 2) {
            iIOMetadataNode.appendChild(this.createPaletteNode());
        }
        if (this.mImageResources != null && !this.mImageResources.isEmpty()) {
            iIOMetadataNode.appendChild(this.createImageResourcesNode());
        }
        return iIOMetadataNode;
    }

    private Node createHeaderNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Header");
        iIOMetadataNode.setAttribute("type", "PSD");
        iIOMetadataNode.setAttribute("version", "1");
        iIOMetadataNode.setAttribute("channels", Integer.toString(this.mHeader.mChannels));
        iIOMetadataNode.setAttribute("height", Integer.toString(this.mHeader.mHeight));
        iIOMetadataNode.setAttribute("width", Integer.toString(this.mHeader.mWidth));
        iIOMetadataNode.setAttribute("bits", Integer.toString(this.mHeader.mBits));
        iIOMetadataNode.setAttribute("mode", COLOR_MODES[this.mHeader.mMode]);
        return iIOMetadataNode;
    }

    private Node createImageResourcesNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("ImageResources");
        for (PSDImageResource pSDImageResource : this.mImageResources) {
            Object object;
            IIOMetadataNode iIOMetadataNode2;
            IIOMetadataNode iIOMetadataNode3;
            Object object3;
            if (pSDImageResource instanceof ICCProfile) {
                object3 = (ICCProfile)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("ICCProfile");
                iIOMetadataNode3.setAttribute("colorSpaceType", JAVA_CS[((ICCProfile)object3).getProfile().getColorSpaceType()]);
                iIOMetadataNode3.setUserObject(((ICCProfile)object3).getProfile());
            } else if (pSDImageResource instanceof PSDAlphaChannelInfo) {
                object3 = (PSDAlphaChannelInfo)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("AlphaChannelInfo");
                for (String string : ((PSDAlphaChannelInfo)object3).mNames) {
                    iIOMetadataNode2 = new IIOMetadataNode("Name");
                    iIOMetadataNode2.setAttribute("value", string);
                    iIOMetadataNode3.appendChild(iIOMetadataNode2);
                }
            } else if (pSDImageResource instanceof PSDDisplayInfo) {
                object3 = (PSDDisplayInfo)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("DisplayInfo");
                iIOMetadataNode3.setAttribute("colorSpace", DISPLAY_INFO_CS[((PSDDisplayInfo)object3).mColorSpace]);
                StringBuilder stringBuilder = new StringBuilder();
                object = ((PSDDisplayInfo)object3).mColors;
                int n = ((PSDDisplayInfo)object3).mColors.length;
                int n2 = 0;
                while (n2 < n) {
                    short s = object[n2];
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(Integer.toString(s));
                    ++n2;
                }
                iIOMetadataNode3.setAttribute("colors", stringBuilder.toString());
                iIOMetadataNode3.setAttribute("opacity", Integer.toString(((PSDDisplayInfo)object3).mOpacity));
                iIOMetadataNode3.setAttribute("kind", DISPLAY_INFO_KINDS[((PSDDisplayInfo)object3).mKind]);
            } else if (pSDImageResource instanceof PSDGridAndGuideInfo) {
                object3 = (PSDGridAndGuideInfo)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("GridAndGuideInfo");
                iIOMetadataNode3.setAttribute("version", String.valueOf(((PSDGridAndGuideInfo)object3).mVersion));
                iIOMetadataNode3.setAttribute("verticalGridCycle", String.valueOf(((PSDGridAndGuideInfo)object3).mGridCycleVertical));
                iIOMetadataNode3.setAttribute("horizontalGridCycle", String.valueOf(((PSDGridAndGuideInfo)object3).mGridCycleHorizontal));
                PSDGridAndGuideInfo.GuideResource[] guideResourceArray = ((PSDGridAndGuideInfo)object3).mGuides;
                int n = ((PSDGridAndGuideInfo)object3).mGuides.length;
                int n3 = 0;
                while (n3 < n) {
                    PSDGridAndGuideInfo.GuideResource guideResource = guideResourceArray[n3];
                    object = new IIOMetadataNode("Guide");
                    ((IIOMetadataNode)object).setAttribute("location", Integer.toString(guideResource.mLocation));
                    ((IIOMetadataNode)object).setAttribute("orientation", GUIDE_ORIENTATIONS[guideResource.mDirection]);
                    ++n3;
                }
            } else if (pSDImageResource instanceof PSDPixelAspectRatio) {
                object3 = (PSDPixelAspectRatio)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("PixelAspectRatio");
                iIOMetadataNode3.setAttribute("version", String.valueOf(((PSDPixelAspectRatio)object3).mVersion));
                iIOMetadataNode3.setAttribute("aspectRatio", String.valueOf(((PSDPixelAspectRatio)object3).mAspect));
            } else if (pSDImageResource instanceof PSDPrintFlags) {
                object3 = (PSDPrintFlags)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("PrintFlags");
                iIOMetadataNode3.setAttribute("labels", String.valueOf(((PSDPrintFlags)object3).mLabels));
                iIOMetadataNode3.setAttribute("cropMarks", String.valueOf(((PSDPrintFlags)object3).mCropMasks));
                iIOMetadataNode3.setAttribute("colorBars", String.valueOf(((PSDPrintFlags)object3).mColorBars));
                iIOMetadataNode3.setAttribute("registrationMarks", String.valueOf(((PSDPrintFlags)object3).mRegistrationMarks));
                iIOMetadataNode3.setAttribute("negative", String.valueOf(((PSDPrintFlags)object3).mNegative));
                iIOMetadataNode3.setAttribute("flip", String.valueOf(((PSDPrintFlags)object3).mFlip));
                iIOMetadataNode3.setAttribute("interpolate", String.valueOf(((PSDPrintFlags)object3).mInterpolate));
                iIOMetadataNode3.setAttribute("caption", String.valueOf(((PSDPrintFlags)object3).mCaption));
            } else if (pSDImageResource instanceof PSDPrintFlagsInformation) {
                object3 = (PSDPrintFlagsInformation)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("PrintFlagsInformation");
                iIOMetadataNode3.setAttribute("version", String.valueOf(((PSDPrintFlagsInformation)object3).mVersion));
                iIOMetadataNode3.setAttribute("cropMarks", String.valueOf(((PSDPrintFlagsInformation)object3).mCropMasks));
                iIOMetadataNode3.setAttribute("field", String.valueOf(((PSDPrintFlagsInformation)object3).mField));
                iIOMetadataNode3.setAttribute("bleedWidth", String.valueOf(((PSDPrintFlagsInformation)object3).mBleedWidth));
                iIOMetadataNode3.setAttribute("bleedScale", String.valueOf(((PSDPrintFlagsInformation)object3).mBleedScale));
            } else if (pSDImageResource instanceof PSDPrintScale) {
                object3 = (PSDPrintScale)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("PrintScale");
                iIOMetadataNode3.setAttribute("style", PRINT_SCALE_STYLES[((PSDPrintScale)object3).mStyle]);
                iIOMetadataNode3.setAttribute("xLocation", String.valueOf(((PSDPrintScale)object3).mXLocation));
                iIOMetadataNode3.setAttribute("yLocation", String.valueOf(((PSDPrintScale)object3).mYlocation));
                iIOMetadataNode3.setAttribute("scale", String.valueOf(((PSDPrintScale)object3).mScale));
            } else if (pSDImageResource instanceof PSDResolutionInfo) {
                object3 = (PSDResolutionInfo)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("ResolutionInfo");
                iIOMetadataNode3.setAttribute("horizontalResolution", String.valueOf(((PSDResolutionInfo)object3).mHRes));
                iIOMetadataNode3.setAttribute("horizontalResolutionUnit", RESOLUTION_UNITS[((PSDResolutionInfo)object3).mHResUnit]);
                iIOMetadataNode3.setAttribute("widthUnit", DIMENSION_UNITS[((PSDResolutionInfo)object3).mWidthUnit]);
                iIOMetadataNode3.setAttribute("verticalResolution", String.valueOf(((PSDResolutionInfo)object3).mVRes));
                iIOMetadataNode3.setAttribute("verticalResolutionUnit", RESOLUTION_UNITS[((PSDResolutionInfo)object3).mVResUnit]);
                iIOMetadataNode3.setAttribute("heightUnit", DIMENSION_UNITS[((PSDResolutionInfo)object3).mHeightUnit]);
            } else if (pSDImageResource instanceof PSDUnicodeAlphaNames) {
                object3 = (PSDUnicodeAlphaNames)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("UnicodeAlphaNames");
                for (String string : ((PSDUnicodeAlphaNames)object3).mNames) {
                    iIOMetadataNode2 = new IIOMetadataNode("Name");
                    iIOMetadataNode2.setAttribute("value", string);
                    iIOMetadataNode3.appendChild(iIOMetadataNode2);
                }
            } else if (pSDImageResource instanceof PSDVersionInfo) {
                object3 = (PSDVersionInfo)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("VersionInfo");
                iIOMetadataNode3.setAttribute("version", String.valueOf(((PSDVersionInfo)object3).mVersion));
                iIOMetadataNode3.setAttribute("hasRealMergedData", String.valueOf(((PSDVersionInfo)object3).mHasRealMergedData));
                iIOMetadataNode3.setAttribute("writer", ((PSDVersionInfo)object3).mWriter);
                iIOMetadataNode3.setAttribute("reader", ((PSDVersionInfo)object3).mReader);
                iIOMetadataNode3.setAttribute("fileVersion", String.valueOf(((PSDVersionInfo)object3).mFileVersion));
            } else if (pSDImageResource instanceof PSDThumbnail) {
                object3 = (PSDThumbnail)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("Thumbnail");
                iIOMetadataNode3.setUserObject(((PSDThumbnail)object3).getThumbnail());
            } else if (pSDImageResource instanceof PSDIPTCData) {
                object3 = (PSDIPTCData)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("DirectoryResource");
                iIOMetadataNode3.setAttribute("type", "IPTC");
                iIOMetadataNode3.setUserObject(((PSDIPTCData)object3).mDirectory);
                this.appendEntries(iIOMetadataNode3, "IPTC", ((PSDIPTCData)object3).mDirectory);
            } else if (pSDImageResource instanceof PSDEXIF1Data) {
                object3 = (PSDEXIF1Data)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("DirectoryResource");
                iIOMetadataNode3.setAttribute("type", "EXIF");
                iIOMetadataNode3.setUserObject(((PSDEXIF1Data)object3).mDirectory);
                this.appendEntries(iIOMetadataNode3, "EXIF", ((PSDEXIF1Data)object3).mDirectory);
            } else if (pSDImageResource instanceof PSDXMPData) {
                object3 = (PSDXMPData)pSDImageResource;
                iIOMetadataNode3 = new IIOMetadataNode("DirectoryResource");
                iIOMetadataNode3.setAttribute("type", "XMP");
                this.appendEntries(iIOMetadataNode3, "XMP", ((PSDXMPData)object3).mDirectory);
                iIOMetadataNode3.setUserObject(((PSDXMPData)object3).mData);
            } else {
                iIOMetadataNode3 = new IIOMetadataNode("ImageResource");
                object3 = PSDImageResource.resourceTypeForId(pSDImageResource.mId);
                if (!"UnknownResource".equals(object3)) {
                    iIOMetadataNode3.setAttribute("name", (String)object3);
                }
                iIOMetadataNode3.setAttribute("length", String.valueOf(pSDImageResource.mSize));
            }
            iIOMetadataNode3.setAttribute("resourceId", String.format("0x%04x", pSDImageResource.mId));
            iIOMetadataNode.appendChild(iIOMetadataNode3);
        }
        return iIOMetadataNode;
    }

    private void appendEntries(IIOMetadataNode iIOMetadataNode, String string, Directory directory) {
        for (Entry entry : directory) {
            Object object = entry.getIdentifier();
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Entry");
            iIOMetadataNode2.setAttribute("tag", String.format("%s", object));
            String string2 = entry.getFieldName();
            if (string2 != null) {
                iIOMetadataNode2.setAttribute("field", String.format("%s", string2));
            } else if ("IPTC".equals(string)) {
                iIOMetadataNode2.setAttribute("field", String.format("%s:%s", (Integer)object >> 8, (Integer)object & 0xFF));
            }
            if (entry.getValue() instanceof Directory) {
                this.appendEntries(iIOMetadataNode2, string, (Directory)entry.getValue());
                iIOMetadataNode2.setAttribute("type", "Directory");
            } else {
                iIOMetadataNode2.setAttribute("value", entry.getValueAsString());
                iIOMetadataNode2.setAttribute("type", entry.getTypeName());
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        switch (this.mHeader.mMode) {
            case 0: 
            case 1: 
            case 8: {
                string = "GRAY";
                break;
            }
            case 2: 
            case 3: {
                string = "RGB";
                break;
            }
            case 4: {
                string = "CMYK";
                break;
            }
            case 7: {
                string = this.getMultiChannelCS(this.mHeader.mChannels);
                break;
            }
            case 9: {
                string = "Lab";
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable");
            }
        }
        iIOMetadataNode2.setAttribute("name", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.mHeader.mChannels));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.mHeader.mMode == 2) {
            iIOMetadataNode2 = this.createPaletteNode();
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private IIOMetadataNode createPaletteNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Palette");
        IndexColorModel indexColorModel = this.mColorData.getIndexColorModel();
        int n = 0;
        while (n < indexColorModel.getMapSize()) {
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PaletteEntry");
            iIOMetadataNode2.setAttribute("index", Integer.toString(n));
            iIOMetadataNode2.setAttribute("red", Integer.toString(indexColorModel.getRed(n)));
            iIOMetadataNode2.setAttribute("green", Integer.toString(indexColorModel.getGreen(n)));
            iIOMetadataNode2.setAttribute("blue", Integer.toString(indexColorModel.getBlue(n)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            ++n;
        }
        return iIOMetadataNode;
    }

    private String getMultiChannelCS(short s) {
        if (s < 16) {
            return String.format("%xCLR", s);
        }
        throw new UnsupportedOperationException("Standard meta data format does not support more than 15 channels");
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        String string;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        switch (this.mCompression) {
            case 0: {
                string = "none";
                break;
            }
            case 1: {
                string = "PackBits";
                break;
            }
            case 2: 
            case 3: {
                string = "Deflate";
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreachable");
            }
        }
        iIOMetadataNode2.setAttribute("value", string);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PlaneInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", this.mHeader.mMode == 2 ? "Index" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        String string = Integer.toString(this.mHeader.mBits);
        Object[] objectArray = new String[this.mHeader.mChannels];
        Arrays.fill(objectArray, string);
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", StringUtil.toCSVString(objectArray, " "));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        Object object;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        float f = 1.0f;
        Iterator<PSDPixelAspectRatio> iterator = this.getResources(PSDPixelAspectRatio.class);
        if (iterator.hasNext()) {
            object = iterator.next();
            f = (float)((PSDPixelAspectRatio)object).mAspect;
        }
        iIOMetadataNode2.setAttribute("value", Float.toString(f));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        object = this.getResources(PSDResolutionInfo.class);
        if (!object.hasNext()) {
            PSDResolutionInfo pSDResolutionInfo = (PSDResolutionInfo)object.next();
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(PSDMetadata.asMM(pSDResolutionInfo.mHResUnit, pSDResolutionInfo.mHRes)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(PSDMetadata.asMM(pSDResolutionInfo.mVResUnit, pSDResolutionInfo.mVRes)));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private static float asMM(short s, float f) {
        return (s == 1 ? 25.4f : 10.0f) / f;
    }

    @Override
    protected IIOMetadataNode getStandardDocumentNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("FormatVersion");
        iIOMetadataNode2.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        Iterator<PSDEXIF1Data> iterator = this.getResources(PSDEXIF1Data.class);
        if (iterator.hasNext()) {
            PSDEXIF1Data pSDEXIF1Data = iterator.next();
            Entry entry = pSDEXIF1Data.mDirectory.getEntryById(306);
            if (entry != null) {
                iIOMetadataNode2 = new IIOMetadataNode("ImageCreationTime");
                String string = entry.getValueAsString();
                iIOMetadataNode2.setAttribute("year", string.substring(0, 4));
                iIOMetadataNode2.setAttribute("month", string.substring(5, 7));
                iIOMetadataNode2.setAttribute("day", string.substring(8, 10));
                iIOMetadataNode2.setAttribute("hour", string.substring(11, 13));
                iIOMetadataNode2.setAttribute("minute", string.substring(14, 16));
                iIOMetadataNode2.setAttribute("second", string.substring(17, 19));
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        Iterator<PSDImageResource> iterator = this.getResources(1028, 1058, 1060);
        if (!iterator.hasNext()) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        while (iterator.hasNext()) {
            PSDImageResource pSDImageResource;
            PSDImageResource pSDImageResource2 = iterator.next();
            if (pSDImageResource2 instanceof PSDIPTCData) {
                pSDImageResource = (PSDIPTCData)pSDImageResource2;
                this.appendTextEntriesFlat(iIOMetadataNode, pSDImageResource.mDirectory, new FilterIterator.Filter<Entry>(){

                    @Override
                    public boolean accept(Entry entry) {
                        Integer n = (Integer)entry.getIdentifier();
                        switch (n) {
                            case 627: {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                continue;
            }
            if (pSDImageResource2 instanceof PSDEXIF1Data) {
                pSDImageResource = (PSDEXIF1Data)pSDImageResource2;
                this.appendTextEntriesFlat(iIOMetadataNode, ((PSDEXIF1Data)pSDImageResource).mDirectory, new FilterIterator.Filter<Entry>(){

                    @Override
                    public boolean accept(Entry entry) {
                        Integer n = (Integer)entry.getIdentifier();
                        switch (n) {
                            case 305: 
                            case 315: 
                            case 33432: {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                continue;
            }
            if (!(pSDImageResource2 instanceof PSDXMPData)) continue;
            PSDXMPData cfr_ignored_0 = (PSDXMPData)pSDImageResource2;
        }
        return iIOMetadataNode;
    }

    private void appendTextEntriesFlat(IIOMetadataNode iIOMetadataNode, Directory directory, FilterIterator.Filter<Entry> filter) {
        FilterIterator<Entry> filterIterator = new FilterIterator<Entry>(directory.iterator(), filter);
        while (filterIterator.hasNext()) {
            Entry entry = filterIterator.next();
            if (entry.getValue() instanceof Directory) {
                this.appendTextEntriesFlat(iIOMetadataNode, (Directory)entry.getValue(), filter);
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            String string = entry.getFieldName();
            if (string != null) {
                iIOMetadataNode2.setAttribute("keyword", String.format("%s", string));
            } else {
                iIOMetadataNode2.setAttribute("keyword", String.format("%s", entry.getIdentifier()));
            }
            iIOMetadataNode2.setAttribute("value", entry.getValueAsString());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
    }

    @Override
    protected IIOMetadataNode getStandardTileNode() {
        return super.getStandardTileNode();
    }

    @Override
    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        iIOMetadataNode2.setAttribute("value", this.hasAlpha() ? "nonpremultiplied" : "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private boolean hasAlpha() {
        return this.mHeader.mMode == 3 && this.mHeader.mChannels >= 4 || this.mHeader.mMode == 4 & this.mHeader.mChannels >= 5;
    }

    <T extends PSDImageResource> Iterator<T> getResources(final Class<T> clazz) {
        Iterator<PSDImageResource> iterator = this.mImageResources.iterator();
        return new FilterIterator<PSDImageResource>(iterator, new FilterIterator.Filter<T>(){

            @Override
            public boolean accept(T t) {
                return clazz.isInstance(t);
            }
        });
    }

    Iterator<PSDImageResource> getResources(final int ... nArray) {
        Iterator<PSDImageResource> iterator = this.mImageResources.iterator();
        return new FilterIterator<PSDImageResource>(iterator, new FilterIterator.Filter<PSDImageResource>(){

            @Override
            public boolean accept(PSDImageResource pSDImageResource) {
                int[] nArray2 = nArray;
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray2[n2];
                    if (n3 == pSDImageResource.mId) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

