/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerMaskData {
    private int mTop;
    private int mLeft;
    private int mBottom;
    private int mRight;
    private int mDefaultColor;
    private int mFlags;
    private boolean mLarge;
    private int mRealFlags;
    private int mRealUserBackground;
    private int mRealTop;
    private int mRealLeft;
    private int mRealBottom;
    private int mRealRight;

    PSDLayerMaskData(ImageInputStream imageInputStream, int n) throws IOException {
        if (n != 20 && n != 36) {
            throw new IIOException("Illegal PSD Layer Mask data size: " + n + " (expeced 20 or 36)");
        }
        this.mTop = imageInputStream.readInt();
        this.mLeft = imageInputStream.readInt();
        this.mBottom = imageInputStream.readInt();
        this.mRight = imageInputStream.readInt();
        this.mDefaultColor = imageInputStream.readUnsignedByte();
        this.mFlags = imageInputStream.readUnsignedByte();
        if (n == 20) {
            imageInputStream.readShort();
        } else {
            this.mLarge = true;
            this.mRealFlags = imageInputStream.readUnsignedByte();
            this.mRealUserBackground = imageInputStream.readUnsignedByte();
            this.mRealTop = imageInputStream.readInt();
            this.mRealLeft = imageInputStream.readInt();
            this.mRealBottom = imageInputStream.readInt();
            this.mRealRight = imageInputStream.readInt();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.mTop);
        stringBuilder.append(", left: ").append(this.mLeft);
        stringBuilder.append(", bottom: ").append(this.mBottom);
        stringBuilder.append(", right: ").append(this.mRight);
        stringBuilder.append(", default color: ").append(this.mDefaultColor);
        stringBuilder.append(", flags: ").append(Integer.toBinaryString(this.mFlags));
        stringBuilder.append(" (");
        if ((this.mFlags & 1) != 0) {
            stringBuilder.append("Pos. rel. to layer");
        } else {
            stringBuilder.append("Pos. abs.");
        }
        if ((this.mFlags & 2) != 0) {
            stringBuilder.append(", Mask disabled");
        } else {
            stringBuilder.append(", Mask enabled");
        }
        if ((this.mFlags & 4) != 0) {
            stringBuilder.append(", Invert mask");
        }
        if ((this.mFlags & 8) != 0) {
            stringBuilder.append(", Unknown bit 3");
        }
        if ((this.mFlags & 0x10) != 0) {
            stringBuilder.append(", Unknown bit 4");
        }
        if ((this.mFlags & 0x20) != 0) {
            stringBuilder.append(", Unknown bit 5");
        }
        if ((this.mFlags & 0x40) != 0) {
            stringBuilder.append(", Unknown bit 6");
        }
        if ((this.mFlags & 0x80) != 0) {
            stringBuilder.append(", Unknown bit 7");
        }
        stringBuilder.append(")");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

