/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelSourceDestinationRange;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerBlendMode;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerMaskData;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDLayerInfo {
    final int mTop;
    final int mLeft;
    final int mBottom;
    final int mRight;
    final PSDChannelInfo[] mChannelInfo;
    final PSDLayerBlendMode mBlendMode;
    final PSDLayerMaskData mLayerMaskData;
    final PSDChannelSourceDestinationRange[] mRanges;
    final String mLayerName;

    PSDLayerInfo(ImageInputStream imageInputStream) throws IOException {
        this.mTop = imageInputStream.readInt();
        this.mLeft = imageInputStream.readInt();
        this.mBottom = imageInputStream.readInt();
        this.mRight = imageInputStream.readInt();
        int n = imageInputStream.readUnsignedShort();
        this.mChannelInfo = new PSDChannelInfo[n];
        int n2 = 0;
        while (n2 < n) {
            short s = imageInputStream.readShort();
            long l = imageInputStream.readUnsignedInt();
            this.mChannelInfo[n2] = new PSDChannelInfo(s, l);
            ++n2;
        }
        this.mBlendMode = new PSDLayerBlendMode(imageInputStream);
        long l = imageInputStream.readUnsignedInt();
        int n3 = imageInputStream.readInt();
        this.mLayerMaskData = n3 != 0 ? new PSDLayerMaskData(imageInputStream, n3) : null;
        int n4 = imageInputStream.readInt();
        if (n4 % 8 != 0) {
            throw new IIOException("Illegal PSD Layer Blending Data size: " + n4 + ", expected multiple of 8");
        }
        this.mRanges = new PSDChannelSourceDestinationRange[n4 / 8];
        int n5 = 0;
        while (n5 < this.mRanges.length) {
            this.mRanges[n5] = new PSDChannelSourceDestinationRange(imageInputStream, n5 == 0 ? "Gray" : "Channel " + (n5 - 1));
            ++n5;
        }
        this.mLayerName = PSDUtil.readPascalString(imageInputStream);
        n5 = this.mLayerName.length() + 1;
        if (n5 % 4 != 0) {
            int n6 = n5 % 4;
            imageInputStream.skipBytes(n6);
            n5 += n6;
        }
        imageInputStream.skipBytes(l - (long)n3 - 4L - (long)n4 - 4L - (long)n5);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("top: ").append(this.mTop);
        stringBuilder.append(", left: ").append(this.mLeft);
        stringBuilder.append(", bottom: ").append(this.mBottom);
        stringBuilder.append(", right: ").append(this.mRight);
        stringBuilder.append(", channels: ").append(Arrays.toString(this.mChannelInfo));
        stringBuilder.append(", blend mode: ").append(this.mBlendMode);
        if (this.mLayerMaskData != null) {
            stringBuilder.append(", layer mask data: ").append(this.mLayerMaskData);
        }
        stringBuilder.append(", ranges: ").append(Arrays.toString(this.mRanges));
        stringBuilder.append(", layer name: \"").append(this.mLayerName).append("\"");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

