/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.deltopia.util.logging.ToString;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSD;
import com.twelvemonkeys.imageio.plugins.psd.PSDAlphaChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDDisplayInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDEXIF1Data;
import com.twelvemonkeys.imageio.plugins.psd.PSDGridAndGuideInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDIPTCData;
import com.twelvemonkeys.imageio.plugins.psd.PSDPixelAspectRatio;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlags;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintFlagsInformation;
import com.twelvemonkeys.imageio.plugins.psd.PSDPrintScale;
import com.twelvemonkeys.imageio.plugins.psd.PSDResolutionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUnicodeAlphaNames;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.plugins.psd.PSDVersionInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDXMPData;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PSDImageResource {
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.twelvemonkeys.imageio.plugins.psd.PSDImageResource");
    private static final int RESOURCE_TYPE_MeSa = 1298486113;
    final short mId;
    final String mName;
    final long mSize;

    PSDImageResource(short s, ImageInputStream imageInputStream) throws IOException {
        this.mId = s;
        this.mName = PSDUtil.readPascalString(imageInputStream);
        int n = this.mName.length() + 1;
        if (n % 2 != 0) {
            imageInputStream.readByte();
        }
        this.mSize = imageInputStream.readUnsignedInt();
        long l = imageInputStream.getStreamPosition();
        this.readData(new SubImageInputStream(imageInputStream, this.mSize, this instanceof PSDXMPData));
        if (imageInputStream.getStreamPosition() != l + this.mSize) {
            imageInputStream.seek(l + this.mSize);
        }
        if (this.mSize % 2L != 0L) {
            imageInputStream.read();
        }
    }

    protected void readData(ImageInputStream imageInputStream) throws IOException {
        if (LOG.isInfoEnabled() && this.mSize < Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)this.mSize];
            imageInputStream.read(byArray);
            LOG.warn(new ToString().append("Skip image resource id=" + this.mId + ", name=" + this.mName + ", size=" + this.mSize, byArray).toString());
        } else {
            imageInputStream.skipBytes(this.mSize);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", data length: ");
        stringBuilder.append(this.mSize);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        String string = PSDImageResource.resourceTypeForId(this.mId);
        if (string != null) {
            stringBuilder.append("(").append(string).append(")");
        }
        stringBuilder.append("[ID: 0x");
        stringBuilder.append(Integer.toHexString(this.mId));
        if (this.mName != null && this.mName.trim().length() != 0) {
            stringBuilder.append(", name: \"");
            stringBuilder.append(this.mName);
            stringBuilder.append("\"");
        }
        return stringBuilder;
    }

    static String resourceTypeForId(short s) {
        switch (s) {
            case 1005: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1028: 
            case 1032: 
            case 1033: 
            case 1036: 
            case 1039: 
            case 1057: 
            case 1058: 
            case 1060: 
            case 1062: 
            case 1064: 
            case 10000: {
                return null;
            }
        }
        try {
            Field[] fieldArray = PSD.class.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().startsWith("RES_") && field.getInt(null) == s) {
                    String string = field.getName().substring(4);
                    return StringUtil.lispToCamel(string.replace("_", "-").toLowerCase(), true);
                }
                ++n2;
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
        return "UnknownResource";
    }

    public static PSDImageResource read(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n != 943868237 && n != 1298486113) {
            throw new IIOException(String.format("Wrong image resource type, expected '8BIM': '%s' at pos %d", PSDUtil.intToStr(n), imageInputStream.getStreamPosition()));
        }
        short s = imageInputStream.readShort();
        switch (s) {
            case 1005: {
                return new PSDResolutionInfo(s, imageInputStream);
            }
            case 1006: {
                return new PSDAlphaChannelInfo(s, imageInputStream);
            }
            case 1007: {
                return new PSDDisplayInfo(s, imageInputStream);
            }
            case 1011: {
                return new PSDPrintFlags(s, imageInputStream);
            }
            case 1028: {
                return new PSDIPTCData(s, imageInputStream);
            }
            case 1032: {
                return new PSDGridAndGuideInfo(s, imageInputStream);
            }
            case 1033: 
            case 1036: {
                return new PSDThumbnail(s, imageInputStream);
            }
            case 1039: {
                return new ICCProfile(s, imageInputStream);
            }
            case 1045: {
                return new PSDUnicodeAlphaNames(s, imageInputStream);
            }
            case 1057: {
                return new PSDVersionInfo(s, imageInputStream);
            }
            case 1058: {
                return new PSDEXIF1Data(s, imageInputStream);
            }
            case 1060: {
                return new PSDXMPData(s, imageInputStream);
            }
            case 1062: {
                return new PSDPrintScale(s, imageInputStream);
            }
            case 1064: {
                return new PSDPixelAspectRatio(s, imageInputStream);
            }
            case 10000: {
                return new PSDPrintFlagsInformation(s, imageInputStream);
            }
        }
        if (s >= 2000 && s <= 2998) {
            return new PSDImageResource(s, imageInputStream);
        }
        return new PSDImageResource(s, imageInputStream);
    }
}

