/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.psd.CMYKColorSpace;
import com.twelvemonkeys.imageio.plugins.psd.ICCProfile;
import com.twelvemonkeys.imageio.plugins.psd.PSDChannelInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDColorData;
import com.twelvemonkeys.imageio.plugins.psd.PSDGlobalLayerMask;
import com.twelvemonkeys.imageio.plugins.psd.PSDHeader;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.imageio.plugins.psd.PSDLayerInfo;
import com.twelvemonkeys.imageio.plugins.psd.PSDMetadata;
import com.twelvemonkeys.imageio.plugins.psd.PSDThumbnail;
import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public class PSDImageReader
extends ImageReaderBase {
    private PSDHeader mHeader;
    private ICC_ColorSpace mColorSpace;
    protected PSDMetadata mMetadata;

    protected PSDImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    protected void resetMembers() {
        this.mHeader = null;
        this.mMetadata = null;
        this.mColorSpace = null;
    }

    @Override
    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.mHeader.mWidth;
    }

    @Override
    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.mHeader.mHeight;
    }

    @Override
    public ImageTypeSpecifier getRawImageType(int n) throws IOException {
        return this.getRawImageTypeInternal(n);
    }

    private ImageTypeSpecifier getRawImageTypeInternal(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        switch (this.mHeader.mMode) {
            case 0: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 1) {
                    return ImageTypeSpecifier.createFromBufferedImageType(12);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Monochrome PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 2: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 8) {
                    return IndexedImageTypeSpecifier.createFromIndexColorModel(this.mMetadata.mColorData.getIndexColorModel());
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Indexed Color PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 1: 
            case 8: {
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 8) {
                    return ImageTypeSpecifier.createFromBufferedImageType(10);
                }
                if (this.mHeader.mChannels == 1 && this.mHeader.mBits == 16) {
                    return ImageTypeSpecifier.createFromBufferedImageType(11);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for Gray Scale PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 3: {
                ColorSpace colorSpace = this.getEmbeddedColorSpace();
                if (colorSpace == null) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[3];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false);
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    return ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, true, false);
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[3];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[3], 1, false, false);
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[4], 1, true, false);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for RGB PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
            case 4: {
                ColorSpace colorSpace = this.getEmbeddedColorSpace();
                if (colorSpace == null) {
                    colorSpace = CMYKColorSpace.getInstance();
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[4], 0, false, false);
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[5];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    nArray[4] = 4;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[5], 0, true, false);
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[4];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[4], 1, false, false);
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[5];
                    nArray[1] = 1;
                    nArray[2] = 2;
                    nArray[3] = 3;
                    nArray[4] = 4;
                    return ImageTypeSpecifier.createBanded(colorSpace, nArray, new int[5], 1, true, false);
                }
                throw new IIOException(String.format("Unsupported channel count/bit depth for CMYK PSD: %d channels/%d bits", this.mHeader.mChannels, this.mHeader.mBits));
            }
        }
        throw new IIOException(String.format("Unsupported PSD MODE: %s (%d channels/%d bits)", this.mHeader.mMode, this.mHeader.mChannels, this.mHeader.mBits));
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageTypeInternal(n);
        ColorSpace colorSpace = imageTypeSpecifier.getColorModel().getColorSpace();
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        switch (this.mHeader.mMode) {
            case 3: {
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[3];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false));
                    break;
                }
                if (this.mHeader.mChannels >= 4 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[4];
                    nArray[0] = 3;
                    nArray[1] = 2;
                    nArray[2] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, true, false));
                    break;
                }
                if (this.mHeader.mChannels == 3 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[3];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 1, false, false));
                    break;
                }
                if (this.mHeader.mChannels < 4 || this.mHeader.mBits != 16) break;
                int[] nArray = new int[4];
                nArray[0] = 3;
                nArray[1] = 2;
                nArray[2] = 1;
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 1, true, false));
                break;
            }
            case 4: {
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[4];
                    nArray[0] = 3;
                    nArray[1] = 2;
                    nArray[2] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false));
                    break;
                }
                if (this.mHeader.mChannels == 5 && this.mHeader.mBits == 8) {
                    int[] nArray = new int[5];
                    nArray[0] = 4;
                    nArray[1] = 3;
                    nArray[2] = 2;
                    nArray[3] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, true, false));
                    break;
                }
                if (this.mHeader.mChannels == 4 && this.mHeader.mBits == 16) {
                    int[] nArray = new int[4];
                    nArray[0] = 3;
                    nArray[1] = 2;
                    nArray[2] = 1;
                    arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 1, false, false));
                    break;
                }
                if (this.mHeader.mChannels != 5 || this.mHeader.mBits != 16) break;
                int[] nArray = new int[5];
                nArray[0] = 4;
                nArray[1] = 3;
                nArray[2] = 2;
                nArray[3] = 1;
                arrayList.add(ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 1, true, false));
            }
        }
        arrayList.add(imageTypeSpecifier);
        return arrayList.iterator();
    }

    private ColorSpace getEmbeddedColorSpace() throws IOException {
        this.readImageResources(true);
        this.readLayerAndMaskInfo(false);
        if (this.mColorSpace == null) {
            ICC_Profile iCC_Profile = null;
            for (PSDImageResource pSDImageResource : this.mMetadata.mImageResources) {
                if (!(pSDImageResource instanceof ICCProfile)) continue;
                iCC_Profile = ((ICCProfile)pSDImageResource).getProfile();
                break;
            }
            this.mColorSpace = iCC_Profile == null ? null : new ICC_ColorSpace(iCC_Profile);
        }
        return this.mColorSpace;
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        int n3;
        this.checkBounds(n);
        this.readHeader();
        this.readImageResources(false);
        this.readLayerAndMaskInfo(false);
        BufferedImage bufferedImage = PSDImageReader.getDestination(imageReadParam, this.getImageTypes(n), this.mHeader.mWidth, this.mHeader.mHeight);
        ImageTypeSpecifier imageTypeSpecifier = this.getRawImageType(n);
        PSDImageReader.checkReadParamBandSettings(imageReadParam, imageTypeSpecifier.getNumBands(), bufferedImage.getSampleModel().getNumBands());
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        PSDImageReader.computeRegions(imageReadParam, this.mHeader.mWidth, this.mHeader.mHeight, bufferedImage, rectangle, rectangle2);
        if (imageReadParam == null) {
            n3 = 1;
            n2 = 1;
        } else {
            n2 = imageReadParam.getSourceXSubsampling();
            n3 = imageReadParam.getSourceYSubsampling();
        }
        this.processImageStarted(n);
        int[] nArray = null;
        short s = this.mImageInput.readShort();
        this.mMetadata.mCompression = s;
        switch (s) {
            case 0: {
                break;
            }
            case 1: {
                nArray = new int[this.mHeader.mChannels * this.mHeader.mHeight];
                int n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = this.mImageInput.readUnsignedShort();
                    ++n4;
                }
                break;
            }
            case 2: 
            case 3: {
                throw new IIOException("ZIP compression not supported yet");
            }
            default: {
                throw new IIOException(String.format("Unknown PSD compression: %d. Expected 0 (none), 1 (RLE), 2 (ZIP) or 3 (ZIP w/prediction).", s));
            }
        }
        this.readImageData(bufferedImage, imageTypeSpecifier.getColorModel(), rectangle, rectangle2, n2, n3, nArray, s);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    private void readImageData(BufferedImage bufferedImage, ColorModel colorModel, Rectangle rectangle, Rectangle rectangle2, int n, int n2, int[] nArray, int n3) throws IOException {
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel2 = bufferedImage.getColorModel();
        WritableRaster writableRaster2 = colorModel.createCompatibleWritableRaster(this.mHeader.mWidth, 1);
        int n4 = writableRaster2.getNumBands();
        boolean bl = writableRaster.getDataBuffer().getNumBanks() > 1;
        int n5 = bl ? 1 : writableRaster.getNumBands();
        int n6 = 0;
        while (n6 < n4) {
            int n7 = bl ? 0 : n5 - 1 - n6;
            switch (this.mHeader.mBits) {
                case 1: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                    byte[] byArray2 = bl ? dataBufferByte.getData(n6) : dataBufferByte.getData();
                    this.read1bitChannel(n6, this.mHeader.mChannels, byArray2, n5, n7, colorModel, byArray, rectangle, rectangle2, n, n2, this.mHeader.mWidth, this.mHeader.mHeight, nArray, n3 == 1);
                    break;
                }
                case 8: {
                    byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                    DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                    byte[] byArray3 = bl ? dataBufferByte.getData(n6) : dataBufferByte.getData();
                    this.read8bitChannel(n6, this.mHeader.mChannels, byArray3, n5, n7, colorModel, byArray, rectangle, rectangle2, n, n2, this.mHeader.mWidth, this.mHeader.mHeight, nArray, n6 * this.mHeader.mHeight, n3 == 1);
                    break;
                }
                case 16: {
                    short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                    short[] sArray2 = bl ? dataBufferUShort.getData(n6) : dataBufferUShort.getData();
                    this.read16bitChannel(n6, this.mHeader.mChannels, sArray2, n5, n7, colorModel, sArray, rectangle, rectangle2, n, n2, this.mHeader.mWidth, this.mHeader.mHeight, nArray, n6 * this.mHeader.mHeight, n3 == 1);
                    break;
                }
                default: {
                    throw new IIOException(String.format("Unknown PSD bit depth: %s", this.mHeader.mBits));
                }
            }
            if (this.abortRequested()) break;
            ++n6;
        }
        if (this.mHeader.mBits == 8) {
            this.decomposeAlpha(colorModel2, (DataBufferByte)writableRaster.getDataBuffer(), rectangle2.width, rectangle2.height, writableRaster.getNumBands());
        }
    }

    private void read16bitChannel(int n, int n2, short[] sArray, int n3, int n4, ColorModel colorModel, short[] sArray2, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, int n9, boolean bl) throws IOException {
        boolean bl2 = colorModel.getColorSpace().getType() == 9;
        int n10 = colorModel.getColorSpace().getNumComponents();
        int n11 = 0;
        while (n11 < n8) {
            int n12 = 2 * (bl ? nArray[n9 + n11] : n7);
            if (n11 >= rectangle.y && n11 < rectangle.y + rectangle.height && n11 % n6 == 0) {
                int n13;
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.mImageInput, n12);){
                        n13 = 0;
                        while (n13 < n7) {
                            sArray2[n13] = dataInputStream.readShort();
                            ++n13;
                        }
                    }
                } else {
                    this.mImageInput.readFully(sArray2, 0, n7);
                }
                int n14 = (n11 - rectangle.y) / n6 * rectangle2.width * n3 + n4;
                n13 = 0;
                while (n13 < rectangle2.width) {
                    short s = sArray2[rectangle.x + n13 * n5];
                    if (bl2 && n < n10) {
                        s = (short)(65535 - s & 0xFFFF);
                    }
                    sArray[n14 + n13 * n3] = s;
                    ++n13;
                }
            } else {
                this.mImageInput.skipBytes(n12);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(n * n11 * 100 / n2 * n8);
            ++n11;
        }
    }

    private void read8bitChannel(int n, int n2, byte[] byArray, int n3, int n4, ColorModel colorModel, byte[] byArray2, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, int n9, boolean bl) throws IOException {
        boolean bl2 = colorModel.getColorSpace().getType() == 9;
        int n10 = colorModel.getColorSpace().getNumComponents();
        int n11 = 0;
        while (n11 < n8) {
            int n12;
            int n13 = n12 = bl ? nArray[n9 + n11] : n7;
            if (n11 >= rectangle.y && n11 < rectangle.y + rectangle.height && n11 % n6 == 0) {
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.mImageInput, n12);){
                        dataInputStream.readFully(byArray2, 0, n7);
                    }
                } else {
                    this.mImageInput.readFully(byArray2, 0, n7);
                }
                int n14 = (n11 - rectangle.y) / n6 * rectangle2.width * n3 + n4;
                int n15 = 0;
                while (n15 < rectangle2.width) {
                    byte by = byArray2[rectangle.x + n15 * n5];
                    if (bl2 && n < n10) {
                        by = (byte)(255 - by & 0xFF);
                    }
                    byArray[n14 + n15 * n3] = by;
                    ++n15;
                }
            } else {
                this.mImageInput.skipBytes(n12);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(n * n11 * 100 / n2 * n8);
            ++n11;
        }
    }

    private void read1bitChannel(int n, int n2, byte[] byArray, int n3, int n4, ColorModel colorModel, byte[] byArray2, Rectangle rectangle, Rectangle rectangle2, int n5, int n6, int n7, int n8, int[] nArray, boolean bl) throws IOException {
        int n9 = (rectangle2.width + 7) / 8;
        int n10 = 0;
        while (n10 < n8) {
            int n11;
            int n12 = n11 = bl ? nArray[n10] : n7;
            if (n10 >= rectangle.y && n10 < rectangle.y + rectangle.height && n10 % n6 == 0) {
                int n13;
                int n14;
                if (bl) {
                    try (DataInputStream dataInputStream = PSDUtil.createPackBitsStream(this.mImageInput, n11);){
                        dataInputStream.readFully(byArray2, 0, byArray2.length);
                    }
                } else {
                    this.mImageInput.readFully(byArray2, 0, byArray2.length);
                }
                int n15 = (n10 - rectangle.y) / n6 * n9;
                if (n5 == 1 && rectangle.x % 8 == 0) {
                    n14 = 0;
                    while (n14 < n9) {
                        n13 = byArray2[rectangle.x / 8 + n14 * n5];
                        byArray[n15 + n14] = (byte)(~n13 & 0xFF);
                        ++n14;
                    }
                } else {
                    n14 = rectangle.x + rectangle.width;
                    n13 = rectangle.x;
                    int n16 = 0;
                    while (n16 < n9) {
                        int n17 = 0;
                        int n18 = 0;
                        while (n18 < 8 && n13 < n14) {
                            int n19 = n13 / 8;
                            int n20 = 7 - n13 % 8;
                            int n21 = 1 << n20;
                            int n22 = 7 - n18;
                            n17 = (byte)(n17 | (byArray2[n19] & n21) >> n20 << n22);
                            n13 += n5;
                            ++n18;
                        }
                        byArray[n15 + n16] = (byte)(~n17 & 0xFF);
                        ++n16;
                    }
                }
            } else {
                this.mImageInput.skipBytes(n11);
            }
            if (this.abortRequested()) break;
            this.processImageProgress(n * n10 * 100 / n2 * n8);
            ++n10;
        }
    }

    private void decomposeAlpha(ColorModel colorModel, DataBufferByte dataBufferByte, int n, int n2, int n3) {
        block14: {
            if (!colorModel.hasAlpha() || colorModel.getColorSpace().getType() != 5) break block14;
            if (dataBufferByte.getNumBanks() > 1) {
                byte[][] byArray = dataBufferByte.getBankData();
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        int n6 = n5 + n4 * n;
                        int n7 = byArray[n3 - 1][n6] & 0xFF;
                        if (n7 != 0) {
                            double d = (double)n7 / 255.0;
                            int n8 = 0;
                            while (n8 < n3 - 1) {
                                byArray[n8][n6] = PSDImageReader.decompose(byArray[n8][n6] & 0xFF, d);
                                ++n8;
                            }
                        } else {
                            int n9 = 0;
                            while (n9 < n3 - 1) {
                                byArray[n9][n6] = 0;
                                ++n9;
                            }
                        }
                        ++n5;
                    }
                    ++n4;
                }
            } else {
                byte[] byArray = dataBufferByte.getData();
                int n10 = 0;
                while (n10 < n2) {
                    int n11 = 0;
                    while (n11 < n) {
                        int n12 = (n11 + n10 * n) * n3;
                        int n13 = byArray[n12] & 0xFF;
                        if (n13 != 0) {
                            double d = (double)n13 / 255.0;
                            int n14 = 1;
                            while (n14 < n3) {
                                byArray[n12 + n14] = PSDImageReader.decompose(byArray[n12 + n14] & 0xFF, d);
                                ++n14;
                            }
                        } else {
                            int n15 = 1;
                            while (n15 < n3) {
                                byArray[n12 + n15] = 0;
                                ++n15;
                            }
                        }
                        ++n11;
                    }
                    ++n10;
                }
            }
        }
    }

    private static byte decompose(int n, double d) {
        double d2 = (double)n / 255.0;
        return (byte)((d2 / d - (1.0 - d) / d) * 255.0);
    }

    private void readHeader() throws IOException {
        this.assertInput();
        if (this.mHeader == null) {
            this.mHeader = new PSDHeader(this.mImageInput);
            this.mMetadata = new PSDMetadata();
            this.mMetadata.mHeader = this.mHeader;
            if (this.mHeader.mMode == 2) {
                this.mMetadata.mColorData = new PSDColorData(this.mImageInput);
            } else {
                long l = this.mImageInput.readUnsignedInt();
                this.mImageInput.skipBytes(l);
            }
            this.mImageInput.flushBefore(this.mImageInput.getStreamPosition());
        }
    }

    private void readImageResources(boolean bl) throws IOException {
        long l = this.mImageInput.getFlushedPosition();
        this.mImageInput.seek(l);
        long l2 = this.mImageInput.readUnsignedInt();
        if (bl && l2 > 0L && this.mMetadata.mImageResources == null) {
            this.mMetadata.mImageResources = new ArrayList<PSDImageResource>();
            long l3 = this.mImageInput.getStreamPosition() + l2;
            while (this.mImageInput.getStreamPosition() < l3) {
                long l4 = this.mImageInput.getStreamPosition();
                try {
                    PSDImageResource pSDImageResource = PSDImageResource.read(this.mImageInput);
                    this.mMetadata.mImageResources.add(pSDImageResource);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read PSD resource at " + l4 + ": " + iOException.getMessage());
                    throw iOException;
                }
            }
            if (this.mImageInput.getStreamPosition() != l3) {
                throw new IIOException("Corrupt PSD document");
            }
        }
        this.mImageInput.seek(l + l2 + 4L);
    }

    private void readLayerAndMaskInfo(boolean bl) throws IOException {
        long l = this.mImageInput.readUnsignedInt();
        if (bl && l > 0L) {
            long l2 = this.mImageInput.getStreamPosition();
            long l3 = this.mImageInput.readUnsignedInt();
            short s = this.mImageInput.readShort();
            PSDLayerInfo[] pSDLayerInfoArray = new PSDLayerInfo[Math.abs(s)];
            int n = 0;
            while (n < pSDLayerInfoArray.length) {
                pSDLayerInfoArray[n] = new PSDLayerInfo(this.mImageInput);
                ++n;
            }
            this.mMetadata.mLayerInfo = Arrays.asList(pSDLayerInfoArray);
            this.mImageInput.mark();
            ImageTypeSpecifier imageTypeSpecifier = this.getRawImageTypeInternal(0);
            ImageTypeSpecifier imageTypeSpecifier2 = this.getImageTypes(0).next();
            this.mImageInput.reset();
            PSDLayerInfo[] pSDLayerInfoArray2 = pSDLayerInfoArray;
            int n2 = pSDLayerInfoArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PSDLayerInfo pSDLayerInfo = pSDLayerInfoArray2[n3];
                this.readLayerData(pSDLayerInfo, imageTypeSpecifier, imageTypeSpecifier2);
                ++n3;
            }
            long l4 = this.mImageInput.getStreamPosition() - l2;
            long l5 = l3 - (l4 - 4L);
            this.mImageInput.skipBytes(l5);
            long l6 = this.mImageInput.readUnsignedInt();
            if (l6 > 0L) {
                this.mMetadata.mGlobalLayerMask = new PSDGlobalLayerMask(this.mImageInput);
            }
            l4 = this.mImageInput.getStreamPosition() - l2;
            long l7 = l - l4;
            this.mImageInput.skipBytes(l7);
        } else {
            this.mImageInput.skipBytes(l);
        }
    }

    private BufferedImage readLayerData(PSDLayerInfo pSDLayerInfo, ImageTypeSpecifier imageTypeSpecifier, ImageTypeSpecifier imageTypeSpecifier2) throws IOException {
        int n = pSDLayerInfo.mRight - pSDLayerInfo.mLeft;
        int n2 = pSDLayerInfo.mBottom - pSDLayerInfo.mTop;
        ImageTypeSpecifier imageTypeSpecifier3 = this.getImageTypeForLayer(imageTypeSpecifier2, pSDLayerInfo);
        BufferedImage bufferedImage = imageTypeSpecifier3.createBufferedImage(Math.max(1, n), Math.max(1, n2));
        Rectangle rectangle = new Rectangle(n, n2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        bufferedImage.getColorModel();
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        WritableRaster writableRaster2 = n > 0 ? colorModel.createCompatibleWritableRaster(n, 1) : null;
        boolean bl = writableRaster.getDataBuffer().getNumBanks() > 1;
        int n3 = bl ? 1 : writableRaster.getNumBands();
        PSDChannelInfo[] pSDChannelInfoArray = pSDLayerInfo.mChannelInfo;
        int n4 = pSDLayerInfo.mChannelInfo.length;
        int n5 = 0;
        while (n5 < n4) {
            PSDChannelInfo pSDChannelInfo = pSDChannelInfoArray[n5];
            int n6 = this.mImageInput.readUnsignedShort();
            if (n <= 0 || n2 <= 0 || pSDChannelInfo.mChannelId == -2 || n6 != 0 && n6 != 1) {
                this.mImageInput.skipBytes(pSDChannelInfo.mLength - 2L);
            } else {
                int n7;
                int n8 = pSDChannelInfo.mChannelId == -1 ? pSDLayerInfo.mChannelInfo.length - 1 : pSDChannelInfo.mChannelId;
                int[] nArray = null;
                switch (n6) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        nArray = new int[pSDLayerInfo.mBottom - pSDLayerInfo.mTop];
                        n7 = 0;
                        while (n7 < nArray.length) {
                            nArray[n7] = this.mImageInput.readUnsignedShort();
                            ++n7;
                        }
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)String.format("Unsupported layer data. Compression: %d", n6));
                    }
                }
                n7 = bl ? 0 : n3 - 1 - n8;
                switch (this.mHeader.mBits) {
                    case 1: {
                        byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                        byte[] byArray2 = bl ? dataBufferByte.getData(n8) : dataBufferByte.getData();
                        this.read1bitChannel(n8, imageTypeSpecifier3.getNumBands(), byArray2, n3, n7, colorModel, byArray, rectangle, rectangle, 1, 1, n, n2, nArray, n6 == 1);
                        break;
                    }
                    case 8: {
                        byte[] byArray = ((DataBufferByte)writableRaster2.getDataBuffer()).getData();
                        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                        byte[] byArray3 = bl ? dataBufferByte.getData(n8) : dataBufferByte.getData();
                        this.read8bitChannel(n8, imageTypeSpecifier3.getNumBands(), byArray3, n3, n7, colorModel, byArray, rectangle, rectangle, 1, 1, n, n2, nArray, 0, n6 == 1);
                        break;
                    }
                    case 16: {
                        short[] sArray = ((DataBufferUShort)writableRaster2.getDataBuffer()).getData();
                        DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                        short[] sArray2 = bl ? dataBufferUShort.getData(n8) : dataBufferUShort.getData();
                        this.read16bitChannel(n8, imageTypeSpecifier3.getNumBands(), sArray2, n3, n7, colorModel, sArray, rectangle, rectangle, 1, 1, n, n2, nArray, 0, n6 == 1);
                        break;
                    }
                    default: {
                        throw new IIOException(String.format("Unknown PSD bit depth: %s", this.mHeader.mBits));
                    }
                }
                if (this.abortRequested()) break;
            }
            ++n5;
        }
        return bufferedImage;
    }

    private ImageTypeSpecifier getImageTypeForLayer(ImageTypeSpecifier imageTypeSpecifier, PSDLayerInfo pSDLayerInfo) {
        if (pSDLayerInfo.mChannelInfo.length > imageTypeSpecifier.getNumBands()) {
            boolean bl = false;
            PSDChannelInfo[] pSDChannelInfoArray = pSDLayerInfo.mChannelInfo;
            int n = pSDLayerInfo.mChannelInfo.length;
            int n2 = 0;
            while (n2 < n) {
                PSDChannelInfo pSDChannelInfo = pSDChannelInfoArray[n2];
                if (pSDChannelInfo.mChannelId == -2) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            int n3 = pSDLayerInfo.mChannelInfo.length - (bl ? 1 : 0);
            if (n3 > imageTypeSpecifier.getNumBands()) {
                int[] nArray = new int[n3];
                n = 0;
                int n4 = nArray.length;
                while (n < n4) {
                    nArray[n] = n4 - n;
                    ++n;
                }
                return ImageTypeSpecifier.createInterleaved(imageTypeSpecifier.getColorModel().getColorSpace(), nArray, imageTypeSpecifier.getSampleModel().getDataType(), true, false);
            }
        }
        return imageTypeSpecifier;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return super.getStreamMetadata();
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        this.readImageResources(true);
        this.readLayerAndMaskInfo(true);
        this.mMetadata.mCompression = this.mImageInput.readShort();
        return this.mMetadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int n, String string, Set<String> set) throws IOException {
        return super.getImageMetadata(n, string, set);
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return true;
    }

    private List<PSDThumbnail> getThumbnailResources(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        ArrayList<PSDThumbnail> arrayList = null;
        if (this.mMetadata.mImageResources == null) {
            this.readImageResources(true);
            this.readLayerAndMaskInfo(false);
        }
        for (PSDImageResource pSDImageResource : this.mMetadata.mImageResources) {
            if (!(pSDImageResource instanceof PSDThumbnail)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PSDThumbnail>();
            }
            arrayList.add((PSDThumbnail)pSDImageResource);
        }
        return arrayList;
    }

    @Override
    public int getNumThumbnails(int n) throws IOException {
        List<PSDThumbnail> list = this.getThumbnailResources(n);
        return list == null ? 0 : list.size();
    }

    private PSDThumbnail getThumbnailResource(int n, int n2) throws IOException {
        List<PSDThumbnail> list = this.getThumbnailResources(n);
        if (list == null) {
            throw new IndexOutOfBoundsException(String.format("thumbnail index %d > 0", n2));
        }
        return list.get(n2);
    }

    @Override
    public int getThumbnailWidth(int n, int n2) throws IOException {
        return this.getThumbnailResource(n, n2).getWidth();
    }

    @Override
    public int getThumbnailHeight(int n, int n2) throws IOException {
        return this.getThumbnailResource(n, n2).getHeight();
    }

    @Override
    public BufferedImage readThumbnail(int n, int n2) throws IOException {
        PSDThumbnail pSDThumbnail = this.getThumbnailResource(n, n2);
        this.processThumbnailStarted(n, n2);
        this.processThumbnailComplete();
        return pSDThumbnail.getThumbnail();
    }
}

