/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDUtil;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDHeader {
    final short mChannels;
    final int mWidth;
    final int mHeight;
    final short mBits;
    final short mMode;

    PSDHeader(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n != 943870035) {
            throw new IIOException("Not a PSD document, expected signature \"8BPS\": \"" + PSDUtil.intToStr(n) + "\" (0x" + Integer.toHexString(n) + ")");
        }
        int n2 = imageInputStream.readUnsignedShort();
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                throw new IIOException("Photoshop Large Document Format (PSB) not supported yet.");
            }
            default: {
                throw new IIOException(String.format("Unknown PSD version, expected 1 or 2: 0x%08x", n2));
            }
        }
        byte[] byArray = new byte[6];
        imageInputStream.readFully(byArray);
        this.mChannels = imageInputStream.readShort();
        this.mHeight = imageInputStream.readInt();
        this.mWidth = imageInputStream.readInt();
        this.mBits = imageInputStream.readShort();
        this.mMode = imageInputStream.readShort();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append("[Channels: ");
        stringBuilder.append(this.mChannels);
        stringBuilder.append(", width: ");
        stringBuilder.append(this.mWidth);
        stringBuilder.append(", height: ");
        stringBuilder.append(this.mHeight);
        stringBuilder.append(", depth: ");
        stringBuilder.append(this.mBits);
        stringBuilder.append(", mode: ");
        stringBuilder.append(this.mMode);
        switch (this.mMode) {
            case 0: {
                stringBuilder.append(" (Monochrome)");
                break;
            }
            case 1: {
                stringBuilder.append(" (Grayscale)");
                break;
            }
            case 2: {
                stringBuilder.append(" (Indexed)");
                break;
            }
            case 3: {
                stringBuilder.append(" (RGB)");
                break;
            }
            case 4: {
                stringBuilder.append(" (CMYK)");
                break;
            }
            case 7: {
                stringBuilder.append(" (Multi channel)");
                break;
            }
            case 8: {
                stringBuilder.append(" (Duotone)");
                break;
            }
            case 9: {
                stringBuilder.append(" (Lab color)");
                break;
            }
            default: {
                stringBuilder.append(" (Unkown mode)");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

