/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDDisplayInfo
extends PSDImageResource {
    int mColorSpace;
    short[] mColors;
    short mOpacity;
    byte mKind;

    PSDDisplayInfo(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        if (this.mSize % 14L != 0L) {
            throw new IIOException("Display info length expected to be mod 14: " + this.mSize);
        }
        this.mColorSpace = imageInputStream.readShort();
        this.mColors = new short[4];
        this.mColors[0] = imageInputStream.readShort();
        this.mColors[1] = imageInputStream.readShort();
        this.mColors[2] = imageInputStream.readShort();
        this.mColors[3] = imageInputStream.readShort();
        this.mOpacity = imageInputStream.readShort();
        this.mKind = imageInputStream.readByte();
        imageInputStream.readByte();
        imageInputStream.skipBytes(this.mSize - 14L);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        stringBuilder.append(", ColorSpace: ").append(this.mColorSpace);
        stringBuilder.append(", Colors: {");
        stringBuilder.append(this.mColors[0]);
        stringBuilder.append(", ");
        stringBuilder.append(this.mColors[1]);
        stringBuilder.append(", ");
        stringBuilder.append(this.mColors[2]);
        stringBuilder.append(", ");
        stringBuilder.append(this.mColors[3]);
        stringBuilder.append("}, Opacity: ").append(this.mOpacity);
        stringBuilder.append(", Kind: ").append(this.kind(this.mKind));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String kind(byte by) {
        switch (by) {
            case 0: {
                return "selected";
            }
            case 1: {
                return "protected";
            }
        }
        return "unknown kind: " + Integer.toHexString(by & 0xFF);
    }
}

