/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.image.InverseColorMapIndexColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

class PSDColorData {
    final byte[] mColors;
    private IndexColorModel mColorModel;

    PSDColorData(ImageInputStream imageInputStream) throws IOException {
        int n = imageInputStream.readInt();
        if (n == 0) {
            throw new IIOException("No palette information in PSD");
        }
        if (n % 3 != 0) {
            throw new IIOException("Wrong palette information in PSD");
        }
        this.mColors = new byte[n];
        imageInputStream.readFully(this.mColors);
    }

    IndexColorModel getIndexColorModel() {
        if (this.mColorModel == null) {
            int[] nArray = PSDColorData.toInterleavedRGB(this.mColors);
            this.mColorModel = new InverseColorMapIndexColorModel(8, nArray.length, nArray, 0, false, -1, 0);
        }
        return this.mColorModel;
    }

    private static int[] toInterleavedRGB(byte[] byArray) {
        int[] nArray = new int[byArray.length / 3];
        int n = 0;
        while (n < nArray.length) {
            int n2 = byArray[n] & 0xFF;
            int n3 = byArray[nArray.length + n] & 0xFF;
            int n4 = byArray[2 * nArray.length + n] & 0xFF;
            nArray[n] = n2 << 16 | n3 << 8 | n4;
            ++n;
        }
        return nArray;
    }
}

