/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.BitMapPattern;
import com.twelvemonkeys.imageio.plugins.pict.Pattern;
import com.twelvemonkeys.imageio.plugins.pict.QuickDraw;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

class QuickDrawContext {
    private final Graphics2D mGraphics;
    private Pattern mBackground;
    private int mPenVisibility = 0;
    private Point2D mPenPosition = new Point();
    private Pattern mPenPattern;
    private Dimension2D mPenSize = new Dimension();
    private int mPenMode;

    QuickDrawContext(Graphics2D graphics2D) {
        if (graphics2D == null) {
            throw new IllegalArgumentException("graphics == null");
        }
        this.mGraphics = graphics2D;
        this.setPenNormal();
    }

    protected void dispose() {
        this.mGraphics.dispose();
    }

    public void closePicture() {
        this.dispose();
    }

    public void setClipRegion(Shape shape) {
        this.mGraphics.setClip(shape);
    }

    void setTextFont(int n) {
        System.err.println("QuickDrawContext.setTextFont");
    }

    void setTextFace(int n) {
        System.err.println("QuickDrawContext.setTextFace");
    }

    void setTextMode(int n) {
        System.err.println("QuickDrawContext.setTextMode");
    }

    public void setTextSize(int n) {
        this.mGraphics.setFont(this.mGraphics.getFont().deriveFont((float)n));
    }

    void setTextRatio() {
        System.err.println("QuickDrawContext.setTextRatio");
    }

    public void setOrigin(Point2D point2D) {
        this.mGraphics.translate(point2D.getX(), point2D.getY());
    }

    public void setForeground(Color color) {
        this.mPenPattern = new BitMapPattern(color);
    }

    public void setBackground(Color color) {
        this.mBackground = new BitMapPattern(color);
    }

    public void hidePen() {
        --this.mPenVisibility;
    }

    public void showPen() {
        ++this.mPenVisibility;
    }

    private boolean isPenVisible() {
        return this.mPenVisibility >= 0;
    }

    public Point2D getPenPosition() {
        return (Point2D)this.mPenPosition.clone();
    }

    public void setPenSize(Dimension2D dimension2D) {
        this.mPenSize.setSize(dimension2D);
        this.mGraphics.setStroke(this.getStroke(this.mPenSize));
    }

    public void setPenMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 49: {
                this.mPenMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Undefined pen mode: " + n);
            }
        }
    }

    public void setPenPattern(Pattern pattern) {
        this.mPenPattern = pattern;
    }

    public final void setPenNormal() {
        this.setPenPattern(QuickDraw.BLACK);
        this.setPenSize(new Dimension(1, 1));
        this.mPenMode = 0;
    }

    public void setBackgroundPattern(Pattern pattern) {
        this.mBackground = pattern;
    }

    private Composite getCompositeFor(int n) {
        switch (n & 0xFFFFFFBF) {
            case 0: {
                return AlphaComposite.Src;
            }
            case 1: {
                return AlphaComposite.SrcOver;
            }
            case 2: {
                return AlphaComposite.Xor;
            }
            case 3: {
                return AlphaComposite.Clear;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                throw new UnsupportedOperationException("Not implemented for mode " + n);
            }
            case 8: {
                return AlphaComposite.Src;
            }
            case 9: {
                return AlphaComposite.SrcOver;
            }
            case 10: {
                return AlphaComposite.Xor;
            }
            case 11: {
                return AlphaComposite.Clear;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new UnsupportedOperationException("Not implemented for mode " + n);
            }
        }
        throw new IllegalArgumentException("Unknown pnMode: " + n);
    }

    protected void setupForPaint() {
        this.mGraphics.setPaint(this.mPenPattern);
        this.mGraphics.setComposite(this.getCompositeFor(this.mPenMode));
    }

    private Stroke getStroke(Dimension2D dimension2D) {
        if (dimension2D.getWidth() <= 1.0 && dimension2D.getWidth() == dimension2D.getHeight()) {
            return new BasicStroke((float)dimension2D.getWidth());
        }
        return new RectangleStroke(new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight()));
    }

    protected void setupForFill(Pattern pattern) {
        this.mGraphics.setPaint(pattern);
        this.mGraphics.setComposite(this.getCompositeFor(8));
    }

    protected void setupForErase() {
        this.mGraphics.setPaint(this.mBackground);
        this.mGraphics.setComposite(this.getCompositeFor(8));
    }

    protected void setupForInvert() {
        this.mGraphics.setColor(Color.BLACK);
        this.mGraphics.setXORMode(Color.WHITE);
    }

    public void moveTo(double d, double d2) {
        this.mPenPosition.setLocation(d, d2);
    }

    public final void moveTo(Point2D point2D) {
        this.moveTo(point2D.getX(), point2D.getY());
    }

    public final void move(double d, double d2) {
        this.moveTo(this.mPenPosition.getX() + d, this.mPenPosition.getY() + d2);
    }

    public void lineTo(double d, double d2) {
        Line2D.Double double_ = new Line2D.Double(this.mPenPosition.getX(), this.mPenPosition.getY(), d, d2);
        if (this.isPenVisible()) {
            this.paintShape(this.mGraphics.getStroke().createStrokedShape(double_));
        }
        this.moveTo(d, d2);
    }

    public final void lineTo(Point2D point2D) {
        this.lineTo(point2D.getX(), point2D.getY());
    }

    public final void line(double d, double d2) {
        this.lineTo(this.mPenPosition.getX() + d, this.mPenPosition.getY() + d2);
    }

    public void frameRect(Rectangle2D rectangle2D) {
        this.frameShape(rectangle2D);
    }

    public void paintRect(Rectangle2D rectangle2D) {
        this.paintShape(rectangle2D);
    }

    public void fillRect(Rectangle2D rectangle2D, Pattern pattern) {
        this.fillShape(rectangle2D, pattern);
    }

    public void eraseRect(Rectangle2D rectangle2D) {
        this.eraseShape(rectangle2D);
    }

    public void invertRect(Rectangle2D rectangle2D) {
        this.invertShape(rectangle2D);
    }

    private static RoundRectangle2D.Double toRoundRect(Rectangle2D rectangle2D, int n, int n2) {
        return new RoundRectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), n, n2);
    }

    public void frameRoundRect(Rectangle2D rectangle2D, int n, int n2) {
        this.frameShape(QuickDrawContext.toRoundRect(rectangle2D, n, n2));
    }

    public void paintRoundRect(Rectangle2D rectangle2D, int n, int n2) {
        this.paintShape(QuickDrawContext.toRoundRect(rectangle2D, n, n2));
    }

    public void fillRoundRect(Rectangle2D rectangle2D, int n, int n2, Pattern pattern) {
        this.fillShape(QuickDrawContext.toRoundRect(rectangle2D, n, n2), pattern);
    }

    public void eraseRoundRect(Rectangle2D rectangle2D, int n, int n2) {
        this.eraseShape(QuickDrawContext.toRoundRect(rectangle2D, n, n2));
    }

    public void invertRoundRect(Rectangle2D rectangle2D, int n, int n2) {
        this.invertShape(QuickDrawContext.toRoundRect(rectangle2D, n, n2));
    }

    private static Ellipse2D.Double toOval(Rectangle2D rectangle2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        double_.setFrame(rectangle2D);
        return double_;
    }

    public void frameOval(Rectangle2D rectangle2D) {
        this.frameShape(QuickDrawContext.toOval(rectangle2D));
    }

    public void paintOval(Rectangle2D rectangle2D) {
        this.paintShape(QuickDrawContext.toOval(rectangle2D));
    }

    public void fillOval(Rectangle2D rectangle2D, Pattern pattern) {
        this.fillShape(QuickDrawContext.toOval(rectangle2D), pattern);
    }

    public void eraseOval(Rectangle2D rectangle2D) {
        this.eraseShape(QuickDrawContext.toOval(rectangle2D));
    }

    public void invertOval(Rectangle2D rectangle2D) {
        this.invertShape(QuickDrawContext.toOval(rectangle2D));
    }

    private static Arc2D.Double toArc(Rectangle2D rectangle2D, int n, int n2, boolean bl) {
        return new Arc2D.Double(rectangle2D, 90 - n, -n2, bl ? 2 : 0);
    }

    public void frameArc(Rectangle2D rectangle2D, int n, int n2) {
        this.frameShape(QuickDrawContext.toArc(rectangle2D, n, n2, false));
    }

    public void paintArc(Rectangle2D rectangle2D, int n, int n2) {
        this.paintShape(QuickDrawContext.toArc(rectangle2D, n, n2, true));
    }

    public void fillArc(Rectangle2D rectangle2D, int n, int n2, Pattern pattern) {
        this.fillShape(QuickDrawContext.toArc(rectangle2D, n, n2, true), pattern);
    }

    public void eraseArc(Rectangle2D rectangle2D, int n, int n2) {
        this.eraseShape(QuickDrawContext.toArc(rectangle2D, n, n2, true));
    }

    public void invertArc(Rectangle2D rectangle2D, int n, int n2) {
        this.invertShape(QuickDrawContext.toArc(rectangle2D, n, n2, true));
    }

    public void framePoly(Polygon polygon) {
        this.frameShape(polygon);
    }

    public void paintPoly(Polygon polygon) {
        this.paintShape(polygon);
    }

    public void fillPoly(Polygon polygon, Pattern pattern) {
        this.fillShape(polygon, pattern);
    }

    public void erasePoly(Polygon polygon) {
        this.eraseShape(polygon);
    }

    public void invertPoly(Polygon polygon) {
        this.invertShape(polygon);
    }

    public void frameRegion(Area area) {
        this.frameShape(area);
    }

    public void paintRegion(Area area) {
        this.paintShape(area);
    }

    public void fillRegion(Area area, Pattern pattern) {
        this.fillShape(area, pattern);
    }

    public void eraseRegion(Area area) {
        this.eraseShape(area);
    }

    public void invertRegion(Area area) {
        this.invertShape(area);
    }

    private void frameShape(Shape shape) {
        this.setupForPaint();
        this.mGraphics.draw(shape);
    }

    private void paintShape(Shape shape) {
        this.setupForPaint();
        this.mGraphics.fill(shape);
    }

    private void fillShape(Shape shape, Pattern pattern) {
        this.setupForFill(pattern);
        this.mGraphics.fill(shape);
    }

    private void invertShape(Shape shape) {
        this.setupForInvert();
        this.mGraphics.fill(shape);
    }

    private void eraseShape(Shape shape) {
        this.setupForErase();
        this.mGraphics.fill(shape);
    }

    public void copyBits(BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2, int n, Shape shape) {
        this.mGraphics.setComposite(this.getCompositeFor(n));
        if (shape != null) {
            this.setClipRegion(shape);
        }
        this.mGraphics.drawImage(bufferedImage, rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
    }

    public void copyMask(BufferedImage bufferedImage, BufferedImage bufferedImage2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n, Shape shape) {
        throw new UnsupportedOperationException("Method copyBits not implemented");
    }

    public void copyDeepMask(BufferedImage bufferedImage, BufferedImage bufferedImage2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n, Shape shape) {
        throw new UnsupportedOperationException("Method copyBits not implemented");
    }

    public void drawString(String string) {
        this.mGraphics.drawString(string, (float)this.getPenPosition().getX(), (float)this.getPenPosition().getY());
    }

    static class RectangleStroke
    implements Stroke {
        private Shape[] mShapes;
        private boolean repeat = true;
        private AffineTransform mTransform = new AffineTransform();
        private static final float FLATNESS = 1.0f;

        public RectangleStroke(Shape shape) {
            this(new Shape[]{shape});
        }

        RectangleStroke(Shape[] shapeArray) {
            this.mShapes = new Shape[shapeArray.length];
            int n = 0;
            while (n < this.mShapes.length) {
                Rectangle2D rectangle2D = shapeArray[n].getBounds2D();
                this.mTransform.setToTranslation(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
                this.mShapes[n] = this.mTransform.createTransformedShape(shapeArray[n]);
                ++n;
            }
        }

        @Override
        public Shape createStrokedShape(Shape shape) {
            GeneralPath generalPath = new GeneralPath();
            FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
            float[] fArray = new float[6];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            int n = 0;
            float f7 = 0.0f;
            int n2 = 0;
            int n3 = this.mShapes.length;
            while (n2 < n3 && !flatteningPathIterator.isDone()) {
                n = flatteningPathIterator.currentSegment(fArray);
                switch (n) {
                    case 0: {
                        f = f3 = fArray[0];
                        f2 = f4 = fArray[1];
                        generalPath.moveTo(f, f2);
                        f7 = 0.0f;
                        break;
                    }
                    case 4: {
                        fArray[0] = f;
                        fArray[1] = f2;
                    }
                    case 1: {
                        f5 = fArray[0];
                        f6 = fArray[1];
                        float f8 = f5 - f3;
                        float f9 = f6 - f4;
                        float f10 = (float)Math.sqrt(f8 * f8 + f9 * f9);
                        if (f10 >= f7) {
                            float f11 = 1.0f / f10;
                            while (n2 < n3 && f10 >= f7) {
                                float f12 = f3 + f7 * f8 * f11;
                                float f13 = f4 + f7 * f9 * f11;
                                this.mTransform.setToTranslation(f12, f13);
                                generalPath.append(this.mTransform.createTransformedShape(this.mShapes[n2]), false);
                                f7 += 1.0f;
                                ++n2;
                                if (!this.repeat) continue;
                                n2 %= n3;
                            }
                        }
                        f7 -= f10;
                        f3 = f5;
                        f4 = f6;
                    }
                }
                flatteningPathIterator.next();
            }
            return generalPath;
        }
    }
}

