/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.QTDecompressor;
import com.twelvemonkeys.imageio.plugins.pict.QuickTime;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;

final class QTRAWDecompressor
extends QTDecompressor {
    QTRAWDecompressor() {
    }

    @Override
    public boolean canDecompress(QuickTime.ImageDesc imageDesc) {
        return "appl".equals(imageDesc.compressorVendor) && "raw ".equals(imageDesc.compressorIdentifer) && (imageDesc.depth == 24 || imageDesc.depth == 32);
    }

    @Override
    public BufferedImage decompress(QuickTime.ImageDesc imageDesc, InputStream inputStream) throws IOException {
        WritableRaster writableRaster;
        byte[] byArray = new byte[imageDesc.dataSize];
        try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
            dataInputStream.readFully(byArray, 0, imageDesc.dataSize);
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        switch (imageDesc.depth) {
            case 40: {
                writableRaster = Raster.createInterleavedRaster(dataBufferByte, imageDesc.width, imageDesc.height, imageDesc.width, 1, new int[1], null);
                break;
            }
            case 24: {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                writableRaster = Raster.createInterleavedRaster(dataBufferByte, imageDesc.width, imageDesc.height, imageDesc.width * 3, 3, nArray, null);
                break;
            }
            case 32: {
                int n = 0;
                while (n < imageDesc.height) {
                    int n2 = 0;
                    while (n2 < imageDesc.width) {
                        int n3 = 4 * n * imageDesc.width + n2 * 4;
                        byte by = byArray[n3 + 1];
                        byArray[n3 + 1] = byArray[n3 + 3];
                        byArray[n3 + 3] = by;
                        ++n2;
                    }
                    ++n;
                }
                int[] nArray = new int[4];
                nArray[0] = 3;
                nArray[1] = 2;
                nArray[2] = 1;
                writableRaster = Raster.createInterleavedRaster(dataBufferByte, imageDesc.width, imageDesc.height, imageDesc.width * 4, 4, nArray, null);
                break;
            }
            default: {
                throw new IIOException("Unsupported RAW depth: " + imageDesc.depth);
            }
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(imageDesc.depth <= 32 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003), imageDesc.depth == 32, false, imageDesc.depth == 32 ? 3 : 1, 0);
        return new BufferedImage(componentColorModel, writableRaster, componentColorModel.isAlphaPremultiplied(), null);
    }
}

