/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.io.FastByteArrayOutputStream;
import com.twelvemonkeys.io.enc.EncoderStream;
import com.twelvemonkeys.io.enc.PackBitsEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public class PICTImageWriter
extends ImageWriterBase {
    private int mRowBytes;
    private byte[] mScanlineBytes;
    private int mScanWidthLeft;

    public PICTImageWriter() {
        this(null);
    }

    protected PICTImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    private void writePICTHeader(RenderedImage renderedImage) throws IOException {
        byte[] byArray = new byte[512];
        this.mImageOutput.write(byArray);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeShort(17);
        this.mImageOutput.writeShort(767);
        this.mImageOutput.writeShort(3072);
        this.mImageOutput.writeInt(-131072);
        this.mImageOutput.writeShort(72);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(72);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeInt(0);
        this.mImageOutput.writeShort(30);
        this.mImageOutput.writeShort(1);
        this.mImageOutput.writeShort(10);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeShort(154);
        this.mImageOutput.writeInt(255);
        this.mRowBytes = 4 * renderedImage.getWidth();
        this.mImageOutput.writeShort(0x8000 | this.mRowBytes);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(4);
        this.mImageOutput.writeInt(0);
        this.mImageOutput.writeShort(72);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(72);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(16);
        this.mImageOutput.writeShort(32);
        this.mImageOutput.writeShort(3);
        this.mImageOutput.writeShort(8);
        this.mImageOutput.writeInt(0);
        this.mImageOutput.writeInt(0);
        this.mImageOutput.writeInt(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(0);
        this.mImageOutput.writeShort(renderedImage.getHeight());
        this.mImageOutput.writeShort(renderedImage.getWidth());
        this.mImageOutput.writeShort(0);
        this.mScanlineBytes = new byte[3 * renderedImage.getWidth()];
        this.mScanWidthLeft = renderedImage.getWidth();
    }

    private void writePICTData(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(this.mScanlineBytes.length / 2);
        int n7 = colorModel.getNumComponents();
        int n8 = 0;
        while (n8 < n4) {
            this.mScanWidthLeft -= n3;
            int n9 = 0;
            while (n9 < n3) {
                if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().getType() == 5) {
                    this.mScanlineBytes[n + n9] = byArray[n5 + n8 * n6 * n7 + n7 * n9 + 2];
                    this.mScanlineBytes[n + n3 + n9] = byArray[n5 + n8 * n6 * n7 + n7 * n9 + 1];
                    this.mScanlineBytes[n + 2 * n3 + n9] = byArray[n5 + n8 * n6 * n7 + n7 * n9];
                } else {
                    int n10 = colorModel.getRGB(byArray[n5 + n8 * n6 + n9] & 0xFF);
                    this.mScanlineBytes[n + n9] = (byte)(n10 >> 16 & 0xFF);
                    this.mScanlineBytes[n + n3 + n9] = (byte)(n10 >> 8 & 0xFF);
                    this.mScanlineBytes[n + 2 * n3 + n9] = (byte)(n10 & 0xFF);
                }
                ++n9;
            }
            if (this.mScanWidthLeft == 0) {
                fastByteArrayOutputStream.reset();
                DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(fastByteArrayOutputStream, new PackBitsEncoder(), true));
                dataOutputStream.write(this.mScanlineBytes);
                if (this.mRowBytes > 250) {
                    this.mImageOutput.writeShort(fastByteArrayOutputStream.size());
                } else {
                    this.mImageOutput.writeByte(fastByteArrayOutputStream.size());
                }
                ((ByteArrayOutputStream)fastByteArrayOutputStream).writeTo(IIOUtil.createStreamAdapter(this.mImageOutput));
                this.mScanWidthLeft = n3;
            }
            ++n8;
        }
    }

    private void writePICTData(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) throws IOException {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(this.mScanlineBytes.length / 2);
        int n7 = 0;
        while (n7 < n4) {
            this.mScanWidthLeft -= n3;
            int n8 = 0;
            while (n8 < n3) {
                int n9 = colorModel.getRGB(nArray[n5 + n7 * n6 + n8]);
                this.mScanlineBytes[n + n8] = (byte)(n9 >> 16 & 0xFF);
                this.mScanlineBytes[n + n3 + n8] = (byte)(n9 >> 8 & 0xFF);
                this.mScanlineBytes[n + 2 * n3 + n8] = (byte)(n9 & 0xFF);
                ++n8;
            }
            if (this.mScanWidthLeft == 0) {
                fastByteArrayOutputStream.reset();
                DataOutputStream dataOutputStream = new DataOutputStream(new EncoderStream(fastByteArrayOutputStream, new PackBitsEncoder(), true));
                dataOutputStream.write(this.mScanlineBytes);
                if (this.mRowBytes > 250) {
                    this.mImageOutput.writeShort(fastByteArrayOutputStream.size());
                } else {
                    this.mImageOutput.writeByte(fastByteArrayOutputStream.size());
                }
                ((ByteArrayOutputStream)fastByteArrayOutputStream).writeTo(IIOUtil.createStreamAdapter(this.mImageOutput));
                this.mScanWidthLeft = n3;
            }
            ++n7;
        }
    }

    private void writePICTTrailer() throws IOException {
        long l = this.mImageOutput.length();
        if (l == -1L) {
            throw new IIOException("Cannot write trailer without knowing length");
        }
        if ((l & 1L) > 0L) {
            this.mImageOutput.writeByte(0);
        }
        this.mImageOutput.writeShort(255);
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.assertOutput();
        if (iIOImage.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write raster");
        }
        this.processImageStarted(0);
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        this.writePICTHeader(renderedImage);
        Raster raster = renderedImage instanceof BufferedImage ? ((BufferedImage)renderedImage).getRaster() : renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            this.writePICTData(0, 0, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getColorModel(), ((DataBufferByte)dataBuffer).getData(), 0, renderedImage.getWidth());
        } else if (dataBuffer instanceof DataBufferInt) {
            this.writePICTData(0, 0, renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getColorModel(), ((DataBufferInt)dataBuffer).getData(), 0, renderedImage.getWidth());
        } else {
            throw new IIOException("DataBuffer type " + dataBuffer.getDataType() + " not supported");
        }
        this.writePICTTrailer();
        this.processImageComplete();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method getDefaultImageMetadata not implemented");
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        throw new UnsupportedOperationException("Method convertImageMetadata not implemented");
    }
}

